/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import java.util.ArrayList;

public class WWAuthMessage {
    public static final int ERR_CANCEL = 1;
    public static final int ERR_OK = 0;
    public static final int ERR_FAIL = 2;

    public static class Resp
    extends WWBaseRespMessage {
        public String code;
        public String state;

        @Override
        public int getType() {
            return 2001;
        }

        @Override
        public void toBundle(Bundle var1) {
            super.toBundle(var1);
            var1.putString("_wwauthrsp_code", this.code);
            var1.putString("_wwauthrsp_state", this.state);
            var1.putInt("_wwauthrsp_err", this.errCode);
            var1.putString("_wwauthrsp_errmsg", this.errMsg);
        }

        @Override
        public void fromBundle(Bundle var1) {
            super.fromBundle(var1);
            this.code = var1.getString("_wwauthrsp_code");
            this.state = var1.getString("_wwauthrsp_state");
            this.errCode = var1.getInt("_wwauthrsp_err", 1);
            this.errMsg = var1.getString("_wwauthrsp_errmsg");
        }

        @Override
        public Uri toUri() {
            Uri uri = super.toUri();
            uri = uri.buildUpon().authority("sso").appendQueryParameter("code", this.code == null ? "" : this.code).appendQueryParameter("state", this.state == null ? "" : this.state).build();
            return uri;
        }

        @Override
        public void fromUri(Uri uri) {
            this.errCode = 2;
            super.fromUri(uri);
            if (uri == null) {
                return;
            }
            try {
                if (Integer.parseInt(uri.getQueryParameter("cancel")) == 1) {
                    this.errCode = 1;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String err = uri.getQueryParameter("error");
                if (!TextUtils.isEmpty((CharSequence)err)) {
                    this.errMsg = err;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.code = uri.getQueryParameter("code");
            this.state = uri.getQueryParameter("state");
            if (!TextUtils.isEmpty((CharSequence)this.code)) {
                this.errCode = 0;
            }
        }
    }

    public static class Req
    extends WWBaseMessage {
        public String state;
        public String sch;
        public ArrayList<String> scopes;

        public Req() {
        }

        public Req(String stat, String schema) {
            this.state = stat;
            this.sch = schema;
            this.schema = schema;
        }

        @Override
        public int getType() {
            return 1001;
        }

        @Override
        public boolean checkArgs() {
            return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.sch);
        }

        @Override
        public void toBundle(Bundle var1) {
            var1.putString("_wwauthmsg_state", this.state);
            var1.putString("_wwauthmsg_schema", this.sch);
            var1.putStringArrayList("scopes", this.scopes);
            super.toBundle(var1);
        }

        @Override
        public void fromBundle(Bundle var1) {
            this.state = var1.getString("_wwauthmsg_state");
            this.sch = var1.getString("_wwauthmsg_schema");
            this.scopes = var1.getStringArrayList("scopes");
            super.fromBundle(var1);
            if (TextUtils.isEmpty((CharSequence)this.schema)) {
                this.schema = this.sch;
            }
        }

        @Override
        public WWBaseRespMessage NewRsp() {
            Resp ret = new Resp();
            this.initRsp(ret);
            return ret;
        }
    }
}

