/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.util;

import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflecterHelper {
    private static final String LOG_TAG = "ReflecterHelper";
    public static Class<?> mCurrentClass;

    public static final boolean setClass(String name) {
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        mCurrentClass = tmpClass;
        return mCurrentClass != null;
    }

    public static final int getStaticIntValue(String name, int defvalue) {
        int result = defvalue;
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static final int getIntValue(Object owner, String name, int defvalue) {
        int result = defvalue;
        ReflecterHelper.setClass(owner.getClass().getName());
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(owner);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static final Field getField(String name) {
        Field field = null;
        try {
            field = mCurrentClass.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    public static Object getStaticProperty(String className, String fieldName) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        Object result = null;
        if (field != null) {
            try {
                result = field.get(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void setStaticProperty(String className, String fieldName, Object value) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        if (field != null) {
            try {
                field.set(null, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object newInstance(String className, Object[] args) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getDeclaredConstructor(ReflecterHelper.getArgsClasses(args));
        cons.setAccessible(true);
        return cons.newInstance(args);
    }

    public static Object newInstance(String className) throws Exception {
        return ReflecterHelper.newInstance(className, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, ReflecterHelper.getArgsClasses(args), args);
    }

    public static Object invokeMethod(Object owner, String methodName) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Class<?>[] argsClass, Object[] args) throws Exception {
        Method method;
        block3: {
            Class<?> ownerClass = owner.getClass();
            method = null;
            try {
                method = ownerClass.getDeclaredMethod(methodName, argsClass);
            }
            catch (Exception e) {
                if (method == null && ownerClass.getSuperclass() != null) {
                    method = ownerClass.getSuperclass().getDeclaredMethod(methodName, argsClass);
                }
                if (method != null) break block3;
                throw e;
            }
        }
        method.setAccessible(true);
        return method.invoke(owner, args);
    }

    public static Object getProperty(Object owner, String fieldName) throws Exception {
        Field field = ReflecterHelper.getFieldInternal(owner, fieldName);
        field.setAccessible(true);
        Object property = field.get(owner);
        return property;
    }

    public static boolean setPropertyNoThrowable(Object owner, String fieldName, Object value) {
        try {
            ReflecterHelper.setPropertyInternal(owner, fieldName, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setProperty(Object owner, String fieldName, Object value) throws Exception {
        ReflecterHelper.setPropertyInternal(owner, fieldName, value);
    }

    private static void setPropertyInternal(Object owner, String fieldName, Object value) throws Exception {
        if (null == owner) {
            throw new NullPointerException("setProperty null owner");
        }
        Field field = ReflecterHelper.getFieldInternal(owner, fieldName);
        field.setAccessible(true);
        field.set(owner, value);
    }

    private static Field getFieldInternal(Object owner, String fieldName) throws NoSuchFieldException {
        Class<?> cls = null;
        Field field = null;
        for (cls = owner.getClass(); null != cls; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                field = null;
                continue;
            }
        }
        if (null == field) {
            throw new NoSuchFieldException("setProperty field " + fieldName + " not found");
        }
        return field;
    }

    public static Object newInstance(String className, Object[] args, Class<?>[] argsClass) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getDeclaredConstructor(argsClass);
        cons.setAccessible(true);
        return cons.newInstance(args);
    }

    public static void dump(Class<?> cls) {
        Method[] methods;
        Log.v((String)LOG_TAG, (String)cls.getCanonicalName());
        for (Method method : methods = cls.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            StringBuilder sb = new StringBuilder();
            sb.append("  - ");
            sb.append(method.getReturnType());
            sb.append(' ');
            sb.append(method.getName());
            sb.append('(');
            int length = params.length;
            for (int i = 0; i != length; ++i) {
                sb.append(params[i].getName());
                if (i == length - 1) continue;
                sb.append(", ");
            }
            sb.append(')');
            Log.v((String)LOG_TAG, (String)sb.toString());
        }
    }

    public static Method reflectStaticMethod(String className, String methodName, Class<?>[] argsClass) throws Exception {
        Class<?> cls = Class.forName(className);
        return ReflecterHelper.reflectStaticMethod(cls, methodName, argsClass);
    }

    public static Method reflectStaticMethod(Class<?> cls, String methodName, Class<?>[] argsClass) throws Exception {
        Method staticMethod;
        block3: {
            staticMethod = null;
            try {
                staticMethod = cls.getDeclaredMethod(methodName, argsClass);
            }
            catch (Exception e) {
                if (staticMethod == null && cls.getSuperclass() != null) {
                    staticMethod = cls.getSuperclass().getDeclaredMethod(methodName, argsClass);
                }
                if (staticMethod != null) break block3;
                throw e;
            }
        }
        staticMethod.setAccessible(true);
        return staticMethod;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args, Class<?>[] argsClass) throws Exception {
        Object ret;
        Method staticMethod;
        Class<?> cls;
        block3: {
            cls = Class.forName(className);
            staticMethod = null;
            ret = null;
            try {
                staticMethod = cls.getDeclaredMethod(methodName, argsClass);
            }
            catch (Exception e) {
                if (staticMethod == null && cls.getSuperclass() != null) {
                    staticMethod = cls.getSuperclass().getDeclaredMethod(methodName, argsClass);
                }
                if (staticMethod != null) break block3;
                throw e;
            }
        }
        staticMethod.setAccessible(true);
        ret = staticMethod.invoke(cls, args);
        return ret;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, args, ReflecterHelper.getArgsClasses(args));
    }

    public static Object invokeStaticMethod(String className, String methodName) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, null);
    }

    private static Class<?>[] getArgsClasses(Object[] args) {
        Class[] argsClass = null;
        if (args != null) {
            argsClass = new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                argsClass[i] = args[i] != null ? args[i].getClass() : String.class;
                if (argsClass[i] == Integer.class) {
                    argsClass[i] = Integer.TYPE;
                    continue;
                }
                if (argsClass[i] == Boolean.class) {
                    argsClass[i] = Boolean.TYPE;
                    continue;
                }
                if (argsClass[i] != Long.class) continue;
                argsClass[i] = Long.TYPE;
            }
        }
        return argsClass;
    }

    public static Field[] getDeclaredFields(Object clsObj) {
        Field[] fieldList = null;
        if (clsObj != null) {
            try {
                Class<?> ownerClass = clsObj.getClass();
                if (ownerClass != null) {
                    fieldList = ownerClass.getDeclaredFields();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldList;
    }

    public static Method[] getDeclaredMethods(Object clsObj) {
        Method[] methodList = null;
        if (clsObj != null) {
            try {
                Class<?> ownerClass = clsObj.getClass();
                if (ownerClass != null) {
                    methodList = ownerClass.getDeclaredMethods();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return methodList;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

