/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.WWMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class WWMediaConversation
extends WWMediaMessage.WWMediaObject {
    private static final String TAG = "WWAPI.WWMediaConv";
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final int PATH_LENGTH_LIMIT = 10240;
    public String name;
    public long date;
    public byte[] avatarData;
    public String avatarPath;
    public WWMediaMessage.WWMediaObject message;

    public WWMediaConversation() {
    }

    public WWMediaConversation(byte[] avatarDataInit) {
        this.avatarData = avatarDataInit;
    }

    public WWMediaConversation(Bitmap avatar) {
        try {
            ByteArrayOutputStream var2 = new ByteArrayOutputStream();
            avatar.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)var2);
            this.avatarData = var2.toByteArray();
            var2.close();
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public boolean checkArgs() {
        if (!super.checkArgs()) {
            return false;
        }
        if (this.avatarData != null && this.avatarData.length > 0xA00000) {
            Log.d((String)TAG, (String)"checkArgs fail, content is too large");
            return false;
        }
        if (this.avatarPath != null && this.avatarPath.length() > 10240) {
            Log.d((String)TAG, (String)"checkArgs fail, path is invalid");
            return false;
        }
        if (this.avatarPath != null && this.getFileSize(this.avatarPath) > 0xA00000) {
            Log.d((String)TAG, (String)"checkArgs fail, image content is too large");
            return false;
        }
        return this.message != null && this.message.checkArgs();
    }

    @Override
    public void toBundle(Bundle var1) {
        super.toBundle(var1);
        var1.putString("_wwconvobject_name", this.name);
        var1.putLong("_wwconvobject_date", this.date);
        var1.putByteArray("_wwconvobject_avatarData", this.avatarData);
        var1.putString("_wwconvobject_avatarPath", this.avatarPath);
        var1.putBundle("_wwconvobject_message", BaseMessage.pack(this.message));
    }

    @Override
    public void fromBundle(Bundle var1) {
        super.fromBundle(var1);
        this.name = var1.getString("_wwconvobject_name");
        this.date = var1.getLong("_wwconvobject_date");
        this.avatarData = var1.getByteArray("_wwconvobject_avatarData");
        this.avatarPath = var1.getString("_wwconvobject_avatarPath");
        try {
            this.message = (WWMediaMessage.WWMediaObject)BaseMessage.parse(var1.getBundle("_wwconvobject_message"));
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"fromBundle", (Throwable)e);
        }
    }

    @Override
    public void adjustIntent(Intent i, String pkg) {
        try {
            this.message.adjustIntent(i, pkg);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"adjustIntent", (Throwable)e);
        }
    }

    @Override
    public void setDestPkg(String p) {
        super.setDestPkg(p);
        try {
            this.message.setDestPkg(p);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"setDestPkg", (Throwable)e);
        }
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        try {
            this.message.setContext(context);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)"setContext", (Throwable)e);
        }
    }
}

