/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.util;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.wework.api.model.OpenData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpenDataUtils {
    public static List<String> deprocessOA(byte[] data, String key) {
        ArrayList<String> d = new ArrayList<String>();
        try {
            String[] array;
            String dStr = OpenDataUtils.deprocess(data, key);
            for (String s : array = dStr.split(",")) {
                d.add(s);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return d;
    }

    public static byte[] processOA(List<String> data, String key) {
        try {
            StringBuffer a = new StringBuffer();
            for (String d : data) {
                if (TextUtils.isEmpty((CharSequence)d)) continue;
                if (!TextUtils.isEmpty((CharSequence)a)) {
                    a.append(",");
                }
                a.append(d);
            }
            return OpenDataUtils.process(a.toString(), key);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] processOD(List<OpenData> data, String key) {
        try {
            JSONArray a = new JSONArray();
            for (OpenData d : data) {
                if (d == null || TextUtils.isEmpty((CharSequence)d.id)) continue;
                JSONObject jo = new JSONObject();
                jo.put("t", d.type);
                jo.put("n", (Object)d.name);
                jo.put("i", (Object)d.id);
                a.put((Object)jo);
            }
            return OpenDataUtils.process(a.toString(), key);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<OpenData> deprocessOD(byte[] data, String key) {
        ArrayList<OpenData> d = new ArrayList<OpenData>();
        try {
            String dStr = OpenDataUtils.deprocess(data, key);
            JSONArray ja = new JSONArray(dStr);
            for (int i = 0; i < ja.length(); ++i) {
                OpenData od = new OpenData();
                od.type = ja.getJSONObject(i).optInt("t");
                od.id = ja.getJSONObject(i).optString("i");
                od.name = ja.getJSONObject(i).optString("n");
                d.add(od);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return d;
    }

    public static byte[] process(String data, String key) {
        try {
            return OpenDataUtils.encrytAES(OpenDataUtils.compress(data.getBytes("UTF-8")), key);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String deprocess(byte[] data, String key) {
        try {
            return new String(OpenDataUtils.decompress(OpenDataUtils.decrytAES(data, key)), "UTF-8");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] encrytAES(byte[] content, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(OpenDataUtils.adjustKey(key).getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKeySpec);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Throwable var5) {
            var5.printStackTrace();
            return null;
        }
    }

    private static String adjustKey(String key) {
        if (key.length() >= 32) {
            return key.substring(0, 32);
        }
        StringBuilder sb = new StringBuilder(key);
        while (sb.length() < 32) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static byte[] decrytAES(byte[] content, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(OpenDataUtils.adjustKey(key).getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKeySpec);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] decompress) {
        Closeable[] closeables = new Closeable[]{null, null, null};
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(decompress);
            closeables[1] = bis;
            DeflaterInputStream dis = new DeflaterInputStream(bis);
            closeables[0] = dis;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            closeables[2] = bos;
            int c = 0;
            byte[] buf = new byte[1024];
            while ((c = dis.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            for (Closeable c : closeables) {
                try {
                    c.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] compress) {
        Closeable[] closeables = new Closeable[]{null, null, null};
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(compress);
            closeables[1] = bis;
            InflaterInputStream iis = new InflaterInputStream(bis);
            closeables[0] = iis;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            closeables[2] = bos;
            int c = 0;
            byte[] buf = new byte[1024];
            while ((c = iis.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            for (Closeable c : closeables) {
                try {
                    c.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addBundle(Context ctx, String thirdPkg, String wwPkg, Bundle b) {
        Object cr = null;
        try {
            Uri u = new Uri.Builder().scheme("content").authority(wwPkg + ".wwapi").appendPath("bundle").appendQueryParameter("pakage", thirdPkg).build();
            Log.v((String)"wwapi addBundle", (String)u.toString());
            ContentValues cv = new ContentValues();
            cv.put("data", OpenDataUtils.marshall((Parcelable)b));
            u = ctx.getContentResolver().insert(u, cv);
            long l = ContentUris.parseId((Uri)u);
            return l;
        }
        catch (Throwable e) {
            Log.v((String)"wwapi", (String)e.toString());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle getBundle(Context ctx, String thirdPkg, String wwPkg, long id) {
        try (Cursor cr = null;){
            Uri u = new Uri.Builder().scheme("content").authority(wwPkg + ".wwapi").appendPath("bundle").appendQueryParameter("pakage", thirdPkg).build();
            u = ContentUris.withAppendedId((Uri)u, (long)id);
            Log.v((String)"wwapi getBundle", (String)u.toString());
            cr = ctx.getContentResolver().query(u, null, null, null, null);
            if (cr.moveToFirst()) {
                byte[] data = cr.getBlob(0);
                Bundle bundle = (Bundle)OpenDataUtils.unmarshall(data, Bundle.CREATOR);
                return bundle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transferFile(Context ctx, String pkg, String filePath) {
        FileInputStream is = null;
        OutputStream fos = null;
        try {
            int remain;
            File f = new File(filePath);
            Uri u = new Uri.Builder().scheme("content").authority(pkg + ".wwapi").appendPath("file").appendQueryParameter("name", f.getName()).appendQueryParameter("filepath", filePath).build();
            Log.v((String)"wwapi", (String)u.toString());
            fos = ctx.getContentResolver().openOutputStream(u);
            is = new FileInputStream(f);
            byte[] bytes = new byte[1024];
            while ((remain = is.read(bytes)) > 0) {
                fos.write(bytes, 0, remain);
            }
            String string = f.getName();
            return string;
        }
        catch (Throwable e) {
            Log.v((String)"wwapi", (String)e.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public static byte[] marshall(Parcelable parceable) {
        Parcel parcel = Parcel.obtain();
        parceable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    public static Parcel unmarshall(byte[] bytes) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        return parcel;
    }

    public static <T> T unmarshall(byte[] bytes, Parcelable.Creator<T> creator) {
        Parcel parcel = OpenDataUtils.unmarshall(bytes);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }
}

