/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.OpenData;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import com.tencent.wework.api.model.WWMediaMessage;
import com.tencent.wework.api.util.OpenDataUtils;
import java.util.List;

public class WWOpenChatWithMessage {

    public static class Resp
    extends WWBaseRespMessage {
        @Override
        public int getType() {
            return 2003;
        }

        @Override
        public Uri toUri() {
            Uri uri = super.toUri();
            uri = uri.buildUpon().authority("opendata").build();
            return uri;
        }
    }

    public static class Req
    extends WWBaseMessage {
        public String openUserID;
        public List<OpenData> contacts;
        public WWMediaMessage msg;

        public Req() {
        }

        public Req(String openUserID, String schema) {
            this.openUserID = openUserID;
            this.schema = schema;
        }

        @Override
        public int getType() {
            return 1003;
        }

        @Override
        public boolean checkArgs() {
            return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.schema) && !TextUtils.isEmpty((CharSequence)this.openUserID);
        }

        @Override
        public void toBundle(Bundle var1) {
            super.toBundle(var1);
            var1.putByteArray("_wwopenchatwmsg_openuserid", OpenDataUtils.process(this.openUserID, this.sKey));
            var1.putString("_wwopenchatwmsg_schema", this.schema);
            var1.putByteArray("_wwopenchatwmsg_data", OpenDataUtils.processOD(this.contacts, this.sKey));
            var1.putBundle("_wwopenchatwmsg_msg", BaseMessage.pack(this.msg));
        }

        @Override
        public void fromBundle(Bundle var1) {
            super.fromBundle(var1);
            this.openUserID = OpenDataUtils.deprocess(var1.getByteArray("_wwopenchatwmsg_openuserid"), this.sKey);
            this.schema = var1.getString("_wwopenchatwmsg_schema");
            this.contacts = OpenDataUtils.deprocessOD(var1.getByteArray("_wwopenchatwmsg_data"), this.sKey);
            this.msg = (WWMediaMessage)BaseMessage.parse(var1.getBundle("_wwopenchatwmsg_msg"));
        }

        @Override
        public void setNeedUpdateSession(boolean n) {
            this.needUpdateSession = n;
        }

        @Override
        public WWBaseRespMessage NewRsp() {
            Resp ret = new Resp();
            this.initRsp(ret);
            return ret;
        }
    }
}

