/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import com.tencent.wework.api.model.WWSimpleRespMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WWMediaMessage
extends WWBaseMessage {
    private static final String TAG = "WWAPI.WWMediaMessage";
    public static final int THUMB_LENGTH_LIMIT = 32768;
    private static final int TITLE_LENGTH_LIMIT = 512;
    private static final int DESCRIPTION_LENGTH_LIMIT = 1024;
    private static final int MEDIA_TAG_NAME_LENGTH_LIMIT = 64;
    private static final int MESSAGE_ACTION_LENGTH_LIMIT = 2048;
    private static final int MESSAGE_EXT_LENGTH_LIMIT = 2048;
    public String title;
    public String description;
    public byte[] thumbData;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void toBundle(Bundle var1) {
        super.toBundle(var1);
        var1.putString("_wwobject_title", this.title);
        var1.putString("_wwobject_description", this.description);
        var1.putByteArray("_wwobject_thumbdata", this.thumbData);
    }

    @Override
    public void fromBundle(Bundle var1) {
        super.fromBundle(var1);
        this.title = var1.getString("_wwobject_title");
        this.description = var1.getString("_wwobject_description");
        this.thumbData = var1.getByteArray("_wwobject_thumbdata");
    }

    public final void setThumbImage(Bitmap var1) {
        try {
            ByteArrayOutputStream var2 = new ByteArrayOutputStream();
            var1.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)var2);
            this.thumbData = var2.toByteArray();
            var2.close();
        }
        catch (Exception var3) {
            var3.printStackTrace();
            Log.d((String)TAG, (String)"put thumb failed");
        }
    }

    @Override
    public boolean checkArgs() {
        if (this.thumbData != null && this.thumbData.length > 32768) {
            Log.d((String)TAG, (String)"checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            Log.d((String)TAG, (String)"checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            Log.d((String)TAG, (String)"checkArgs fail, description is invalid");
            return false;
        }
        return true;
    }

    @Override
    public WWBaseRespMessage NewRsp() {
        WWSimpleRespMessage ret = new WWSimpleRespMessage();
        this.initRsp(ret);
        return ret;
    }

    public static abstract class WWMediaObject
    extends WWMediaMessage {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_IMAGE = 2;
        public static final int TYPE_URL = 5;
        public static final int TYPE_FILE = 6;
        public static final int TYPE_VIDEO = 7;
        public static final int TYPE_CONVERSATION = 8;
        public static final int TYPE_MERGED_CONVERSATION = 9;
        public static final int TYPE_LOC = 10;
        public static final int TYPE_WXA = 11;
        public static final int TYPE_SPH_FEED = 12;
        public static final int TYPE_SPH_TOPIC = 13;
        public static final int TYPE_SPH_PROFILE = 14;

        protected int getFileSize(String var1) {
            File var2;
            return var1 != null && var1.length() != 0 ? (!(var2 = new File(var1)).exists() ? 0 : (int)var2.length()) : 0;
        }
    }
}

