/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.tencent.wework.api.Callbacks;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.OpenData;
import com.tencent.wework.api.model.WWAuthMessage;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import com.tencent.wework.api.util.OpenDataUtils;
import com.tencent.wework.api.view.H5Activity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WWAPIImplLocal
implements IWWAPI {
    private static final String TAG = "WWAPIImplLocal";
    private final Context context;
    private String schema;
    public static final String LOCAL_PKG_SIGNATURE = "011A40266C8C75D181DDD8E4DDC50075";
    private static final String CCTV_PKG_SIGNATURE = "F5BF8B3B1B616EFEF88681716C061BA4";
    private static final String SXF_PKG_SIGNATURE = "99A7B5BDA8615128675831C01F208344";
    private static final String AZ_PKG_SIGNATURE = "B374B823AD2BF3F216AC8F67B86CE189";
    private static final String PKG_NAME = "com.tencent.wework";
    private static final String LOCAL_PKG_NAME = "com.tencent.weworklocal";
    private static final String SPECIAL_PKG_NAME = "com.tencent.wwgovernment";
    private static final String LOCAL_ENTERPRISE_PKG_NAME = "com.tencent.weworkenterprise";
    private static final String SCHEME_UNIFORM_WW_LOCAL = "wxwork";
    private static final String SCHEME_UNIFORM_GOV_LOCAL = "wxworkgovuniform";
    private static final ArrayList<String> PKG_NAMES = new ArrayList<String>(){
        {
            this.add(WWAPIImplLocal.PKG_NAME);
            this.add(WWAPIImplLocal.SPECIAL_PKG_NAME);
        }
    };
    private static final ArrayList<String> PKG_NAMES2 = new ArrayList<String>(){
        {
            this.add(WWAPIImplLocal.PKG_NAME);
        }
    };
    private static final ArrayList<String> ValidSignatureList = new ArrayList<String>(){
        {
            this.add(WWAPIImplLocal.LOCAL_PKG_SIGNATURE);
            this.add(WWAPIImplLocal.CCTV_PKG_SIGNATURE);
            this.add(WWAPIImplLocal.SXF_PKG_SIGNATURE);
            this.add(WWAPIImplLocal.AZ_PKG_SIGNATURE);
        }
    };
    private Map<String, IWWAPIEventHandler> callbacks = new HashMap<String, IWWAPIEventHandler>();
    private BroadcastReceiver mReciver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!WWAPIImplLocal.this.schema.equals(intent.getScheme())) {
                    return;
                }
                final BaseMessage msg = BaseMessage.parseUri(intent.getData());
                msg.setsKey(WWAPIImplLocal.this.mPreferences.getString("sk", ""));
                msg.fromBundle(intent.getExtras());
                if (msg instanceof WWBaseRespMessage) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((IWWAPIEventHandler)WWAPIImplLocal.this.callbacks.get(((WWBaseRespMessage)msg).transaction)).handleResp(msg);
                                WWAPIImplLocal.this.callbacks.remove(((WWBaseRespMessage)msg).transaction);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };
    private SharedPreferences mPreferences = null;

    WWAPIImplLocal(Context var0) {
        this.context = var0;
        this.mPreferences = var0.getSharedPreferences("wxwork_wwapi_store", 0);
    }

    @Override
    public boolean registerApp(String var1) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addDataScheme(var1);
        intentFilter.addAction(var1);
        this.context.registerReceiver(this.mReciver, intentFilter);
        this.schema = var1;
        return true;
    }

    @Override
    public void unregisterApp() {
    }

    @Override
    public boolean handleIntent(Intent intent, IWWAPIEventHandler handler) {
        return false;
    }

    @Override
    public boolean isWWAppInstalled() {
        for (String pkg : this.getWwPkgs()) {
            if (!this.isValidSignature(pkg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWWAppInstalled(IWWAPI.WWAppType appType) {
        if (appType == IWWAPI.WWAppType.WwAppTypeDefault) {
            return this.isValidSignature(PKG_NAME);
        }
        if (appType == IWWAPI.WWAppType.WwAppTypeWxwork) {
            Intent intentUniform = new Intent("com.tencent.wework.api.sharemsg", Uri.parse((String)"wxwork://jump"));
            return this.isValidSignature(PKG_NAME) || this.isValidSignature(SPECIAL_PKG_NAME) || this.isAppInstalled(intentUniform);
        }
        if (appType == IWWAPI.WWAppType.WwAppTypeLocal) {
            Intent intentUniform = new Intent("com.tencent.wework.api.sharemsg", Uri.parse((String)"wxworkgovuniform://jump"));
            return this.isValidSignature(SPECIAL_PKG_NAME) || this.isAppInstalled(intentUniform);
        }
        return false;
    }

    private boolean isAppInstalled(Intent intent) {
        List acts = this.context.getPackageManager().queryIntentActivities(intent, 65536);
        return acts.size() > 0;
    }

    private String getAppPackageName(Intent intent) {
        PackageManager packageManager = this.context.getPackageManager();
        List acts = packageManager.queryIntentActivities(intent, 65536);
        String packageName = "";
        if (acts.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)acts.get(0);
            packageName = resolveInfo.activityInfo.applicationInfo.packageName;
        }
        return packageName;
    }

    @Override
    public boolean isWWAppSupportAPI() {
        return this.getWWAppSupportAPI() >= 100;
    }

    @Override
    @NonNull
    public String getWWAppName() {
        String defaultName = "\u4f01\u4e1a\u5fae\u4fe1";
        Iterator<String> iterator = this.getWwPkgs().iterator();
        if (iterator.hasNext()) {
            String pkg = iterator.next();
            try {
                PackageManager pm = this.context.getPackageManager();
                ApplicationInfo info = pm.getApplicationInfo(pkg, 0);
                String name = pm.getApplicationLabel(info).toString();
                return TextUtils.isEmpty((CharSequence)name) ? "\u4f01\u4e1a\u5fae\u4fe1" : name;
            }
            catch (Throwable tr) {
                return "\u4f01\u4e1a\u5fae\u4fe1";
            }
        }
        return "\u4f01\u4e1a\u5fae\u4fe1";
    }

    @Override
    public String getWWAppName(IWWAPI.WWAppType appType) {
        if (appType == IWWAPI.WWAppType.WwAppTypeLocal) {
            return "\u653f\u52a1\u5fae\u4fe1";
        }
        return "\u4f01\u4e1a\u5fae\u4fe1";
    }

    @Override
    public int getWWAppSupportAPI() {
        for (String pkg : this.getWwPkgs()) {
            int versioncode = this.getVersioncode(pkg);
            if (versioncode == 0) continue;
            return versioncode;
        }
        return 0;
    }

    private int getVersioncode(String pkg) {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo(pkg, 128);
            return var1 == null ? 0 : var1.versionCode;
        }
        catch (Throwable tr) {
            return 0;
        }
    }

    @Override
    public boolean openWWApp() {
        for (String pkg : this.getWwPkgs()) {
            if (!this.isValidSignature(pkg)) continue;
            try {
                this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage(pkg));
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1) {
        var1.setsKey(this.mPreferences.getString("sk", ""));
        ArrayList<String> pkgs = PKG_NAMES2;
        if (var1 instanceof WWBaseMessage && TextUtils.equals((CharSequence)((WWBaseMessage)var1).appPkg, (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES;
        }
        if (this.context != null && TextUtils.equals((CharSequence)this.context.getPackageName(), (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES;
        }
        for (String pkg : pkgs) {
            if (!this.isValidSignature(pkg)) continue;
            Intent i = new Intent("com.tencent.wework.apihost");
            i.setClassName(pkg, "com.tencent.wework.apihost.WWAPIActivity");
            i.addFlags(0x18800000);
            try {
                var1.setDestPkg(pkg);
                var1.setContext(this.context);
                Bundle b = BaseMessage.pack(var1);
                long id2 = OpenDataUtils.addBundle(this.context, this.context.getPackageName(), pkg, b);
                if (id2 > 0L) {
                    i.putExtra("data_id", id2);
                    i.putExtra("data_pkg", this.context.getPackageName());
                } else {
                    i.putExtras(b);
                }
                i.putExtra("PendingIntent", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, this.mReciver.getClass()), (int)0xC000000));
                var1.adjustIntent(i, pkg);
                this.context.startActivity(i);
                return true;
            }
            catch (Throwable var2) {
                var2.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPI.WWAppType appType) {
        ArrayList<String> packageList = new ArrayList<String>();
        if (appType == IWWAPI.WWAppType.WwAppTypeDefault) {
            packageList.add(PKG_NAME);
        } else if (appType == IWWAPI.WWAppType.WwAppTypeWxwork) {
            packageList.add(PKG_NAME);
            packageList.add(LOCAL_ENTERPRISE_PKG_NAME);
        } else if (appType == IWWAPI.WWAppType.WwAppTypeLocal) {
            packageList.add(SPECIAL_PKG_NAME);
            packageList.add(LOCAL_PKG_NAME);
        }
        for (String pkg : packageList) {
            Intent intentUniform;
            if ((pkg.equals(PKG_NAME) || pkg.equals(SPECIAL_PKG_NAME)) && this.isValidSignature(pkg)) {
                Intent i = new Intent("com.tencent.wework.apihost");
                i.setClassName(pkg, "com.tencent.wework.apihost.WWAPIActivity");
                i.addFlags(0x18800000);
                try {
                    var1.setDestPkg(pkg);
                    var1.setContext(this.context);
                    Bundle b = BaseMessage.pack(var1);
                    long id2 = OpenDataUtils.addBundle(this.context, this.context.getPackageName(), pkg, b);
                    if (id2 > 0L) {
                        i.putExtra("data_id", id2);
                        i.putExtra("data_pkg", this.context.getPackageName());
                    } else {
                        i.putExtras(b);
                    }
                    i.putExtra("PendingIntent", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, this.mReciver.getClass()), (int)0xC000000));
                    var1.adjustIntent(i, pkg);
                    this.context.startActivity(i);
                    Log.i((String)TAG, (String)("sendMessage, start WWAPIActivity, pkg: " + pkg));
                    return true;
                }
                catch (Throwable tr) {
                    Log.w((String)TAG, (String)("sendMessage failed, pkg: " + pkg), (Throwable)tr);
                    continue;
                }
            }
            String scheme = "";
            String appPackageName = pkg;
            if (pkg.equals(LOCAL_ENTERPRISE_PKG_NAME)) {
                intentUniform = new Intent("com.tencent.wework.api.sharemsg", Uri.parse((String)"wxwork://jump"));
                if (this.isAppInstalled(intentUniform)) {
                    appPackageName = this.getAppPackageName(intentUniform);
                    if (!this.isValidSignature(appPackageName)) return false;
                    scheme = SCHEME_UNIFORM_WW_LOCAL;
                }
            } else {
                if (!pkg.equals(LOCAL_PKG_NAME)) continue;
                intentUniform = new Intent("com.tencent.wework.api.sharemsg", Uri.parse((String)"wxworkgovuniform://jump"));
                if (this.isAppInstalled(intentUniform)) {
                    appPackageName = this.getAppPackageName(intentUniform);
                    if (!this.isValidSignature(appPackageName)) return false;
                    scheme = SCHEME_UNIFORM_GOV_LOCAL;
                }
            }
            if (TextUtils.isEmpty((CharSequence)scheme)) continue;
            Uri data = Uri.parse((String)(scheme + "://jump"));
            Intent i = new Intent("com.tencent.wework.api.sharemsg", data);
            i.addFlags(0x18800000);
            try {
                var1.setDestPkg(appPackageName);
                var1.setContext(this.context);
                Bundle b = BaseMessage.pack(var1);
                long id3 = OpenDataUtils.addBundle(this.context, this.context.getPackageName(), appPackageName, b);
                if (id3 > 0L) {
                    i.putExtra("data_id", id3);
                    i.putExtra("data_pkg", this.context.getPackageName());
                } else {
                    i.putExtras(b);
                }
                i.putExtra("PendingIntent", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, this.mReciver.getClass()), (int)0xC000000));
                var1.adjustIntent(i, appPackageName);
                this.context.startActivity(i);
                Log.i((String)TAG, (String)("sendMessage, start WWAPIActivity, pkg: " + appPackageName + ",scheme:" + scheme + ", appType:" + (Object)((Object)appType)));
                return true;
            }
            catch (Throwable tr) {
                Log.w((String)TAG, (String)("sendMessage failed, pkg: " + appPackageName + ",scheme:" + scheme + ", appType:" + (Object)((Object)appType)), (Throwable)tr);
            }
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPIEventHandler callback) {
        if (var1 instanceof WWAuthMessage.Req && !this.isWWAppInstalled()) {
            Intent intent = new Intent(this.context, H5Activity.class);
            intent.putExtra("url", "https://open.work.weixin.qq.com/native/sso/auth/guide?appid=" + ((WWAuthMessage.Req)var1).appId);
            intent.addFlags(0x10000000);
            try {
                this.context.startActivity(intent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        if (this.sendMessage(var1)) {
            if (var1 instanceof WWBaseMessage) {
                this.callbacks.put(((WWBaseMessage)var1).transaction, callback);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPI.WWAppType appType, IWWAPIEventHandler callback) {
        if (this.sendMessage(var1, appType)) {
            if (var1 instanceof WWBaseMessage) {
                this.callbacks.put(((WWBaseMessage)var1).transaction, callback);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSessionKey(String key) {
        this.mPreferences.edit().putString("sk", key).commit();
    }

    @Override
    public void setSessionKeyUpdateCallack(Callbacks.SessionKeyUpdateCallback cb) {
    }

    @Override
    public void initOpenData(Callbacks.InitOpenDataCallBack cb) {
    }

    @Override
    public void getOpenData(List<OpenData> data, Callbacks.GetOpenDataCallBack cb) {
    }

    @Override
    public void detach() {
        this.context.unregisterReceiver(this.mReciver);
    }

    private String getSignature(String pkg) {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo(pkg, 64);
            return WWAPIImplLocal.MD5Encode(var1.signatures[0].toByteArray());
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static String MD5Encode(byte[] toencode) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(toencode);
            return WWAPIImplLocal.HexEncode(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String HexEncode(byte[] toencode) {
        StringBuilder sb = new StringBuilder(toencode.length * 2);
        for (byte b : toencode) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString().toUpperCase();
    }

    private boolean isValidSignature(String pkg) {
        String signature = this.getSignature(pkg);
        return WWAPIImplLocal.isSupportSignature(signature);
    }

    private static boolean isSupportSignature(String signature) {
        return ValidSignatureList.contains(signature);
    }

    private List<String> getWwPkgs() {
        ArrayList<String> pkgs = PKG_NAMES;
        if (this.context != null && !TextUtils.equals((CharSequence)this.context.getPackageName(), (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES2;
        }
        return pkgs;
    }
}

