/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.wework.api.Callbacks;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.OpenData;
import com.tencent.wework.api.model.WWAuthMessage;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import com.tencent.wework.api.util.OpenDataUtils;
import com.tencent.wework.api.view.H5Activity;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public final class WWAPIImpl
implements IWWAPI {
    private Context context;
    private String schema;
    public static final String LOCAL_PKG_SIGNATURE = "011A40266C8C75D181DDD8E4DDC50075";
    private static final String PKG_NAME = "com.tencent.wework";
    private static final String LOCAL_PKG_NAME = "com.tencent.weworklocal";
    private static final String SPECIAL_PKG_NAME = "com.tencent.wwgovernment";
    private static final ArrayList<String> PKG_NAMES = new ArrayList<String>(){
        {
            this.add(WWAPIImpl.LOCAL_PKG_NAME);
            this.add(WWAPIImpl.PKG_NAME);
            this.add(WWAPIImpl.SPECIAL_PKG_NAME);
        }
    };
    private static final ArrayList<String> PKG_NAMES2 = new ArrayList<String>(){
        {
            this.add(WWAPIImpl.PKG_NAME);
        }
    };
    private Map<String, IWWAPIEventHandler> callbacks = new HashMap<String, IWWAPIEventHandler>();
    private Callbacks.SessionKeyUpdateCallback sessionKeyUpdateCallback = null;
    private BroadcastReceiver mReciver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!WWAPIImpl.this.schema.equals(intent.getScheme())) {
                    return;
                }
                final BaseMessage msg = BaseMessage.parseUri(intent.getData());
                msg.setsKey(WWAPIImpl.this.mPreferences.getString("sk", ""));
                msg.fromBundle(intent.getExtras());
                final String sk = ((WWBaseRespMessage)msg).newSessionKey;
                if (!TextUtils.isEmpty((CharSequence)sk)) {
                    WWAPIImpl.this.setSessionKey(sk);
                }
                if (msg instanceof WWBaseRespMessage) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((IWWAPIEventHandler)WWAPIImpl.this.callbacks.get(((WWBaseRespMessage)msg).transaction)).handleResp(msg);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            WWAPIImpl.this.callbacks.remove(((WWBaseRespMessage)msg).transaction);
                            try {
                                if (!TextUtils.isEmpty((CharSequence)sk)) {
                                    WWAPIImpl.this.sessionKeyUpdateCallback.onResult(sk);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };
    private SharedPreferences mPreferences = null;
    private static boolean requesting = false;

    WWAPIImpl(Context var0) {
        this.context = var0;
        this.mPreferences = var0.getSharedPreferences("wxwork_wwapi_store", 0);
    }

    @Override
    public boolean registerApp(String var1) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addDataScheme(var1);
        intentFilter.addAction(var1);
        this.context.registerReceiver(this.mReciver, intentFilter);
        this.schema = var1;
        return true;
    }

    @Override
    public void unregisterApp() {
    }

    @Override
    public boolean handleIntent(Intent intent, IWWAPIEventHandler handler) {
        return false;
    }

    @Override
    public boolean isWWAppInstalled() {
        for (String pkg : this.getWwPkgs()) {
            if (!this.isValidSignature(pkg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWWAppInstalled(IWWAPI.WWAppType appType) {
        return false;
    }

    @Override
    public boolean isWWAppSupportAPI() {
        return this.getWWAppSupportAPI() >= 100;
    }

    @Override
    @NonNull
    public String getWWAppName() {
        String defaultName = "\u4f01\u4e1a\u5fae\u4fe1";
        Iterator<String> iterator = this.getWwPkgs().iterator();
        if (iterator.hasNext()) {
            String pkg = iterator.next();
            try {
                PackageManager pm = this.context.getPackageManager();
                ApplicationInfo info = pm.getApplicationInfo(pkg, 0);
                String name = pm.getApplicationLabel(info).toString();
                return TextUtils.isEmpty((CharSequence)name) ? "\u4f01\u4e1a\u5fae\u4fe1" : name;
            }
            catch (Throwable tr) {
                return "\u4f01\u4e1a\u5fae\u4fe1";
            }
        }
        return "\u4f01\u4e1a\u5fae\u4fe1";
    }

    @Override
    public String getWWAppName(IWWAPI.WWAppType appType) {
        return null;
    }

    @Override
    public int getWWAppSupportAPI() {
        for (String pkg : this.getWwPkgs()) {
            int versioncode = this.getVersioncode(pkg);
            if (versioncode == 0) continue;
            return versioncode;
        }
        return 0;
    }

    private int getVersioncode(String pkg) {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo(pkg, 128);
            return var1 == null ? 0 : var1.versionCode;
        }
        catch (Throwable tr) {
            return 0;
        }
    }

    @Override
    public boolean openWWApp() {
        for (String pkg : this.getWwPkgs()) {
            if (!this.isValidSignature(pkg)) continue;
            try {
                this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage(pkg));
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1) {
        var1.setsKey(this.mPreferences.getString("sk", ""));
        if (!var1.checkArgs()) {
            return false;
        }
        ArrayList<String> pkgs = PKG_NAMES2;
        if (var1 instanceof WWBaseMessage && TextUtils.equals((CharSequence)((WWBaseMessage)var1).appPkg, (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES;
        }
        if (this.context != null && TextUtils.equals((CharSequence)this.context.getPackageName(), (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES;
        }
        var1.setNeedUpdateSession(this.sessionKeyUpdateCallback != null);
        for (String pkg : pkgs) {
            if (!this.isValidSignature(pkg)) continue;
            Intent i = new Intent("com.tencent.wework.apihost");
            i.setClassName(pkg, "com.tencent.wework.apihost.WWAPIActivity");
            i.addFlags(0x18800000);
            try {
                var1.setDestPkg(pkg);
                var1.setContext(this.context);
                Bundle b = BaseMessage.pack(var1);
                long id2 = OpenDataUtils.addBundle(this.context, this.context.getPackageName(), pkg, b);
                if (id2 > 0L) {
                    i.putExtra("data_id", id2);
                    i.putExtra("data_pkg", this.context.getPackageName());
                } else {
                    i.putExtras(b);
                }
                i.putExtra("PendingIntent", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, this.mReciver.getClass()), (int)0xC000000));
                var1.adjustIntent(i, pkg);
                this.context.startActivity(i);
                return true;
            }
            catch (Throwable var2) {
                var2.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPI.WWAppType appType) {
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPIEventHandler callback) {
        if (var1 instanceof WWAuthMessage.Req && !this.isWWAppInstalled()) {
            Intent intent = new Intent(this.context, H5Activity.class);
            intent.putExtra("url", "https://open.work.weixin.qq.com/native/sso/auth/guide?appid=" + ((WWAuthMessage.Req)var1).appId);
            intent.addFlags(0x10000000);
            try {
                this.context.startActivity(intent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        if (this.sendMessage(var1)) {
            if (var1 instanceof WWBaseMessage) {
                this.callbacks.put(((WWBaseMessage)var1).transaction, callback);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPI.WWAppType appType, IWWAPIEventHandler callback) {
        return false;
    }

    @Override
    public void setSessionKey(String key) {
        this.mPreferences.edit().putString("sk", key).commit();
    }

    @Override
    public void setSessionKeyUpdateCallack(Callbacks.SessionKeyUpdateCallback cb) {
        this.sessionKeyUpdateCallback = cb;
    }

    @Override
    public void initOpenData(final Callbacks.InitOpenDataCallBack cb) {
        if (requesting) {
            cb.onResult(100, "");
            return;
        }
        final String skey = this.mPreferences.getString("sk", "");
        if (TextUtils.isEmpty((CharSequence)skey)) {
            cb.onResult(630001, "");
            return;
        }
        final Handler handler = new Handler(Looper.myLooper());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("session_key", (Object)skey);
                    WWAPIImpl.this.httpPost("https://open.work.weixin.qq.com/sdk/opendata/init_open_data", jsonObject.toString().getBytes("UTF-8"), new HttpResult(){

                        @Override
                        public void call(final int errCode, StringBuilder data) {
                            if (errCode != 0) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(errCode, "");
                                    }
                                });
                                return;
                            }
                            try {
                                JSONObject jb = new JSONObject(data.toString());
                                final int err = jb.getInt("errcode");
                                final String errMsg = jb.optString("errmsg");
                                final String ticket = jb.optString("open_data_ticket");
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(err, errMsg);
                                        if (err == 0 && !TextUtils.isEmpty((CharSequence)ticket)) {
                                            WWAPIImpl.this.mPreferences.edit().putString("tk", ticket).commit();
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(101, "");
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            cb.onResult(101, "");
                        }
                    });
                }
                requesting = false;
            }
        }).start();
        requesting = true;
    }

    @Override
    public void getOpenData(final List<OpenData> data, final Callbacks.GetOpenDataCallBack cb) {
        if (requesting) {
            cb.onResult(100, "", new ArrayList<OpenData>());
            return;
        }
        final String tk = this.mPreferences.getString("tk", "");
        if (TextUtils.isEmpty((CharSequence)tk)) {
            cb.onResult(630003, "", new ArrayList<OpenData>());
            return;
        }
        final Handler handler = new Handler(Looper.myLooper());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("open_data_ticket", (Object)tk);
                    JSONArray items = new JSONArray();
                    for (OpenData d : data) {
                        if (d == null || TextUtils.isEmpty((CharSequence)d.id)) continue;
                        JSONObject item = new JSONObject();
                        item.put("id", (Object)d.id);
                        if (d.type == 1) {
                            item.put("type", (Object)"userName");
                        } else if (d.type == 2) {
                            item.put("type", (Object)"departmentName");
                        } else if (d.type == 3) {
                            item.put("type", (Object)"userGender");
                        } else if (d.type == 4) {
                            item.put("type", (Object)"userDepartment");
                        } else {
                            if (d.type != 100 || TextUtils.isEmpty((CharSequence)d.typeStr)) continue;
                            item.put("type", (Object)d.typeStr);
                        }
                        items.put((Object)item);
                    }
                    jsonObject.put("items", (Object)items);
                    WWAPIImpl.this.httpPost("https://open.work.weixin.qq.com/sdk/opendata/get_open_data", jsonObject.toString().getBytes("UTF-8"), new HttpResult(){

                        @Override
                        public void call(final int errCode, StringBuilder data) {
                            if (errCode != 0) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(errCode, "", new ArrayList<OpenData>());
                                    }
                                });
                                return;
                            }
                            try {
                                JSONObject jb = new JSONObject(data.toString());
                                final int err = jb.getInt("errcode");
                                final String errMsg = jb.optString("errmsg");
                                JSONArray items = jb.optJSONArray("items");
                                final ArrayList<OpenData> dataOut = new ArrayList<OpenData>();
                                for (int i = 0; i < items.length(); ++i) {
                                    JSONObject item = items.getJSONObject(i);
                                    OpenData d = new OpenData();
                                    String type = item.optString("type");
                                    if (TextUtils.equals((CharSequence)type, (CharSequence)"userName")) {
                                        d.type = 1;
                                    } else if (TextUtils.equals((CharSequence)type, (CharSequence)"departmentName")) {
                                        d.type = 2;
                                    } else if (TextUtils.equals((CharSequence)type, (CharSequence)"userGender")) {
                                        d.type = 3;
                                    } else if (TextUtils.equals((CharSequence)type, (CharSequence)"userDepartment")) {
                                        d.type = 4;
                                    } else {
                                        if (TextUtils.isEmpty((CharSequence)type)) continue;
                                        d.type = 100;
                                    }
                                    d.typeStr = type;
                                    d.id = item.optString("id");
                                    d.name = item.optString("data");
                                    dataOut.add(d);
                                }
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(err, errMsg, dataOut);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.onResult(101, "", new ArrayList<OpenData>());
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            cb.onResult(101, "", new ArrayList<OpenData>());
                        }
                    });
                }
                requesting = false;
            }
        }).start();
        requesting = true;
    }

    @Override
    public void detach() {
        this.context.unregisterReceiver(this.mReciver);
    }

    private String getSignature(String pkg) {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo(pkg, 64);
            return WWAPIImpl.MD5Encode(var1.signatures[0].toByteArray());
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static String MD5Encode(byte[] toencode) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(toencode);
            return WWAPIImpl.HexEncode(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String HexEncode(byte[] toencode) {
        StringBuilder sb = new StringBuilder(toencode.length * 2);
        for (byte b : toencode) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString().toUpperCase();
    }

    private boolean isValidSignature(String pkg) {
        String signature = this.getSignature(pkg);
        return LOCAL_PKG_SIGNATURE.equals(signature);
    }

    private List<String> getWwPkgs() {
        ArrayList<String> pkgs = PKG_NAMES;
        if (this.context != null && !TextUtils.equals((CharSequence)this.context.getPackageName(), (CharSequence)"com.tencent.mm")) {
            pkgs = PKG_NAMES2;
        }
        return pkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void httpPost(String urlStr, byte[] data, HttpResult hr) {
        HttpURLConnection conn = null;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        OutputStream os = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            os = conn.getOutputStream();
            int len = 512;
            for (int offset = 0; offset < data.length; offset += len) {
                if (offset + len > data.length) {
                    len = data.length - offset;
                }
                os.write(data, offset, len);
                os.flush();
            }
            is = conn.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                sb.append(temp);
            }
            hr.call(0, sb);
        }
        catch (Throwable e) {
            hr.call(101, null);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable url) {}
        }
    }

    private static interface HttpResult {
        public void call(int var1, StringBuilder var2);
    }
}

