/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.OcrResponseResult;
import com.baidu.ocr.sdk.utils.Parser;
import org.json.JSONException;
import org.json.JSONObject;

public class OcrResultParser
implements Parser<OcrResponseResult> {
    @Override
    public OcrResponseResult parse(String json) throws OCRError {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code")) {
                OCRError error = new OCRError(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                error.setLogId(jsonObject.optLong("log_id"));
                throw error;
            }
            OcrResponseResult result = new OcrResponseResult();
            result.setLogId(jsonObject.optLong("log_id"));
            result.setJsonRes(json);
            return result;
        }
        catch (JSONException e) {
            throw new OCRError(283505, "Server illegal response " + json, e);
        }
    }
}

