/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.Date;

public class LogUtil {
    static final String TAG = LogUtil.class.getSimpleName();
    static int LOGCAT_LEVEL = 2;
    static int FILE_LOG_LEVEL = 16;
    static final int LOG_LEVEL_ERROR = 16;
    static final int LOG_LEVEL_WARN = 8;
    static final int LOG_LEVEL_INFO = 4;
    static final int LOG_LEVEL_DEBUG = 2;
    public static boolean DEBUG = LOGCAT_LEVEL <= 2;
    public static boolean INFO = LOGCAT_LEVEL <= 4;
    public static boolean WARN = LOGCAT_LEVEL <= 8;
    public static boolean ERROR = LOGCAT_LEVEL <= 16;
    public static final String E = "E";
    public static final String D = "D";
    public static final String V = "V";
    public static final String W = "W";
    public static final String I = "I";
    static final String LOG_FILE_NAME = "ocr_sdk.log";
    private static final String LOG_TAG_STRING = "OCR_SDK";
    static final String LOG_ENTRY_FORMAT = "[%tF %tT][%s][%s]%s";
    static PrintStream logStream;
    static boolean initialized;
    private static final String TAG_LEFT_BRICK = " [";
    private static final String TAG_RIGHT_BRICK = "]: ";
    private static final String TAG_COLOMN = ":";
    private static FileChannel logFileChannel;

    private void enableFileLog() {
        FILE_LOG_LEVEL = 2;
    }

    public static void d(String tag, String msg) {
        if (DEBUG) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.d((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 2) {
                LogUtil.write(D, fulltag, msg, null);
            }
        }
    }

    public static void d(String tag, String msg, Throwable error) {
        if (DEBUG) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.d((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 2) {
                LogUtil.write(D, fulltag, msg, error);
            }
        }
    }

    public static void v(String tag, String msg) {
        if (DEBUG) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.v((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 2) {
                LogUtil.write(V, fulltag, msg, null);
            }
        }
    }

    public static void v(String tag, String msg, Throwable error) {
        if (DEBUG) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.v((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 2) {
                LogUtil.write(V, fulltag, msg, error);
            }
        }
    }

    public static void i(String tag, String msg) {
        if (INFO) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.i((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 4) {
                LogUtil.write(I, fulltag, msg, null);
            }
        }
    }

    public static void i(String rz, String tag, String msg) {
        if (INFO) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.i((String)rz, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 4) {
                LogUtil.write(I, fulltag, msg, null);
            }
        }
    }

    public static void i(String tag, String msg, Throwable error) {
        if (INFO) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.i((String)LOG_TAG_STRING, (String)(tag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 4) {
                LogUtil.write(I, fulltag, msg, error);
            }
        }
    }

    public static void w(String tag, String msg) {
        if (WARN) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.w((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 8) {
                LogUtil.write(W, fulltag, msg, null);
            }
        }
    }

    public static void w(String tag, String msg, Throwable error) {
        if (WARN) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.w((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 8) {
                LogUtil.write(W, fulltag, msg, error);
            }
        }
    }

    public static void e(String tag, String msg) {
        if (ERROR) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.e((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 16) {
                LogUtil.write(E, fulltag, msg, null);
            }
        }
    }

    public static void e(String tag, String msg, Throwable error) {
        if (ERROR) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.e((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 16) {
                LogUtil.write(E, fulltag, msg, error);
            }
        }
    }

    public static void wtf(String tag, String msg) {
        if (ERROR) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.wtf((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg));
            if (FILE_LOG_LEVEL <= 16) {
                LogUtil.write(E, fulltag, msg, null);
            }
        }
    }

    public static void wtf(String tag, String msg, Throwable error) {
        if (ERROR) {
            String fulltag = LogUtil.getFullTag() + TAG_COLOMN + tag;
            Log.wtf((String)LOG_TAG_STRING, (String)(fulltag + TAG_LEFT_BRICK + TAG_RIGHT_BRICK + msg), (Throwable)error);
            if (FILE_LOG_LEVEL <= 16) {
                LogUtil.write(E, fulltag, msg, error);
            }
        }
    }

    private static void write(String level, String tag, String msg, Throwable error) {
        if (!initialized) {
            LogUtil.init();
        }
        if (logStream == null || logStream.checkError()) {
            initialized = false;
            return;
        }
        Date now = new Date();
        logStream.printf(LOG_ENTRY_FORMAT, now, now, level, tag, " []: " + msg);
        logStream.println();
        if (error != null) {
            error.printStackTrace(logStream);
            logStream.println();
        }
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        DEBUG = LOGCAT_LEVEL <= 2;
        INFO = LOGCAT_LEVEL <= 4;
        WARN = LOGCAT_LEVEL <= 8;
        ERROR = LOGCAT_LEVEL <= 16;
        try {
            File sdRoot = LogUtil.getSDRootFile();
            if (sdRoot != null) {
                File logFile = new File(sdRoot, LOG_FILE_NAME);
                logFile.createNewFile();
                Log.d((String)LOG_TAG_STRING, (String)(TAG + " : Log to file : " + logFile));
                if (logStream != null) {
                    logStream.close();
                }
                logStream = new PrintStream(new FileOutputStream(logFile, true), true);
                initialized = true;
            }
            logFileChannel = LogUtil.getFileLock();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG_STRING, (String)"init log stream failed", (Throwable)e);
        }
    }

    public static boolean isSdCardAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static File getSDRootFile() {
        if (LogUtil.isSdCardAvailable()) {
            return Environment.getExternalStorageDirectory();
        }
        return null;
    }

    private static String getFullTag() {
        return Thread.currentThread().getName();
    }

    private static FileChannel getFileLock() {
        File sdRoot;
        if (logFileChannel == null && (sdRoot = LogUtil.getSDRootFile()) != null) {
            File logFile = new File(sdRoot, LOG_FILE_NAME);
            try {
                logFileChannel = new FileOutputStream(logFile).getChannel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return logFileChannel;
    }

    static {
        initialized = false;
        LogUtil.init();
    }
}

