/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import android.text.TextUtils;
import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.model.IDCardResult;
import com.baidu.ocr.sdk.model.Word;
import com.baidu.ocr.sdk.utils.Parser;
import org.json.JSONException;
import org.json.JSONObject;

public class IDCardResultParser
implements Parser<IDCardResult> {
    private String idCardSide;

    public IDCardResultParser(String idCardSide) {
        this.idCardSide = idCardSide;
    }

    @Override
    public IDCardResult parse(String json) throws OCRError {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("error_code")) {
                OCRError error = new OCRError(jsonObject.optInt("error_code"), jsonObject.optString("error_msg"));
                error.setLogId(jsonObject.optLong("log_id"));
                throw error;
            }
            IDCardResult result = new IDCardResult();
            result.setLogId(jsonObject.optLong("log_id"));
            result.setJsonRes(json);
            result.setDirection(jsonObject.optInt("direction", -1));
            result.setWordsResultNumber(jsonObject.optInt("words_result_num"));
            result.setRiskType(jsonObject.optString("risk_type"));
            result.setImageStatus(jsonObject.optString("image_status"));
            JSONObject wordResult = jsonObject.optJSONObject("words_result");
            if (TextUtils.isEmpty((CharSequence)this.idCardSide)) {
                this.idCardSide = "front";
            }
            result.setIdCardSide(this.idCardSide);
            if (wordResult != null) {
                if ("front".equals(this.idCardSide)) {
                    result.setAddress(this.map(wordResult.optJSONObject("\u4f4f\u5740")));
                    result.setIdNumber(this.map(wordResult.optJSONObject("\u516c\u6c11\u8eab\u4efd\u53f7\u7801")));
                    result.setBirthday(this.map(wordResult.optJSONObject("\u51fa\u751f")));
                    result.setGender(this.map(wordResult.optJSONObject("\u6027\u522b")));
                    result.setName(this.map(wordResult.optJSONObject("\u59d3\u540d")));
                    result.setEthnic(this.map(wordResult.optJSONObject("\u6c11\u65cf")));
                } else if ("back".equals(this.idCardSide)) {
                    result.setSignDate(this.map(wordResult.optJSONObject("\u7b7e\u53d1\u65e5\u671f")));
                    result.setExpiryDate(this.map(wordResult.optJSONObject("\u5931\u6548\u65e5\u671f")));
                    result.setIssueAuthority(this.map(wordResult.optJSONObject("\u7b7e\u53d1\u673a\u5173")));
                }
            }
            return result;
        }
        catch (JSONException e) {
            OCRError error = new OCRError(283505, "Server illegal response " + json, e);
            throw error;
        }
    }

    private Word map(JSONObject jsonObject) {
        Word word = null;
        if (jsonObject != null) {
            word = new Word();
            JSONObject locationObject = jsonObject.optJSONObject("location");
            word.getLocation().setLeft(locationObject.optInt("left"));
            word.getLocation().setTop(locationObject.optInt("top"));
            word.getLocation().setWidth(locationObject.optInt("width"));
            word.getLocation().setHeight(locationObject.optInt("height"));
            word.setWords(jsonObject.optString("words"));
        }
        return word;
    }
}

