/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.baidu.ocr.sdk.OCR;
import com.baidu.ocr.sdk.OnResultListener;
import com.baidu.ocr.sdk.exception.OCRError;
import com.baidu.ocr.sdk.exception.SDKError;
import com.baidu.ocr.sdk.model.AccessToken;
import com.baidu.ocr.sdk.model.BankCardParams;
import com.baidu.ocr.sdk.model.IDCardParams;
import com.baidu.ocr.sdk.model.RequestParams;
import com.baidu.ocr.sdk.utils.AccessTokenParser;
import com.baidu.ocr.sdk.utils.HttpsClient;
import com.baidu.ocr.sdk.utils.Parser;

public class HttpUtil {
    private Handler handler;
    private static volatile HttpUtil instance;
    private static Options options;

    private HttpUtil() {
    }

    public static void setOptions(Options options) {
        HttpUtil.options = options;
    }

    public static Options getOptions() {
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.handler = new Handler(Looper.getMainLooper());
    }

    public <T> void post(String path, RequestParams params, final Parser<T> parser, final OnResultListener<T> listener) {
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setStrParams(params.getStringParams());
        body.setFileParams(params.getFileParams());
        HttpsClient.RequestInfo reqInfo = new HttpsClient.RequestInfo(path, body);
        reqInfo.build();
        cl.newCall(reqInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(final Throwable e) {
                HttpUtil.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpUtil.throwSDKError(listener, 283504, "Network error", e);
                    }
                });
            }

            @Override
            public void onResponse(String resultStr) {
                String responseString = resultStr;
                try {
                    final Object result = parser.parse(responseString);
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(result);
                        }
                    });
                }
                catch (OCRError e) {
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(e);
                        }
                    });
                }
            }
        });
    }

    public <T> void postidcard(String path, IDCardParams params, final Parser<T> parser, final OnResultListener<T> listener) {
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setStrParams(params.getParams(params));
        body.setFileParams(params.getFileParams());
        HttpsClient.RequestInfo reqInfo = new HttpsClient.RequestInfo(path, body);
        reqInfo.build();
        cl.newCall(reqInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(final Throwable e) {
                HttpUtil.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpUtil.throwSDKError(listener, 283504, "Network error", e);
                    }
                });
            }

            @Override
            public void onResponse(String resultStr) {
                String responseString = resultStr;
                try {
                    final Object result = parser.parse(responseString);
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(result);
                        }
                    });
                }
                catch (OCRError e) {
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(e);
                        }
                    });
                }
            }
        });
    }

    public <T> void postcard(String path, BankCardParams params, final Parser<T> parser, final OnResultListener<T> listener) {
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setStrParams(params.getParams(params));
        body.setFileParams(params.getFileParams());
        HttpsClient.RequestInfo reqInfo = new HttpsClient.RequestInfo(path, body);
        reqInfo.build();
        cl.newCall(reqInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(final Throwable e) {
                HttpUtil.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpUtil.throwSDKError(listener, 283504, "Network error", e);
                    }
                });
            }

            @Override
            public void onResponse(String resultStr) {
                String responseString = resultStr;
                try {
                    final Object result = parser.parse(responseString);
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onResult(result);
                        }
                    });
                }
                catch (OCRError e) {
                    HttpUtil.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(e);
                        }
                    });
                }
            }
        });
    }

    public void getAccessToken(final OnResultListener<AccessToken> listener, String url, String param) {
        final AccessTokenParser accessTokenParser = new AccessTokenParser();
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setBody(param);
        HttpsClient.RequestInfo reqInfo = new HttpsClient.RequestInfo(url, body);
        reqInfo.setHeader("Content-Type", "text/html");
        reqInfo.build();
        cl.newCall(reqInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(Throwable e) {
                HttpUtil.throwSDKError(listener, 283504, "Network error", e);
            }

            @Override
            public void onResponse(String resultStr) {
                if (resultStr == null || TextUtils.isEmpty((CharSequence)resultStr)) {
                    HttpUtil.throwSDKError(listener, 283505, "Server illegal response " + resultStr);
                    return;
                }
                try {
                    AccessToken accessToken = (AccessToken)accessTokenParser.parse(resultStr);
                    if (accessToken != null) {
                        OCR.getInstance(null).setAccessToken(accessToken);
                        OCR.getInstance(null).setLicense(accessToken.getLic());
                        listener.onResult(accessToken);
                    } else {
                        HttpUtil.throwSDKError(listener, 283505, "Server illegal response " + resultStr);
                    }
                }
                catch (SDKError e) {
                    listener.onError(e);
                }
                catch (Exception e) {
                    HttpUtil.throwSDKError(listener, 283505, "Server illegal response " + resultStr, e);
                }
            }
        });
    }

    private static void throwSDKError(OnResultListener listener, int errorCode, String msg) {
        SDKError error = new SDKError(errorCode, msg);
        listener.onError(error);
    }

    private static void throwSDKError(OnResultListener listener, int errorCode, String msg, Throwable cause) {
        SDKError error = new SDKError(errorCode, msg, cause);
        listener.onError(error);
    }

    public void release() {
        this.handler = null;
    }

    static {
        options = new Options();
    }

    public static class Options {
        private int connectionTimeoutInMillis = 10000;
        private int socketTimeoutInMillis = 10000;

        public int getConnectionTimeoutInMillis() {
            return this.connectionTimeoutInMillis;
        }

        public void setConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
            this.connectionTimeoutInMillis = connectionTimeoutInMillis;
        }

        public int getSocketTimeoutInMillis() {
            return this.socketTimeoutInMillis;
        }

        public void setSocketTimeoutInMillis(int socketTimeoutInMillis) {
            this.socketTimeoutInMillis = socketTimeoutInMillis;
        }
    }
}

