/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import android.content.Context;
import com.baidu.ocr.sdk.utils.DeviceUtil;
import com.baidu.ocr.sdk.utils.HttpsClient;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporterHandler
implements Thread.UncaughtExceptionHandler {
    private static final String EMPTY_STR = "";
    private static final String REPORT_FILENAME = "bd_aip_crashreport_file";
    private static final String HTTP_HEADER_CONTENTTYPE = "application/x-www-form-urlencoded;charset=utf-8";
    private static final String REPORT_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    private static final String HTTP_URL = "https://verify.baidubce.com/verify/1.0/sdk/report";
    private static CrashReporterHandler instance;
    private static Thread.UncaughtExceptionHandler defaultHandler;
    private Context ctx;
    private Set<Class> sourceClassSet = new HashSet<Class>();

    public CrashReporterHandler(Context context) {
        this.ctx = context;
    }

    public static CrashReporterHandler init(Context ctx) {
        if (instance == null) {
            instance = new CrashReporterHandler(ctx);
        }
        if (defaultHandler == null) {
            defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
        Thread.setDefaultUncaughtExceptionHandler(instance);
        instance.sendPreviousReport();
        return instance;
    }

    public void release() {
        this.ctx = null;
    }

    public CrashReporterHandler addSourceClass(Class clazz) {
        this.sourceClassSet.add(clazz);
        return instance;
    }

    public void resolveException(Throwable e) {
        String detailContent;
        String fileString;
        boolean isCause = false;
        try {
            isCause = this.isCauseBySource(e);
        }
        catch (Throwable throwable) {
            String detailContent2 = this.exDetailContent(throwable);
            String fileString2 = this.createReport(detailContent2);
            if (!this.writeFile(fileString2)) {
                this.postBody(fileString2);
            }
            return;
        }
        if (isCause && !this.writeFile(fileString = this.createReport(detailContent = this.exDetailContent(e)))) {
            this.postBody(fileString);
        }
    }

    private String createReport(String detailContent) {
        String jsonString;
        JSONObject obj = new JSONObject();
        try {
            obj.put("id", (Object)DeviceUtil.getDeviceId(this.ctx));
            obj.put("time", (Object)this.getCurrentTime());
            obj.put("system", (Object)DeviceUtil.getDeviceInfo(this.ctx));
            obj.put("sdkver", (Object)"2_0_1");
            obj.put("appnm", (Object)this.getPackageName());
            obj.put("detail", (Object)detailContent);
            jsonString = obj.toString();
        }
        catch (JSONException jsonEx) {
            jsonString = jsonEx.toString();
        }
        return jsonString;
    }

    public void sendPreviousReport() {
        String report = this.readFile();
        if (report != null && report != EMPTY_STR) {
            this.postBody(report);
        }
    }

    private boolean writeFile(String fileString) {
        try {
            FileOutputStream outStream = this.ctx.openFileOutput(REPORT_FILENAME, 0);
            outStream.write(fileString.getBytes("utf8"));
            outStream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String readFile() {
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            FileInputStream stream = this.ctx.openFileInput(REPORT_FILENAME);
            while ((ch = stream.read()) != -1) {
                sb.append((char)ch);
            }
            stream.close();
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String genContent(Throwable e) {
        String lineBreaker = "|";
        StringBuffer sb = new StringBuffer();
        sb.append("!" + e.getMessage());
        sb.append(lineBreaker);
        for (StackTraceElement elem : e.getStackTrace()) {
            sb.append(elem.getClassName() + " [" + elem.getMethodName() + ": " + elem.getLineNumber() + "] ");
            sb.append(lineBreaker);
        }
        return sb.toString();
    }

    private String exDetailContent(Throwable e) {
        if (e.getCause() != null) {
            return this.genContent(e) + this.exDetailContent(e.getCause());
        }
        return this.genContent(e);
    }

    private boolean isCauseBySource(Throwable e) {
        if (this.isStackCauseBySource(e.getStackTrace())) {
            return true;
        }
        if (e.getCause() == null) {
            return false;
        }
        return this.isCauseBySource(e.getCause());
    }

    private boolean isStackCauseBySource(StackTraceElement[] elems) {
        for (StackTraceElement elem : elems) {
            try {
                Class<?> clazz = Class.forName(elem.getClassName());
                if (!this.sourceClassSet.contains(clazz)) continue;
                return true;
            }
            catch (ClassNotFoundException notFountException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getCurrentTime() {
        Date date = new Date();
        SimpleDateFormat time = new SimpleDateFormat(REPORT_TIME_FORMATTER);
        return time.format(date);
    }

    private String getPackageName() {
        return this.ctx.getPackageName();
    }

    public void postBody(String fileString) {
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setBody(fileString);
        HttpsClient.RequestInfo reqiInfo = new HttpsClient.RequestInfo(HTTP_URL, body);
        reqiInfo.setHeader("Content-Type", HTTP_HEADER_CONTENTTYPE);
        reqiInfo.build();
        cl.newCall(reqiInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(Throwable e) {
            }

            @Override
            public void onResponse(String resultStr) {
                CrashReporterHandler.this.writeFile(CrashReporterHandler.EMPTY_STR);
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            this.resolveException(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        defaultHandler.uncaughtException(t, e);
    }

    static {
        defaultHandler = null;
    }
}

