/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.utils;

import com.baidu.ocr.sdk.exception.SDKError;
import com.baidu.ocr.sdk.model.AccessToken;
import com.baidu.ocr.sdk.utils.Parser;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessTokenParser
implements Parser<AccessToken> {
    @Override
    public AccessToken parse(String json) throws SDKError {
        block6: {
            try {
                JSONObject jsonObject = new JSONObject(json);
                if (!jsonObject.isNull("status")) {
                    int status = jsonObject.optInt("status");
                    if (status == 0) {
                        JSONObject data = jsonObject.optJSONObject("data");
                        if (data != null) {
                            AccessToken accessToken = new AccessToken();
                            accessToken.setTokenJson(json);
                            accessToken.setAccessToken(data.getString("access_token"));
                            if (data.has("lic")) {
                                accessToken.setLic(data.getString("lic"));
                            }
                            accessToken.setExpiresIn(data.optInt("expires_in"));
                            return accessToken;
                        }
                        break block6;
                    }
                    String message = jsonObject.optString("message");
                    Long logId = jsonObject.optLong("log_id");
                    SDKError error = new SDKError(status, message + " logId: " + logId);
                    throw error;
                }
                SDKError error = new SDKError(283505, "Server illegal response " + json);
                throw error;
            }
            catch (JSONException e) {
                SDKError error = new SDKError(283505, "Server illegal response " + json, e);
                throw error;
            }
        }
        return null;
    }
}

