/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ocr.sdk.tool;

import com.baidu.ocr.sdk.tool.Base64Util;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_STR = "AES/ECB/PKCS5Padding";

    public static String generateBase64EnKeyFromStr(String session) throws Exception {
        byte[] bytes = AESUtil.generateEnKey(session.getBytes());
        return Base64Util.byte2String(bytes);
    }

    public static byte[] generateEnKey(byte[] session) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(session);
        kgen.init(256, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] bytes = secretKey.getEncoded();
        return bytes;
    }

    public static byte[] encrypt(byte[] src, byte[] aesKey) throws Exception {
        Cipher cipher = AESUtil.getCipher(aesKey, 1);
        byte[] ret = cipher.doFinal(src);
        return ret;
    }

    public static byte[] decrypt(byte[] src, byte[] aesKey) throws Exception {
        Cipher cipher = AESUtil.getCipher(aesKey, 2);
        byte[] original = cipher.doFinal(src);
        return original;
    }

    private static Cipher getCipher(byte[] aesKey, int mode) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
        cipher.init(mode, secretKeySpec);
        return cipher;
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

