/*
 * Decompiled with CFR 0.152.
 */
package com.mm.android.dhproxy.client;

import android.util.Log;
import com.mm.android.dhproxy.client.DHProxyEventNotifier;
import com.mm.android.dhproxy.client.DHProxyRateParam;
import com.mm.android.dhproxy.client.DHProxyRemotePortInfo;

public class DHProxyClient {
    private long mHandle = -1L;

    static {
        System.loadLibrary("ToUProxy");
    }

    public boolean init(String svraddr, int svrport, String svrkey) {
        this.mHandle = this.Init(svraddr, svrport, svrkey);
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return false;
        }
        Log.d((String)"proxy_log", (String)("init:" + this.mHandle));
        return true;
    }

    public boolean initWithName(String svraddr, int svrport, String svrkey, String clientType, String username) {
        this.mHandle = this.InitWithName(svraddr, svrport, svrkey, clientType, username);
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return false;
        }
        Log.d((String)"proxy_log", (String)("initWithName:" + this.mHandle));
        return true;
    }

    public int addPort(String uuid, int remote_port, int local_port) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addPort:" + this.mHandle));
        return this.AddPort(uuid, this.mHandle, remote_port, local_port);
    }

    public int addPortEx(String uuid, int remote_port, int local_port, String devUsername, String devPassWord, String randSalt, String devP2PVersion) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addPortEx:" + this.mHandle));
        return this.AddPortEx(uuid, this.mHandle, remote_port, local_port, devUsername, devPassWord, randSalt, devP2PVersion);
    }

    public int addPortSync(String uuid, int remote_port, int local_port, int timeout) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addPortSync:" + this.mHandle));
        return this.AddPortSync(uuid, this.mHandle, remote_port, local_port, timeout);
    }

    public int addPortSyncEx(String uuid, int remote_port, int local_port, String devUsername, String devPassWord, String randSalt, String devP2PVersion, int timeout) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addPortSyncEx:" + this.mHandle));
        return this.AddPortSyncEx(uuid, this.mHandle, remote_port, local_port, devUsername, devPassWord, randSalt, devP2PVersion, timeout);
    }

    public int addTcpRelayPort(String uuid, int remote_port, int local_port) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addTcpRelayPort:" + this.mHandle));
        return this.AddTcpRelayPort(uuid, this.mHandle, remote_port, local_port);
    }

    public int addTcpRelayPortEx(String uuid, int remote_port, int local_port, String devUsername, String devPassWord, String randSalt, String devP2PVersion) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addTcpRelayPortEx:" + this.mHandle));
        return this.AddTcpRelayPortEx(uuid, this.mHandle, remote_port, local_port, devUsername, devPassWord, randSalt, devP2PVersion);
    }

    public int addTcpRelayPortSync(String uuid, int remote_port, int local_port, int timeout) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addTcpRelayPortSync:" + this.mHandle));
        return this.AddTcpRelayPortSync(uuid, this.mHandle, remote_port, local_port, timeout);
    }

    public int addTcpRelayPortSyncEx(String uuid, int remote_port, int local_port, String devUsername, String devPassWord, String randSalt, String devP2PVersion, int timeout) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("addTcpRelayPortSyncEx:" + this.mHandle));
        return this.AddTcpRelayPortSyncEx(uuid, this.mHandle, remote_port, local_port, devUsername, devPassWord, randSalt, devP2PVersion, timeout);
    }

    public int delPort(int port) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("delPort:" + this.mHandle));
        return this.DelPort(port, this.mHandle);
    }

    public int portStatus(int port) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("portStatus:" + this.mHandle));
        return this.PortStatus(port, this.mHandle);
    }

    public int status() {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("status:" + this.mHandle));
        return this.Status(this.mHandle);
    }

    public int query(String uuid) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("query:" + this.mHandle));
        return this.Query(uuid, this.mHandle);
    }

    public int queryRate(int port, DHProxyRateParam param) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("queryRate:" + this.mHandle));
        return this.QueryRate(port, param, this.mHandle);
    }

    public int queryRemoteInfo(int port, DHProxyRemotePortInfo info) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("queryRemoteInfo:" + this.mHandle));
        return this.QueryRemoteInfo(port, info, this.mHandle);
    }

    public int p2pSetOption(int options, int value) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("p2pSetOption:" + this.mHandle));
        return this.P2PSetOption(options, value, this.mHandle);
    }

    public int p2pGetOption(int options) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("p2pGetOption:" + this.mHandle));
        return this.P2PGetOption(options, this.mHandle);
    }

    public int setLogLevel(int level) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("setLogLevel:" + this.mHandle));
        return this.SetLogLevel(level, this.mHandle);
    }

    public String getDeviceInfo(String uuid) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            String ret = "failed";
            return ret;
        }
        Log.d((String)"proxy_log", (String)("getDeviceInfo:" + this.mHandle));
        return this.GetDeviceInfo(uuid, this.mHandle);
    }

    public int regP2PTraversalInfoHandler(DHProxyEventNotifier notifier) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("regP2PTraversalInfoHandler:" + this.mHandle));
        return this.RegP2PTraversalInfoHandler(notifier, this.mHandle);
    }

    public int getSockFamily(int port) {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("getSockFamily:" + this.mHandle));
        return this.GetSockFamily(port, this.mHandle);
    }

    public int exit() {
        if (this.mHandle == 0L || this.mHandle == -1L) {
            return -1;
        }
        Log.d((String)"proxy_log", (String)("exit:" + this.mHandle));
        return this.Exit(this.mHandle);
    }

    private native long Init(String var1, int var2, String var3);

    private native long InitWithName(String var1, int var2, String var3, String var4, String var5);

    private native int AddPort(String var1, long var2, int var4, int var5);

    private native int AddPortEx(String var1, long var2, int var4, int var5, String var6, String var7, String var8, String var9);

    private native int AddPortSync(String var1, long var2, int var4, int var5, int var6);

    private native int AddPortSyncEx(String var1, long var2, int var4, int var5, String var6, String var7, String var8, String var9, int var10);

    private native int AddTcpRelayPort(String var1, long var2, int var4, int var5);

    private native int AddTcpRelayPortEx(String var1, long var2, int var4, int var5, String var6, String var7, String var8, String var9);

    private native int AddTcpRelayPortSync(String var1, long var2, int var4, int var5, int var6);

    private native int AddTcpRelayPortSyncEx(String var1, long var2, int var4, int var5, String var6, String var7, String var8, String var9, int var10);

    private native int DelPort(int var1, long var2);

    private native int PortStatus(int var1, long var2);

    private native int Status(long var1);

    private native int Query(String var1, long var2);

    private native int P2PSetOption(int var1, int var2, long var3);

    private native int P2PGetOption(int var1, long var2);

    private native int SetLogLevel(int var1, long var2);

    private native String GetDeviceInfo(String var1, long var2);

    private native int QueryRate(int var1, DHProxyRateParam var2, long var3);

    private native int QueryRemoteInfo(int var1, DHProxyRemotePortInfo var2, long var3);

    private native int RegP2PTraversalInfoHandler(DHProxyEventNotifier var1, long var2);

    private native int GetSockFamily(int var1, long var2);

    private native int Exit(long var1);
}

