/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.protect.crypto.lite.face;

import com.baidu.protect.crypto.lite.face.Cipher;
import com.baidu.protect.crypto.lite.face.Data;
import com.baidu.protect.crypto.lite.face.WBAESException;

public class WBAESCipherImplement
extends Cipher {
    private static final String TAG = "WBAESCipherImplement";
    private static final int WBAES_ERR_INVALID_LENGTH = -1;
    private static final int WBAES_ERR_INVALID_POINTER = -2;
    private static final int WBAES_ERR_INIT_FAIL = -3;
    private static final int WBAES_ERR_ALLOC_MEMORY = -4;
    private static final int WBAES_ERR_FILE_IO = -5;
    private static final int WBAES_ERR_INVALID_PARAMETER = -6;
    private static final int WBAES_ERR_MEMORY_IO = -7;
    private static final int WBAES_ERR_CREATE_KEY = -8;
    private long context;

    public static Cipher getInstance(String string) {
        if (string == null) {
            System.loadLibrary("baiduprotect_sec_jni");
        } else {
            System.loadLibrary(string);
        }
        return new WBAESCipherImplement();
    }

    private WBAESCipherImplement() {
    }

    private boolean isValidContext(long l2) {
        return l2 != -2L && l2 != -7L && l2 != 0L;
        {
        }
    }

    private native long bdswbInitLite(byte[] var1, byte[] var2, byte[] var3);

    private native void bdswbDestoryLite(long var1);

    private native int bdswbEncryptLite(long var1, byte[] var3, int var4, Data var5, byte[] var6, int var7);

    private native int bdswbDecryptLite(long var1, byte[] var3, int var4, Data var5, int var6);

    @Override
    public boolean initV3Lite(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        long l2;
        WBAESCipherImplement wBAESCipherImplement = this;
        wBAESCipherImplement.context = l2 = wBAESCipherImplement.bdswbInitLite(byArray, byArray2, byArray3);
        return wBAESCipherImplement.isValidContext(l2);
    }

    @Override
    public void doFinalV3Lite() {
        WBAESCipherImplement wBAESCipherImplement = this;
        if (wBAESCipherImplement.isValidContext(wBAESCipherImplement.context)) {
            WBAESCipherImplement wBAESCipherImplement2 = this;
            wBAESCipherImplement2.bdswbDestoryLite(wBAESCipherImplement2.context);
        }
    }

    @Override
    public boolean encryptV3Lite(byte[] byArray, int n2, Data data, byte[] byArray2, int n3) {
        WBAESCipherImplement wBAESCipherImplement = this;
        if (!wBAESCipherImplement.isValidContext(wBAESCipherImplement.context)) {
            return false;
        }
        WBAESCipherImplement wBAESCipherImplement2 = this;
        int n4 = wBAESCipherImplement2.bdswbEncryptLite(wBAESCipherImplement2.context, byArray, n2, data, byArray2, n3);
        if (n4 != -2 && n4 != -1) {
            if (n4 == 0) {
                return true;
            }
            throw new WBAESException("decrypt fail reason:" + n4);
        }
        throw new WBAESException("invalid param");
    }

    @Override
    public boolean decryptV3Lite(byte[] byArray, int n2, Data data, int n3) {
        WBAESCipherImplement wBAESCipherImplement = this;
        if (!wBAESCipherImplement.isValidContext(wBAESCipherImplement.context)) {
            return false;
        }
        WBAESCipherImplement wBAESCipherImplement2 = this;
        int n4 = wBAESCipherImplement2.bdswbDecryptLite(wBAESCipherImplement2.context, byArray, n2, data, n3);
        if (n4 != -2 && n4 != -1) {
            if (n4 == 0) {
                return true;
            }
            throw new WBAESException("decrypt fail reason:" + n4);
        }
        throw new WBAESException("invalid param");
    }
}

