/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"NewApi"})
public class PreferencesUtil {
    private static SharedPreferences mPrefs;
    private static final String LENGTH_SUFFIX = "#LENGTH";
    private static final String LEFT_MOUNT = "[";
    private static final String RIGHT_MOUNT = "]";

    public static void initPrefs(Context context) {
        if (mPrefs == null) {
            String string = context.getPackageName();
            if (string != null) {
                mPrefs = context.getSharedPreferences(string, 4);
            } else {
                throw new NullPointerException("Prefs key may not be null");
            }
        }
    }

    @Deprecated
    public static void reInit(Context context) {
        if (context != null) {
            String string = context.getPackageName();
            if (string != null) {
                mPrefs = context.getSharedPreferences(string, 4);
            } else {
                throw new NullPointerException("Prefs key may not be null");
            }
        }
    }

    public static SharedPreferences getPreferences() {
        SharedPreferences sharedPreferences = mPrefs;
        if (sharedPreferences != null) {
            return sharedPreferences;
        }
        throw new RuntimeException("please call iniPrefs(context) in the Application class onCreate.");
    }

    public static Map<String, ?> getAll() {
        return PreferencesUtil.getPreferences().getAll();
    }

    public static int getInt(String string, int n2) {
        return PreferencesUtil.getPreferences().getInt(string, n2);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return PreferencesUtil.getPreferences().getBoolean(string, bl);
    }

    public static long getLong(String string, long l2) {
        return PreferencesUtil.getPreferences().getLong(string, l2);
    }

    public static float getFloat(String string, float f2) {
        return PreferencesUtil.getPreferences().getFloat(string, f2);
    }

    public static String getString(String string, String string2) {
        return PreferencesUtil.getPreferences().getString(string, string2);
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(String string, Set<String> hashSet) {
        SharedPreferences sharedPreferences = PreferencesUtil.getPreferences();
        if (Build.VERSION.SDK_INT >= 11) {
            return sharedPreferences.getStringSet(string, hashSet);
        }
        if (sharedPreferences.contains(string + LENGTH_SUFFIX)) {
            HashSet<String> hashSet2;
            hashSet = hashSet2;
            hashSet2 = new HashSet<String>();
            int n2 = sharedPreferences.getInt(string + LENGTH_SUFFIX, -1);
            if (n2 >= 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    sharedPreferences.getString(string + LEFT_MOUNT + i2 + RIGHT_MOUNT, null);
                }
            }
            return hashSet;
        }
        return hashSet;
    }

    public static void putLong(String string, long l2) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putLong(string, l2);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putInt(String string, int n2) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putInt(string, n2);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putFloat(String string, float f2) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putFloat(string, f2);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putBoolean(String string, boolean bl) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putBoolean(string, bl);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putString(String string, String string2) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putString(string, string2);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    @TargetApi(value=11)
    public static void putStringSet(String string, Set<String> object) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        if (Build.VERSION.SDK_INT >= 11) {
            editor.putStringSet(string, object);
        } else {
            int n2 = 0;
            if (mPrefs.contains(string + LENGTH_SUFFIX)) {
                n2 = mPrefs.getInt(string + LENGTH_SUFFIX, -1);
            }
            Set<String> set = object;
            Set<String> set2 = object;
            object = string + LENGTH_SUFFIX;
            editor.putInt((String)object, set2.size());
            int n3 = 0;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                editor.putString(string + LEFT_MOUNT + n3 + RIGHT_MOUNT, iterator.next());
                ++n3;
            }
            while (n3 < n2) {
                editor.remove(string + LEFT_MOUNT + n3 + RIGHT_MOUNT);
                ++n3;
            }
        }
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void remove(String string) {
        int n2;
        SharedPreferences sharedPreferences = PreferencesUtil.getPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (sharedPreferences.contains(string + LENGTH_SUFFIX) && (n2 = sharedPreferences.getInt(string + LENGTH_SUFFIX, -1)) >= 0) {
            editor.remove(string + LENGTH_SUFFIX);
            for (int i2 = 0; i2 < n2; ++i2) {
                editor.remove(string + LEFT_MOUNT + i2 + RIGHT_MOUNT);
            }
        }
        editor.remove(string);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static boolean contains(String string) {
        return PreferencesUtil.getPreferences().contains(string);
    }
}

