/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.statistic;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceInfoUtil {
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i2 = 3; i2 < string.length(); ++i2) {
                    if (string.charAt(i2) >= '0' && string.charAt(i2) <= '9') {
                        continue;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final String CurPath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getDeviceSDK() {
        return Build.VERSION.SDK_INT;
    }

    public static String getDeviceSerial() {
        return Build.SERIAL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceProduct() {
        return Build.PRODUCT;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceBoard() {
        return Build.BOARD;
    }

    public static String getDeviceDevice() {
        return Build.DEVICE;
    }

    public static String getDeviceProcessor() {
        String[] stringArray;
        String[] stringArray2 = stringArray;
        stringArray = new FileReader("/proc/cpuinfo");
        String string = new BufferedReader((Reader)stringArray2).readLine();
        stringArray2 = string.split(":\\s+", 2);
        int n2 = 0;
        while (true) {
            if (n2 >= stringArray2.length) break;
            ++n2;
            continue;
            break;
        }
        try {
            return stringArray2[1];
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return null;
    }

    public static int getNumberOfCPUCores() {
        int n2;
        block5: {
            if (Build.VERSION.SDK_INT <= 10) {
                return 1;
            }
            try {
                n2 = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
                break block5;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {}
            n2 = 0;
        }
        return n2;
    }

    public static Integer getCPUBit() {
        Integer n2 = 0;
        String string = null;
        try {
            string = DeviceInfoUtil.getFieldFromCpuinfo("Processor");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string != null) {
            n2 = string.contains("aarch64") ? Integer.valueOf(64) : Integer.valueOf(32);
        }
        return n2;
    }

    public static String getFieldFromCpuinfo(String object) {
        BufferedReader bufferedReader;
        block6: {
            String string;
            Object object2;
            BufferedReader bufferedReader2;
            bufferedReader = bufferedReader2;
            bufferedReader2 = new BufferedReader(new FileReader("/proc/cpuinfo"));
            object = Pattern.compile((String)object + "\\s*:\\s*(.*)");
            while (true) {
                object2 = bufferedReader.readLine();
                if (object2 == null) break block6;
                object2 = ((Pattern)object).matcher((CharSequence)object2);
                if (!((Matcher)object2).matches()) continue;
                break;
            }
            try {
                string = ((Matcher)object2).group(1);
            }
            catch (Throwable throwable) {
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return string;
        }
        bufferedReader.close();
        return null;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static int getDeviceBasicFrequency() {
        void var0_5;
        Object object;
        BufferedReader bufferedReader;
        block36: {
            int n2;
            block41: {
                block42: {
                    block40: {
                        Object object2;
                        block38: {
                            block39: {
                                block37: {
                                    BufferedReader bufferedReader2;
                                    FileReader fileReader;
                                    n2 = 0;
                                    bufferedReader = null;
                                    object = null;
                                    object2 = fileReader;
                                    fileReader = new FileReader(CurPath);
                                    bufferedReader = bufferedReader2;
                                    bufferedReader2 = new BufferedReader((Reader)object2);
                                    n2 = Integer.parseInt(bufferedReader2.readLine().trim());
                                    try {
                                        fileReader.close();
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                    break block41;
                                    catch (Throwable throwable) {
                                        object = object2;
                                        break block36;
                                    }
                                    catch (IOException iOException) {
                                        object = object2;
                                        object2 = iOException;
                                        break block37;
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        object = object2;
                                        object2 = fileNotFoundException;
                                        break block38;
                                    }
                                    catch (Throwable throwable) {
                                        bufferedReader = object;
                                        object = object2;
                                        break block36;
                                    }
                                    catch (IOException iOException) {
                                        bufferedReader = object;
                                        object = object2;
                                        object2 = iOException;
                                        break block37;
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        bufferedReader = object;
                                        object = object2;
                                        object2 = fileNotFoundException;
                                        break block38;
                                    }
                                    catch (Throwable throwable) {
                                        BufferedReader bufferedReader3 = bufferedReader;
                                        bufferedReader = object;
                                        object = bufferedReader3;
                                        break block36;
                                    }
                                    catch (IOException iOException) {
                                        BufferedReader bufferedReader4 = bufferedReader;
                                        bufferedReader = object;
                                        object = bufferedReader4;
                                    }
                                }
                                ((Throwable)object2).printStackTrace();
                                if (object == null) break block39;
                                try {
                                    ((InputStreamReader)object).close();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                            if (bufferedReader == null) break block41;
                            break block42;
                            catch (FileNotFoundException fileNotFoundException) {
                                BufferedReader bufferedReader5 = bufferedReader;
                                bufferedReader = object;
                                object = bufferedReader5;
                            }
                        }
                        ((Throwable)object2).printStackTrace();
                        if (object == null) break block40;
                        try {
                            ((InputStreamReader)object).close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (bufferedReader == null) break block41;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return n2;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object != null) {
            try {
                ((InputStreamReader)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        throw var0_5;
    }

    public static long getRamInfo(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        return context.totalMem;
    }

    public static String getStorageInfo(Context object, int n2) {
        String string;
        object = DeviceInfoUtil.getStoragePath((Context)object, n2);
        if (DeviceInfoUtil.isSDCardMount() && object != null && !((String)object).equals("")) {
            StatFs statFs;
            File file;
            File file2 = file;
            file = new File((String)object);
            object = statFs;
            long l2 = object.getBlockSizeLong();
            long l3 = new StatFs(file2.getPath()).getBlockCountLong() * l2;
            l2 = object.getAvailableBlocksLong() * l2;
            string = "\u53ef\u7528/\u603b\u5171\uff1a" + Long.toString(l2) + "/" + Long.toString(l3);
        } else {
            string = "\u65e0\u5916\u7f6eSD\u5361";
        }
        return string;
    }

    public static boolean isSDCardMount() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getStoragePath(Context stringArray, int n2) {
        block8: {
            block7: {
                block9: {
                    stringArray = (StorageManager)stringArray.getSystemService("storage");
                    Class<?> clazz = stringArray.getClass();
                    Method method = clazz.getMethod("getVolumePaths", new Class[0]);
                    stringArray = (String[])method.invoke((Object)stringArray, new Object[0]);
                    if (n2 == 0) break block7;
                    if (n2 != 1) break block8;
                    if (stringArray.length <= 1) break block9;
                    return stringArray[n2];
                }
                return null;
            }
            try {
                return stringArray[n2];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

