/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.content.Context;

public final class DensityUtils {
    private static final float DOT_FIVE = 0.5f;

    private DensityUtils() {
    }

    public static int sp2px(Context context, float f2) {
        return (int)(f2 * context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

    public static int dip2px(Context context, float f2) {
        return (int)(f2 * DensityUtils.getDensity(context) + 0.5f);
    }

    public static int px2dip(Context context, float f2) {
        return (int)(f2 / DensityUtils.getDensity(context) + 0.5f);
    }

    public static int getDisplayWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getDisplayHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getDensityDpi(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }
}

