/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facelive.api.manager;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.idl.face.platform.utils.FileUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.QualityConfig;
import org.json.JSONException;
import org.json.JSONObject;

public class QualityConfigManager {
    private static final String FILE_NAME_QUALITY = "quality_config.json";
    private static QualityConfigManager instance;
    private QualityConfig mQualityConfig = new QualityConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QualityConfigManager getInstance() {
        if (instance != null) return instance;
        Class<QualityConfigManager> clazz = QualityConfigManager.class;
        synchronized (QualityConfigManager.class) {
            if (instance != null) return instance;
            instance = new QualityConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private QualityConfigManager() {
    }

    public QualityConfig getConfig() {
        return this.mQualityConfig;
    }

    public void readQualityFile(Context context, int qualityGrade) {
        try {
            String json = FileUtils.readAssetFileUtf8String((AssetManager)context.getAssets(), (String)FILE_NAME_QUALITY);
            JSONObject jsonObject = new JSONObject(json);
            JSONObject newObject = null;
            if (qualityGrade == 0) {
                newObject = jsonObject.optJSONObject("normal");
            } else if (qualityGrade == 1) {
                newObject = jsonObject.optJSONObject("loose");
            } else if (qualityGrade == 2) {
                newObject = jsonObject.optJSONObject("strict");
            } else if (qualityGrade == 3) {
                json = FaceLiveManager.getInstance().getFaceConfig().getCustomJson();
                newObject = TextUtils.isEmpty((CharSequence)json) ? jsonObject.optJSONObject("normal") : new JSONObject(json);
            }
            this.mQualityConfig.parseFromJSONObject(newObject);
        }
        catch (JSONException e) {
            Log.e((String)this.getClass().getName(), (String)"\u521d\u59cb\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25, JSON\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            this.mQualityConfig = null;
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getName(), (String)"\u521d\u59cb\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25, JSON\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
            this.mQualityConfig = null;
        }
    }
}

