/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facelive.api.entity;

import android.content.Context;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceEnvironment;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.facelive.api.entity.LivenessValueModel;
import com.baidu.idl.facelive.api.entity.QualityConfig;
import com.baidu.idl.facelive.api.entity.ViewBackgroundType;
import com.baidu.idl.facelive.api.manager.QualityConfigManager;
import com.baidu.liantian.ac.LH;
import java.util.ArrayList;
import java.util.List;

public class FaceLiveConfig
extends FaceConfig {
    private static final String TAG = FaceLiveConfig.class.getName();
    private int qualityLevel = 0;
    private boolean isOpenRecord = false;
    private List<String> phoneList = null;
    private LivenessValueModel livenessValueModel = new LivenessValueModel();
    private ViewBackgroundType backgroundType = ViewBackgroundType.WHITE;
    private String customJson;
    private boolean isShowResultView = true;
    private boolean isShowTimeoutDialog = true;
    private boolean isIgnoreRecordError = true;

    public int getQualityLevel() {
        return this.qualityLevel;
    }

    public void setQualityLevel(Context context, int qualityLevel) throws Exception {
        this.qualityLevel = qualityLevel;
        QualityConfigManager manager = QualityConfigManager.getInstance();
        manager.readQualityFile(context.getApplicationContext(), qualityLevel);
        QualityConfig qualityConfig = manager.getConfig();
        if (qualityConfig == null) {
            this.setDefaultQualityData();
            return;
        }
        this.setBlurnessValue(qualityConfig.getBlur());
        this.setBrightnessValue(qualityConfig.getMinIllum());
        this.setBrightnessMaxValue(qualityConfig.getMaxIllum());
        this.setOcclusionLeftEyeValue(qualityConfig.getLeftEyeOcclusion());
        this.setOcclusionRightEyeValue(qualityConfig.getRightEyeOcclusion());
        this.setOcclusionNoseValue(qualityConfig.getNoseOcclusion());
        this.setOcclusionMouthValue(qualityConfig.getMouseOcclusion());
        this.setOcclusionLeftContourValue(qualityConfig.getLeftContourOcclusion());
        this.setOcclusionRightContourValue(qualityConfig.getRightContourOcclusion());
        this.setOcclusionChinValue(qualityConfig.getChinOcclusion());
        this.setHeadPitchValue(qualityConfig.getPitch());
        this.setHeadYawValue(qualityConfig.getYaw());
        this.setHeadRollValue(qualityConfig.getRoll());
    }

    public void setLivenessValueModel(LivenessValueModel livenessValueModel) throws Exception {
        ArrayList<LivenessTypeEnum> actionList = new ArrayList<LivenessTypeEnum>();
        actionList.clear();
        actionList.addAll(livenessValueModel.actionList);
        if (livenessValueModel.actionList.size() == 0) {
            this.livenessValueModel.actionList.addAll(FaceEnvironment.livenessTypeDefaultList);
        } else {
            this.livenessValueModel.actionList.clear();
            this.livenessValueModel.actionList.addAll(actionList);
        }
        this.livenessValueModel.actionRandomNumber = livenessValueModel.actionRandomNumber;
    }

    public LivenessValueModel getLivenessValueModel() {
        return this.livenessValueModel;
    }

    public boolean isOpenRecord() {
        return this.isOpenRecord;
    }

    public void setOpenRecord(boolean openRecord) {
        this.isOpenRecord = openRecord;
    }

    public List<String> getPhoneList() {
        return this.phoneList;
    }

    public void setPhoneList(List<String> phoneList) {
        this.phoneList = phoneList;
    }

    public ViewBackgroundType getBackgroundType() {
        return this.backgroundType;
    }

    public void setBackgroundType(ViewBackgroundType backgroundType) {
        this.backgroundType = backgroundType;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public boolean isShowResultView() {
        return this.isShowResultView;
    }

    public void setShowResultView(boolean showResultView) {
        this.isShowResultView = showResultView;
    }

    public boolean isShowTimeoutDialog() {
        return this.isShowTimeoutDialog;
    }

    public void setIsShowTimeoutDialog(boolean showTimeoutDialog) {
        this.isShowTimeoutDialog = showTimeoutDialog;
    }

    private void setDefaultQualityData() {
        this.setBlurnessValue(0.7f);
        this.setBrightnessValue(40.0f);
        this.setBrightnessMaxValue(220.0f);
        this.setOcclusionLeftEyeValue(0.8f);
        this.setOcclusionRightEyeValue(0.8f);
        this.setOcclusionNoseValue(0.8f);
        this.setOcclusionMouthValue(0.8f);
        this.setOcclusionLeftContourValue(0.8f);
        this.setOcclusionRightContourValue(0.8f);
        this.setOcclusionChinValue(0.8f);
        this.setHeadPitchValue(20);
        this.setHeadYawValue(18);
        this.setHeadRollValue(20);
    }

    public boolean isIgnoreRecordError() {
        return this.isIgnoreRecordError;
    }

    public void setIgnoreRecordError(boolean ignoreRecordError) {
        this.isIgnoreRecordError = ignoreRecordError;
        LH.setIgnoreRecordError((boolean)this.isIgnoreRecordError);
    }
}

