/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facelive.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.listener.IInitCallback;
import com.baidu.idl.face.platform.model.VersionInfo;
import com.baidu.idl.face.platform.ui.FaceActionLivenessActivity;
import com.baidu.idl.face.platform.ui.FaceActionLivenessVideoActivity;
import com.baidu.idl.face.platform.ui.FaceColorLivenessActivity;
import com.baidu.idl.face.platform.ui.FaceColorLivenessVideoActivity;
import com.baidu.idl.face.platform.ui.FaceSilenceLivenessActivity;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.utils.SystemUtils;
import com.baidu.idl.facelive.api.FaceInitStatusConvert;
import com.baidu.idl.facelive.api.FaceInitStatusEnum;
import com.baidu.idl.facelive.api.callback.InitCallback;
import com.baidu.idl.facelive.api.callback.LivenessCallback;
import com.baidu.idl.facelive.api.entity.FaceLiveConfig;
import com.baidu.idl.facelive.api.entity.InitOption;
import com.baidu.idl.facelive.api.entity.LivenessOption;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.manager.FaceCallbackManager;
import com.baidu.liantian.ac.LH;
import java.io.Serializable;

public class FaceLiveManager {
    private static final String TAG = FaceLiveManager.class.getName();
    private static FaceLiveManager faceLiveManager = new FaceLiveManager();
    private FaceLiveConfig mFaceLiveConfig = new FaceLiveConfig();
    private boolean mInitSuccess;

    public static FaceLiveManager getInstance() {
        return faceLiveManager;
    }

    public FaceLiveConfig getFaceConfig() {
        return this.mFaceLiveConfig;
    }

    public void setFaceConfig(FaceLiveConfig faceLiveConfig) {
        this.mFaceLiveConfig = faceLiveConfig;
        FaceSDKManager.getInstance().setFaceConfig((FaceConfig)this.mFaceLiveConfig);
    }

    public void init(Context context, InitOption initOption, final InitCallback initCallback) {
        FaceSDKManager.getInstance().initialize(context, initOption.licenseKey, initOption.licenseFileName, new IInitCallback(){

            public void initSuccess() {
                FaceLiveManager.this.mInitSuccess = true;
                if (initCallback != null) {
                    FaceInitStatusEnum msg = FaceInitStatusConvert.getConvertInitStatusCode(0);
                    int code = msg.getState();
                    initCallback.onSuccess(code, "[" + (Object)((Object)msg) + "]");
                }
            }

            public void initFailure(int errCode, String errMsg) {
                FaceLiveManager.this.mInitSuccess = false;
                if (initCallback != null) {
                    FaceInitStatusEnum msg = FaceInitStatusConvert.getConvertInitStatusCode(errCode);
                    int code = msg.getState();
                    initCallback.onError(code, "[" + (Object)((Object)msg) + "]");
                }
            }
        });
    }

    public void startFaceLiveness(Activity activity, LivenessOption livenessOption, LivenessCallback livenessCallback) {
        if (livenessCallback == null) {
            return;
        }
        if (LH.isProcessRunnning()) {
            return;
        }
        if (activity == null) {
            LivenessResult livenessResult = new LivenessResult();
            livenessResult.setSafetyCode(-1);
            livenessCallback.onLivenessResult(livenessResult);
            return;
        }
        FaceCallbackManager.getInstance().mLivenessCallback = livenessCallback;
        if (!this.mFaceLiveConfig.isOpenRecord()) {
            this.selectActivityForLiveType(activity, livenessOption, false);
        } else {
            boolean isPhoneNoCompatible = false;
            if (this.mFaceLiveConfig.getPhoneList() == null || this.mFaceLiveConfig.getPhoneList().size() == 0) {
                isPhoneNoCompatible = false;
            } else {
                for (int i = 0; i < this.mFaceLiveConfig.getPhoneList().size(); ++i) {
                    String phone = this.mFaceLiveConfig.getPhoneList().get(i);
                    String brand = phone.split("_")[0];
                    String model = phone.split("_")[1];
                    if (!brand.equals(Build.BRAND) || !model.equals(Build.MODEL)) continue;
                    isPhoneNoCompatible = true;
                }
            }
            if (isPhoneNoCompatible) {
                this.selectActivityForLiveType(activity, livenessOption, true);
            } else if (this.mFaceLiveConfig.isOpenColorLive() && !this.mFaceLiveConfig.isOpenActionLive()) {
                this.setIsOpenActionLive(false);
                this.startActivity((Context)activity, FaceColorLivenessVideoActivity.class, false, this.mInitSuccess, livenessOption);
            } else if (this.mFaceLiveConfig.isOpenColorLive() || this.mFaceLiveConfig.isOpenActionLive()) {
                if (!this.mFaceLiveConfig.isOpenColorLive() && this.mFaceLiveConfig.isOpenActionLive()) {
                    this.startActivity((Context)activity, FaceActionLivenessVideoActivity.class, false, this.mInitSuccess, livenessOption);
                } else if (this.mFaceLiveConfig.isOpenColorLive() && this.mFaceLiveConfig.isOpenActionLive()) {
                    this.setIsOpenActionLive(true);
                    this.startActivity((Context)activity, FaceColorLivenessVideoActivity.class, false, this.mInitSuccess, livenessOption);
                }
            }
        }
    }

    public boolean release() {
        FaceSDKManager.getInstance().release();
        IntentUtils.getInstance().release();
        return true;
    }

    public String getVersion(Context context) {
        try {
            VersionInfo versionInfo = SystemUtils.getVersionInfo((Context)context);
            return versionInfo.getVersionName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return FaceSDKManager.getVersion();
        }
    }

    private void selectActivityForLiveType(Activity activity, LivenessOption livenessOption, boolean isFrameExtraction) {
        if (this.mFaceLiveConfig.isOpenColorLive() && !this.mFaceLiveConfig.isOpenActionLive()) {
            this.setIsOpenActionLive(false);
            this.startActivity((Context)activity, FaceColorLivenessActivity.class, isFrameExtraction, this.mInitSuccess, livenessOption);
        } else if (this.mFaceLiveConfig.isOpenColorLive() && this.mFaceLiveConfig.isOpenActionLive()) {
            this.setIsOpenActionLive(true);
            this.startActivity((Context)activity, FaceColorLivenessActivity.class, isFrameExtraction, this.mInitSuccess, livenessOption);
        } else if (!this.mFaceLiveConfig.isOpenColorLive() && !this.mFaceLiveConfig.isOpenActionLive()) {
            this.startActivity((Context)activity, FaceSilenceLivenessActivity.class, isFrameExtraction, this.mInitSuccess, livenessOption);
        } else if (!this.mFaceLiveConfig.isOpenColorLive() && this.mFaceLiveConfig.isOpenActionLive()) {
            this.startActivity((Context)activity, FaceActionLivenessActivity.class, isFrameExtraction, this.mInitSuccess, livenessOption);
        }
    }

    private void startActivity(Context packageContext, Class<?> cls, boolean isFrameExtraction, boolean isInitSuccess, LivenessOption livenessOption) {
        Intent intent = new Intent(packageContext, cls);
        intent.putExtra("livenessOption", (Serializable)livenessOption);
        intent.putExtra("frameExtraction", isFrameExtraction);
        intent.putExtra("initSuccess", isInitSuccess);
        packageContext.startActivity(intent);
    }

    private void setIsOpenActionLive(boolean isOpen) {
        FaceConfig faceConfig = FaceSDKManager.getInstance().getFaceConfig();
        faceConfig.setIsOpenActionLive(isOpen);
        FaceSDKManager.getInstance().setFaceConfig(faceConfig);
    }
}

