/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.ViewBackgroundType;

public class TimeoutDialog
extends Dialog
implements View.OnClickListener {
    private Context mContext;
    private OnTimeoutDialogClickListener mOnTimeoutDialogClickListener;

    public TimeoutDialog(@NonNull Context context) {
        super(context, R.style.DefaultDialog);
        this.mContext = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initView();
    }

    private void initView() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View view = inflater.inflate(R.layout.dialog_time_out, null);
        this.setContentView(view);
        Window dialogWindow = this.getWindow();
        if (dialogWindow != null) {
            dialogWindow.setGravity(1);
            WindowManager.LayoutParams lp = dialogWindow.getAttributes();
            int widthPx = DensityUtils.getDisplayWidth((Context)this.getContext());
            int dp = DensityUtils.px2dip((Context)this.getContext(), (float)widthPx) - 40;
            lp.width = DensityUtils.dip2px((Context)this.getContext(), (float)dp);
            lp.height = -2;
            dialogWindow.setAttributes(lp);
        }
        TextView textTitle = (TextView)view.findViewById(R.id.text_title);
        RelativeLayout relativeDialogBg = (RelativeLayout)view.findViewById(R.id.relative_dialog_bg);
        Button btnDialogRecollect = (Button)view.findViewById(R.id.btn_dialog_recollect);
        Button btnDialogReturn = (Button)view.findViewById(R.id.btn_dialog_return);
        ViewBackgroundType backgroundType = FaceLiveManager.getInstance().getFaceConfig().getBackgroundType();
        if (backgroundType == ViewBackgroundType.WHITE) {
            textTitle.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_title_text));
            btnDialogRecollect.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_recollect_text));
            btnDialogReturn.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_return_text));
            relativeDialogBg.setBackgroundResource(R.drawable.bg_round_time_out);
            btnDialogRecollect.setBackgroundResource(R.drawable.dialog_timeout_button_recollect_selector);
            btnDialogReturn.setBackgroundResource(R.drawable.dialog_timeout_button_return_selector);
        } else if (backgroundType == ViewBackgroundType.BLACK) {
            textTitle.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_title_text_black));
            btnDialogRecollect.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_recollect_text_black));
            btnDialogReturn.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_return_text_black));
            relativeDialogBg.setBackgroundResource(R.drawable.bg_round_time_out_black);
            btnDialogRecollect.setBackgroundResource(R.drawable.dialog_timeout_button_recollect_selector_black);
            btnDialogReturn.setBackgroundResource(R.drawable.dialog_timeout_button_return_selector_black);
        } else if (backgroundType == ViewBackgroundType.CUSTOM) {
            textTitle.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_title_text_custom));
            btnDialogRecollect.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_recollect_text_custom));
            btnDialogReturn.setTextColor(this.mContext.getResources().getColor(R.color.face_liveness_timeout_dialog_return_text_custom));
            relativeDialogBg.setBackgroundResource(R.drawable.bg_round_time_out_custom);
            btnDialogRecollect.setBackgroundResource(R.drawable.dialog_timeout_button_recollect_selector_custom);
            btnDialogReturn.setBackgroundResource(R.drawable.dialog_timeout_button_return_selector_custom);
        }
        btnDialogRecollect.setOnClickListener((View.OnClickListener)this);
        btnDialogReturn.setOnClickListener((View.OnClickListener)this);
    }

    public void setDialogListener(OnTimeoutDialogClickListener listener) {
        this.mOnTimeoutDialogClickListener = listener;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.btn_dialog_recollect) {
            if (this.mOnTimeoutDialogClickListener != null) {
                this.mOnTimeoutDialogClickListener.onRecollect();
            }
        } else if (i == R.id.btn_dialog_return && this.mOnTimeoutDialogClickListener != null) {
            this.mOnTimeoutDialogClickListener.onReturn();
        }
    }

    public static interface OnTimeoutDialogClickListener {
        public void onRecollect();

        public void onReturn();
    }
}

