/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.utils.DensityUtils;

public class FaceDetectRoundView
extends RelativeLayout {
    private static final String TAG = FaceDetectRoundView.class.getSimpleName();
    public static final float SURFACE_HEIGHT = 1000.0f;
    public static final float SURFACE_RATIO = 0.75f;
    public static final float WIDTH_SPACE_RATIO = 0.33f;
    public static final float HEIGHT_RATIO = 0.1f;
    public static final float HEIGHT_EXT_RATIO = 0.2f;
    public static final int PATH_SPACE = 16;
    public static final int PATH_SMALL_SPACE = 12;
    public static final float CIRCLE_LINE_WIDTH = 4.0f;
    public static final float RECT_RATIO = 0.9f;
    public static final int COLOR_ROUND = Color.parseColor((String)"#FFA800");
    public static final int COLOR_ROUND_BORDER1 = Color.parseColor((String)"#26171D24");
    public static final int COLOR_ROUND_BORDER2 = Color.parseColor((String)"#0D171D24");
    private TextView mTextViewTop;
    private TextView mTextViewSecond;
    private RelativeLayout.LayoutParams mLayoutParamsTop;
    private RelativeLayout.LayoutParams mLayoutParamsSecond;
    private Paint mBGPaint;
    private Paint mFaceRoundPaint;
    private Paint mCircleLinePaint;
    private Paint mCircleLineSelectPaint;
    private Rect mFaceRect;
    private Rect mFaceDetectRect;
    private Paint mCircleBorderPaint1;
    private Paint mCircleBorderPaint2;
    private Paint mFaceRoundShadePaint;
    private float mX;
    private float mY;
    private float mR;
    private int mTotalActiveCount;
    private int mSuccessActiveCount;
    private boolean mIsActiveLive;
    private static float mRatioX;
    private static float mRatioY;
    private FaceExtInfo mFaceExtInfo;
    private InternalView internalView;
    private int mTopTextPaintColor;
    private int mSecondTextPaintColor;

    public FaceDetectRoundView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FaceDetectRoundView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
        this.internalView = new InternalView(context, attrs, defStyleAttr);
        this.internalView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView(this.internalView);
        this.mTextViewSecond = new TextView(context);
        this.mLayoutParamsSecond = new RelativeLayout.LayoutParams(-2, -2);
        this.mTextViewSecond.setMaxLines(2);
        this.mTextViewSecond.setTextColor(this.mSecondTextPaintColor);
        this.mTextViewSecond.setTextSize(16.0f);
        this.mTextViewSecond.setLineSpacing((float)DensityUtils.dip2px((Context)this.getContext(), (float)18.0f), 0.0f);
        this.mTextViewSecond.setPadding(DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0, DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0);
        this.mTextViewSecond.setGravity(17);
        this.mTextViewTop = new TextView(context);
        this.mLayoutParamsTop = new RelativeLayout.LayoutParams(-2, -2);
        this.mTextViewTop.setMaxLines(2);
        this.mTextViewTop.setTextColor(this.mTopTextPaintColor);
        this.mTextViewTop.setTextSize(22.0f);
        this.mTextViewTop.setLineSpacing((float)DensityUtils.dip2px((Context)this.getContext(), (float)24.0f), 0.0f);
        this.mTextViewTop.setGravity(17);
        this.mTextViewTop.setPadding(DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0, DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0);
        this.mTextViewTop.setTypeface(Typeface.defaultFromStyle((int)1));
        this.addView((View)this.mTextViewSecond);
        this.addView((View)this.mTextViewTop);
    }

    public void setProcessCount(int successActiveCount, int totalActiveCount) {
        this.mSuccessActiveCount = successActiveCount;
        this.mTotalActiveCount = totalActiveCount;
        this.internalView.postInvalidate();
    }

    public void setFaceInfo(FaceExtInfo faceExtInfo) {
        this.mFaceExtInfo = faceExtInfo;
        this.internalView.postInvalidate();
    }

    public void setIsActiveLive(boolean isActiveLive) {
        this.mIsActiveLive = isActiveLive;
    }

    public void setIsShowShade(boolean isShowShade) {
        if (isShowShade) {
            this.mFaceRoundShadePaint.setColor(Color.parseColor((String)"#99FFFFFF"));
        } else {
            this.mFaceRoundShadePaint.setColor(0);
        }
        this.internalView.invalidate();
    }

    public void setTipTopText(String tipTopText) {
        this.mTextViewTop.setText((CharSequence)tipTopText);
        if (!TextUtils.isEmpty((CharSequence)tipTopText)) {
            this.internalView.invalidate();
        }
    }

    public void setTipSecondText(String tipSecondText) {
        this.mTextViewSecond.setText((CharSequence)tipSecondText);
        if (!TextUtils.isEmpty((CharSequence)tipSecondText)) {
            this.internalView.invalidate();
        }
    }

    public float getRound() {
        return this.mR;
    }

    public float getCircleCenterY() {
        return this.mY;
    }

    public Rect getFaceRoundRect() {
        if (this.mFaceRect != null) {
            Log.e((String)TAG, (String)this.mFaceRect.toString());
        }
        return this.mFaceRect;
    }

    public static Rect getPreviewDetectRect(int w, int pw, int ph) {
        float round = (float)(w / 2) - (float)(w / 2) * 0.33f;
        float x = pw / 2;
        float y = ph / 2;
        float r = (float)(pw / 2) > round ? round : (float)(pw / 2);
        float hr = r + r * 0.2f;
        Rect rect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
        return rect;
    }

    public Rect getPreviewDetectRect(int w, int h, int pw, int ph) {
        float round = (float)(w / 2) - (float)(w / 2) * 0.33f;
        mRatioX = (float)w * 1.0f / ((float)pw * 1.0f);
        mRatioY = (float)this.getHeight() * 1.0f / ((float)ph * 1.0f);
        float x = (float)pw / 2.0f * mRatioX;
        float y = (float)ph / 2.0f * mRatioY - (float)ph / 2.0f * mRatioY * 0.1f;
        float r = (float)pw / 2.0f * mRatioX > round ? round : (float)pw / 2.0f * mRatioX;
        float hr = r + r * 0.2f;
        Rect rect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
        return rect;
    }

    public static Rect getFaceInfoRect(FaceExtInfo faceInfo) {
        if (faceInfo == null) {
            return null;
        }
        return faceInfo.getFaceRect(mRatioX, mRatioY, 0.67499995f);
    }

    private class InternalView
    extends View {
        public InternalView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public InternalView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.setLayerType(1, null);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FaceDetectRoundView, defStyle, 0);
            int bgPaintColor = a.getColor(R.styleable.FaceDetectRoundView_face_liveness_verify_bg, context.getResources().getColor(R.color.face_liveness_verify_bg));
            int linePaintColor = a.getColor(R.styleable.FaceDetectRoundView_face_liveness_initial_border, context.getResources().getColor(R.color.face_liveness_initial_border));
            int lineSelectPaintColor = a.getColor(R.styleable.FaceDetectRoundView_face_liveness_progress_border, context.getResources().getColor(R.color.face_liveness_progress_border));
            FaceDetectRoundView.this.mTopTextPaintColor = a.getColor(R.styleable.FaceDetectRoundView_face_liveness_tips_text, context.getResources().getColor(R.color.face_liveness_tips_text));
            FaceDetectRoundView.this.mSecondTextPaintColor = a.getColor(R.styleable.FaceDetectRoundView_face_liveness_tips_small_text, context.getResources().getColor(R.color.face_liveness_tips_small_text));
            a.recycle();
            float circleLineWidth = DensityUtils.dip2px((Context)context, (float)4.0f);
            FaceDetectRoundView.this.mBGPaint = new Paint(1);
            FaceDetectRoundView.this.mBGPaint.setColor(bgPaintColor);
            FaceDetectRoundView.this.mBGPaint.setStyle(Paint.Style.FILL);
            FaceDetectRoundView.this.mBGPaint.setAntiAlias(true);
            FaceDetectRoundView.this.mBGPaint.setDither(true);
            FaceDetectRoundView.this.mFaceRoundPaint = new Paint(1);
            FaceDetectRoundView.this.mFaceRoundPaint.setColor(COLOR_ROUND);
            FaceDetectRoundView.this.mFaceRoundPaint.setStyle(Paint.Style.FILL);
            FaceDetectRoundView.this.mFaceRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            FaceDetectRoundView.this.mFaceRoundPaint.setAntiAlias(true);
            FaceDetectRoundView.this.mFaceRoundPaint.setDither(true);
            FaceDetectRoundView.this.mCircleLinePaint = new Paint(1);
            FaceDetectRoundView.this.mCircleLinePaint.setColor(linePaintColor);
            FaceDetectRoundView.this.mCircleLinePaint.setStrokeWidth(circleLineWidth);
            FaceDetectRoundView.this.mCircleLinePaint.setStyle(Paint.Style.STROKE);
            FaceDetectRoundView.this.mCircleLinePaint.setStrokeCap(Paint.Cap.ROUND);
            FaceDetectRoundView.this.mCircleLinePaint.setAntiAlias(true);
            FaceDetectRoundView.this.mCircleLinePaint.setDither(true);
            FaceDetectRoundView.this.mCircleLineSelectPaint = new Paint(1);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setColor(lineSelectPaintColor);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setStrokeWidth(circleLineWidth);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setStyle(Paint.Style.STROKE);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setStrokeCap(Paint.Cap.ROUND);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setAntiAlias(true);
            FaceDetectRoundView.this.mCircleLineSelectPaint.setDither(true);
            FaceDetectRoundView.this.mCircleBorderPaint1 = new Paint(1);
            FaceDetectRoundView.this.mCircleBorderPaint1.setColor(COLOR_ROUND_BORDER1);
            FaceDetectRoundView.this.mCircleBorderPaint1.setStyle(Paint.Style.STROKE);
            FaceDetectRoundView.this.mCircleBorderPaint1.setStrokeWidth(10.0f);
            FaceDetectRoundView.this.mCircleBorderPaint1.setAntiAlias(true);
            FaceDetectRoundView.this.mCircleBorderPaint1.setDither(true);
            FaceDetectRoundView.this.mCircleBorderPaint2 = new Paint(1);
            FaceDetectRoundView.this.mCircleBorderPaint2.setColor(COLOR_ROUND_BORDER2);
            FaceDetectRoundView.this.mCircleBorderPaint2.setStyle(Paint.Style.STROKE);
            FaceDetectRoundView.this.mCircleBorderPaint2.setStrokeWidth(10.0f);
            FaceDetectRoundView.this.mCircleBorderPaint2.setAntiAlias(true);
            FaceDetectRoundView.this.mCircleBorderPaint2.setDither(true);
            FaceDetectRoundView.this.mFaceRoundShadePaint = new Paint(1);
            FaceDetectRoundView.this.mFaceRoundShadePaint.setStyle(Paint.Style.FILL);
            FaceDetectRoundView.this.mFaceRoundShadePaint.setAntiAlias(true);
            FaceDetectRoundView.this.mFaceRoundShadePaint.setDither(true);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            float canvasWidth = right - left;
            float canvasHeight = bottom - top;
            float x = canvasWidth / 2.0f;
            float y = canvasHeight / 2.0f - canvasHeight / 2.0f * 0.1f;
            float r = canvasWidth / 2.0f - canvasWidth / 2.0f * 0.33f;
            if (FaceDetectRoundView.this.mFaceRect == null) {
                FaceDetectRoundView.this.mFaceRect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
            }
            if (FaceDetectRoundView.this.mFaceDetectRect == null) {
                float hr = r + r * 0.2f;
                FaceDetectRoundView.this.mFaceDetectRect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
            }
            FaceDetectRoundView.this.mX = x;
            FaceDetectRoundView.this.mY = y;
            FaceDetectRoundView.this.mR = r;
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (FaceDetectRoundView.this.mTextViewSecond == null || FaceDetectRoundView.this.mLayoutParamsSecond == null) {
                        return;
                    }
                    float topSecond = FaceDetectRoundView.this.mY - FaceDetectRoundView.this.mR - 40.0f - 25.0f - (float)DensityUtils.dip2px((Context)InternalView.this.getContext(), (float)16.0f) - 65.0f;
                    FaceDetectRoundView.this.mLayoutParamsSecond.setMargins(0, (int)topSecond, 0, 0);
                    FaceDetectRoundView.this.mLayoutParamsSecond.addRule(14);
                    FaceDetectRoundView.this.mTextViewSecond.setLayoutParams((ViewGroup.LayoutParams)FaceDetectRoundView.this.mLayoutParamsSecond);
                    if (FaceDetectRoundView.this.mTextViewTop == null || FaceDetectRoundView.this.mLayoutParamsTop == null) {
                        return;
                    }
                    float topTop = FaceDetectRoundView.this.mY - FaceDetectRoundView.this.mR - 40.0f - 25.0f - (float)DensityUtils.dip2px((Context)InternalView.this.getContext(), (float)22.0f) - 210.0f;
                    FaceDetectRoundView.this.mLayoutParamsTop.setMargins(0, (int)topTop, 0, 0);
                    FaceDetectRoundView.this.mLayoutParamsTop.addRule(14);
                    FaceDetectRoundView.this.mTextViewTop.setLayoutParams((ViewGroup.LayoutParams)FaceDetectRoundView.this.mLayoutParamsTop);
                }
            });
        }

        public void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            canvas.drawColor(0);
            canvas.drawPaint(FaceDetectRoundView.this.mBGPaint);
            canvas.drawCircle(FaceDetectRoundView.this.mX, FaceDetectRoundView.this.mY, FaceDetectRoundView.this.mR, FaceDetectRoundView.this.mFaceRoundPaint);
            canvas.drawCircle(FaceDetectRoundView.this.mX, FaceDetectRoundView.this.mY, FaceDetectRoundView.this.mR - 5.0f, FaceDetectRoundView.this.mCircleBorderPaint1);
            canvas.drawCircle(FaceDetectRoundView.this.mX, FaceDetectRoundView.this.mY, FaceDetectRoundView.this.mR - 15.0f, FaceDetectRoundView.this.mCircleBorderPaint2);
            canvas.drawCircle(FaceDetectRoundView.this.mX, FaceDetectRoundView.this.mY, FaceDetectRoundView.this.mR, FaceDetectRoundView.this.mFaceRoundShadePaint);
            if (FaceDetectRoundView.this.mIsActiveLive) {
                canvas.translate(FaceDetectRoundView.this.mX, FaceDetectRoundView.this.mY);
                this.drawCircleLine(canvas);
                this.drawSuccessCircleLine(canvas);
            }
        }

        private void drawCircleLine(Canvas canvas) {
            canvas.save();
            canvas.rotate(-90.0f);
            for (int j = 0; j < 360; j += 6) {
                canvas.drawLine(FaceDetectRoundView.this.mR + 40.0f, 0.0f, FaceDetectRoundView.this.mR + 40.0f + 25.0f, 0.0f, FaceDetectRoundView.this.mCircleLinePaint);
                canvas.rotate(6.0f);
            }
            canvas.restore();
        }

        private void drawSuccessCircleLine(Canvas canvas) {
            int degree = (int)((float)FaceDetectRoundView.this.mSuccessActiveCount / (float)FaceDetectRoundView.this.mTotalActiveCount * 360.0f);
            canvas.save();
            canvas.rotate(-90.0f);
            for (int j = 0; j < degree; j += 6) {
                canvas.drawLine(FaceDetectRoundView.this.mR + 40.0f, 0.0f, FaceDetectRoundView.this.mR + 40.0f + 25.0f, 0.0f, FaceDetectRoundView.this.mCircleLineSelectPaint);
                canvas.rotate(6.0f);
            }
            canvas.restore();
        }
    }
}

