/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.utils.DensityUtils;
import java.util.ArrayList;
import java.util.List;

public class FaceAuraColorView
extends RelativeLayout {
    private static final String TAG = FaceAuraColorView.class.getSimpleName();
    public static final float WIDTH_SPACE_RATIO = 0.33f;
    public static final float HEIGHT_RATIO = 0.1f;
    public static final float HEIGHT_EXT_RATIO = 0.2f;
    public static final int COLOR_ROUND = Color.parseColor((String)"#FFA800");
    public static final int COLOR_ROUND_BORDER1 = Color.parseColor((String)"#26171D24");
    public static final int COLOR_ROUND_BORDER2 = Color.parseColor((String)"#0D171D24");
    private TextView mTextViewTop;
    private TextView mTextViewSecond;
    private RelativeLayout.LayoutParams mLayoutParamsTop;
    private RelativeLayout.LayoutParams mLayoutParamsSecond;
    private int mBgPaintColor;
    private static final int DEFAULT_DIFFUSESPEED = 120;
    private int mDiffuseSpeed = 120;
    private int alphaBackground = 255;
    private Integer mMaxWidth = 1920;
    private boolean mIsDiffuse;
    private List<Integer> mWidths = new ArrayList<Integer>();
    private Paint mDiffusePaint;
    private Paint mBGPaint;
    private Paint mFaceRoundPaint;
    private Rect mFaceRect;
    private Rect mFaceDetectRect;
    private Paint mCircleBorderPaint1;
    private Paint mCircleBorderPaint2;
    private float mX;
    private float mY;
    private float mR;
    private InternalView internalView;
    private int mTopTextPaintColor;
    private int mSecondTextPaintColor;

    public FaceAuraColorView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FaceAuraColorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
        this.internalView = new InternalView(context, attrs, defStyleAttr);
        this.internalView.setVisibility(0);
        this.internalView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView(this.internalView);
        this.mTextViewSecond = new TextView(context);
        this.mLayoutParamsSecond = new RelativeLayout.LayoutParams(-2, -2);
        this.mTextViewSecond.setMaxLines(2);
        this.mTextViewSecond.setVisibility(0);
        this.mTextViewSecond.setTextColor(this.mSecondTextPaintColor);
        this.mTextViewSecond.setTextSize(16.0f);
        this.mTextViewSecond.setLineSpacing((float)DensityUtils.dip2px((Context)this.getContext(), (float)18.0f), 0.0f);
        this.mTextViewSecond.setPadding(DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0, DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0);
        this.mTextViewSecond.setGravity(17);
        this.mTextViewTop = new TextView(context);
        this.mLayoutParamsTop = new RelativeLayout.LayoutParams(-2, -2);
        this.mTextViewTop.setGravity(1);
        this.mTextViewTop.setMaxLines(2);
        this.mTextViewTop.setTextColor(this.mTopTextPaintColor);
        this.mTextViewTop.setTextSize(22.0f);
        this.mTextViewTop.setLineSpacing((float)DensityUtils.dip2px((Context)this.getContext(), (float)24.0f), 0.0f);
        this.mTextViewTop.setPadding(DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0, DensityUtils.dip2px((Context)this.getContext(), (float)10.0f), 0);
        this.mTextViewTop.setVisibility(0);
        this.mTextViewTop.setTypeface(Typeface.defaultFromStyle((int)1));
        this.addView((View)this.mTextViewSecond);
        this.addView((View)this.mTextViewTop);
    }

    public void updateTextColor(boolean isAura) {
        if (isAura) {
            this.mTextViewTop.setTextColor(-1);
        } else {
            this.mTextViewTop.setTextColor(this.getResources().getColor(R.color.face_liveness_tips_text));
        }
        this.internalView.postInvalidate();
    }

    public void setTipTopText(String tipTopText) {
        this.mTextViewTop.setText((CharSequence)tipTopText);
        if (!TextUtils.isEmpty((CharSequence)tipTopText)) {
            this.internalView.postInvalidate();
        }
    }

    public void setTipSecondText(String tipSecondText) {
        this.mTextViewSecond.setText((CharSequence)tipSecondText);
        if (!TextUtils.isEmpty((CharSequence)tipSecondText)) {
            this.internalView.postInvalidate();
        }
    }

    public void setColorBg(int colorBg) {
        if (colorBg == -1) {
            this.mBGPaint.setColor(this.mBgPaintColor);
            this.internalView.postInvalidate();
            return;
        }
        this.mBGPaint.setColor(colorBg);
        this.internalView.postInvalidate();
    }

    public void start(boolean isAuraColor, int color2) {
        this.mWidths.clear();
        this.mWidths.add(0);
        this.alphaBackground = 255;
        this.mDiffuseSpeed = 120;
        if (isAuraColor) {
            this.mDiffusePaint.setColor(color2);
        } else {
            this.mDiffusePaint.setColor(this.mBgPaintColor);
        }
        this.mIsDiffuse = true;
        this.internalView.postInvalidate();
    }

    public void release() {
        this.mWidths.clear();
        this.mIsDiffuse = false;
    }

    private class InternalView
    extends View {
        public InternalView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public InternalView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.setLayerType(1, null);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FaceAuraColorView, defStyle, 0);
            FaceAuraColorView.this.mBgPaintColor = a.getColor(R.styleable.FaceAuraColorView_face_liveness_verify_bg, context.getResources().getColor(R.color.face_liveness_verify_bg));
            FaceAuraColorView.this.mTopTextPaintColor = a.getColor(R.styleable.FaceAuraColorView_face_liveness_tips_text, context.getResources().getColor(R.color.face_liveness_tips_text));
            FaceAuraColorView.this.mSecondTextPaintColor = a.getColor(R.styleable.FaceAuraColorView_face_liveness_tips_small_text, context.getResources().getColor(R.color.face_liveness_tips_small_text));
            a.recycle();
            FaceAuraColorView.this.mBGPaint = new Paint(1);
            FaceAuraColorView.this.mBGPaint.setColor(FaceAuraColorView.this.mBgPaintColor);
            FaceAuraColorView.this.mBGPaint.setStyle(Paint.Style.FILL);
            FaceAuraColorView.this.mBGPaint.setAntiAlias(true);
            FaceAuraColorView.this.mBGPaint.setDither(true);
            FaceAuraColorView.this.mFaceRoundPaint = new Paint(1);
            FaceAuraColorView.this.mFaceRoundPaint.setColor(COLOR_ROUND);
            FaceAuraColorView.this.mFaceRoundPaint.setStyle(Paint.Style.FILL);
            FaceAuraColorView.this.mFaceRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            FaceAuraColorView.this.mFaceRoundPaint.setAntiAlias(true);
            FaceAuraColorView.this.mFaceRoundPaint.setDither(true);
            FaceAuraColorView.this.mDiffusePaint = new Paint();
            FaceAuraColorView.this.mDiffusePaint.setAntiAlias(true);
            FaceAuraColorView.this.mWidths.add(10);
            FaceAuraColorView.this.mCircleBorderPaint1 = new Paint(1);
            FaceAuraColorView.this.mCircleBorderPaint1.setColor(COLOR_ROUND_BORDER1);
            FaceAuraColorView.this.mCircleBorderPaint1.setStyle(Paint.Style.STROKE);
            FaceAuraColorView.this.mCircleBorderPaint1.setStrokeWidth(10.0f);
            FaceAuraColorView.this.mCircleBorderPaint1.setAntiAlias(true);
            FaceAuraColorView.this.mCircleBorderPaint1.setDither(true);
            FaceAuraColorView.this.mCircleBorderPaint2 = new Paint(1);
            FaceAuraColorView.this.mCircleBorderPaint2.setColor(COLOR_ROUND_BORDER2);
            FaceAuraColorView.this.mCircleBorderPaint2.setStyle(Paint.Style.STROKE);
            FaceAuraColorView.this.mCircleBorderPaint2.setStrokeWidth(10.0f);
            FaceAuraColorView.this.mCircleBorderPaint2.setAntiAlias(true);
            FaceAuraColorView.this.mCircleBorderPaint2.setDither(true);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            float canvasWidth = right - left;
            float canvasHeight = bottom - top;
            float x = canvasWidth / 2.0f;
            float y = canvasHeight / 2.0f - canvasHeight / 2.0f * 0.1f;
            float r = canvasWidth / 2.0f - canvasWidth / 2.0f * 0.33f;
            if (FaceAuraColorView.this.mFaceRect == null) {
                FaceAuraColorView.this.mFaceRect = new Rect((int)(x - r), (int)(y - r), (int)(x + r), (int)(y + r));
            }
            if (FaceAuraColorView.this.mFaceDetectRect == null) {
                float hr = r + r * 0.2f;
                FaceAuraColorView.this.mFaceDetectRect = new Rect((int)(x - r), (int)(y - hr), (int)(x + r), (int)(y + hr));
            }
            FaceAuraColorView.this.mX = x;
            FaceAuraColorView.this.mY = y;
            FaceAuraColorView.this.mR = r;
            FaceAuraColorView.this.mMaxWidth = (int)(canvasHeight - y);
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (FaceAuraColorView.this.mTextViewSecond == null || FaceAuraColorView.this.mLayoutParamsSecond == null) {
                        return;
                    }
                    float topSecond = FaceAuraColorView.this.mY - FaceAuraColorView.this.mR - 40.0f - 25.0f - (float)DensityUtils.dip2px((Context)InternalView.this.getContext(), (float)16.0f) - 65.0f;
                    FaceAuraColorView.this.mLayoutParamsSecond.setMargins(0, (int)topSecond, 0, 0);
                    FaceAuraColorView.this.mLayoutParamsSecond.addRule(14);
                    FaceAuraColorView.this.mTextViewSecond.setLayoutParams((ViewGroup.LayoutParams)FaceAuraColorView.this.mLayoutParamsSecond);
                    if (FaceAuraColorView.this.mTextViewTop == null || FaceAuraColorView.this.mLayoutParamsTop == null) {
                        return;
                    }
                    float topTop = FaceAuraColorView.this.mY - FaceAuraColorView.this.mR - 40.0f - 25.0f - (float)DensityUtils.dip2px((Context)InternalView.this.getContext(), (float)22.0f) - 210.0f;
                    FaceAuraColorView.this.mLayoutParamsTop.setMargins(0, (int)topTop, 0, 0);
                    FaceAuraColorView.this.mLayoutParamsTop.addRule(14);
                    FaceAuraColorView.this.mTextViewTop.setLayoutParams((ViewGroup.LayoutParams)FaceAuraColorView.this.mLayoutParamsTop);
                }
            });
        }

        public void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            FaceAuraColorView.this.mBGPaint.setAlpha(FaceAuraColorView.this.alphaBackground);
            canvas.drawPaint(FaceAuraColorView.this.mBGPaint);
            FaceAuraColorView.this.alphaBackground = FaceAuraColorView.this.alphaBackground - 20;
            if (FaceAuraColorView.this.mIsDiffuse) {
                canvas.drawCircle(FaceAuraColorView.this.mX, FaceAuraColorView.this.mY, FaceAuraColorView.this.mR + (float)FaceAuraColorView.this.mMaxWidth.intValue(), FaceAuraColorView.this.mDiffusePaint);
                FaceAuraColorView.this.internalView.postInvalidate();
            }
            canvas.drawCircle(FaceAuraColorView.this.mX, FaceAuraColorView.this.mY, FaceAuraColorView.this.mR, FaceAuraColorView.this.mFaceRoundPaint);
            canvas.drawCircle(FaceAuraColorView.this.mX, FaceAuraColorView.this.mY, FaceAuraColorView.this.mR - 5.0f, FaceAuraColorView.this.mCircleBorderPaint1);
            canvas.drawCircle(FaceAuraColorView.this.mX, FaceAuraColorView.this.mY, FaceAuraColorView.this.mR - 15.0f, FaceAuraColorView.this.mCircleBorderPaint2);
        }

        private void drawDiffuseCircle(Canvas canvas) {
            for (int i = 0; i < FaceAuraColorView.this.mWidths.size(); ++i) {
                Integer width = (Integer)FaceAuraColorView.this.mWidths.get(i);
                canvas.drawCircle(FaceAuraColorView.this.mX, FaceAuraColorView.this.mY, FaceAuraColorView.this.mR + (float)width.intValue(), FaceAuraColorView.this.mDiffusePaint);
                if (width < FaceAuraColorView.this.mMaxWidth) {
                    FaceAuraColorView.this.mWidths.set(i, width + FaceAuraColorView.this.mDiffuseSpeed);
                    FaceAuraColorView.this.mDiffuseSpeed = FaceAuraColorView.this.mDiffuseSpeed + 20;
                }
                if (!FaceAuraColorView.this.mIsDiffuse) continue;
                FaceAuraColorView.this.internalView.postInvalidate();
            }
        }
    }
}

