/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class VolumeUtils {
    public static final String TAG = VolumeUtils.class.getSimpleName();

    public static BroadcastReceiver registerVolumeReceiver(Context context, VolumeCallback callback) {
        VolumeReceiver mVolumeReceiver = null;
        try {
            mVolumeReceiver = new VolumeReceiver(callback);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.media.VOLUME_CHANGED_ACTION");
            context.registerReceiver((BroadcastReceiver)mVolumeReceiver, filter);
        }
        catch (IllegalArgumentException ex1) {
            ex1.printStackTrace();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        return mVolumeReceiver;
    }

    public static void unRegisterVolumeReceiver(Context context, BroadcastReceiver receiver) {
        try {
            if (context != null && receiver != null) {
                context.unregisterReceiver(receiver);
            }
        }
        catch (IllegalArgumentException ex1) {
            ex1.printStackTrace();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public static class VolumeReceiver
    extends BroadcastReceiver {
        private VolumeCallback callback;

        public VolumeReceiver(VolumeCallback cb) {
            this.callback = cb;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.VOLUME_CHANGED_ACTION") && this.callback != null) {
                this.callback.volumeChanged();
            }
        }
    }

    public static interface VolumeCallback {
        public void volumeChanged();
    }
}

