/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.utils;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.ViewBackgroundType;

public class ViewUtils {
    public static void changeTheme(Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            if (FaceLiveManager.getInstance().getFaceConfig().getBackgroundType() == ViewBackgroundType.WHITE) {
                activity.setTheme(R.style.Theme_White);
            } else if (FaceLiveManager.getInstance().getFaceConfig().getBackgroundType() == ViewBackgroundType.BLACK) {
                activity.setTheme(R.style.Theme_Black);
            } else if (FaceLiveManager.getInstance().getFaceConfig().getBackgroundType() == ViewBackgroundType.CUSTOM) {
                activity.setTheme(R.style.Theme_Custom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addFrame(RelativeLayout relativeLayoutAddImageView, ImageView imageFrame, FaceDetectRoundView faceDetectRoundView) {
        if (relativeLayoutAddImageView == null || imageFrame == null || faceDetectRoundView == null) {
            return;
        }
        try {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.height = (int)((double)faceDetectRoundView.getRound() * 2.2);
            layoutParams.width = (int)((double)faceDetectRoundView.getRound() * 2.2);
            float halfHeight = faceDetectRoundView.getHeight() / 2;
            layoutParams.setMargins(0, (int)(halfHeight - halfHeight * 0.1f) - layoutParams.height / 2, 0, 0);
            layoutParams.addRule(14);
            imageFrame.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageFrame.setScaleType(ImageView.ScaleType.FIT_XY);
            relativeLayoutAddImageView.addView((View)imageFrame);
            imageFrame.setBackgroundResource(R.mipmap.icon_collect_frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

