/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class HomeUtils {
    public static final String TAG = HomeUtils.class.getSimpleName();
    private static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    private static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    private static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";

    public static BroadcastReceiver registerHomeReceiver(Context context, HomeCallback callback) {
        HomeReceiver mHomeReceiver = null;
        try {
            mHomeReceiver = new HomeReceiver(callback);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver((BroadcastReceiver)mHomeReceiver, filter);
        }
        catch (IllegalArgumentException ex1) {
            ex1.printStackTrace();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        return mHomeReceiver;
    }

    public static void unRegisterHomeReceiver(Context context, BroadcastReceiver receiver) {
        try {
            if (context != null && receiver != null) {
                context.unregisterReceiver(receiver);
            }
        }
        catch (IllegalArgumentException ex1) {
            ex1.printStackTrace();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public static class HomeReceiver
    extends BroadcastReceiver {
        private HomeCallback callback;

        public HomeReceiver(HomeCallback cb) {
            this.callback = cb;
        }

        public void onReceive(Context context, Intent intent) {
            String reason;
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) && (reason = intent.getStringExtra(HomeUtils.SYSTEM_DIALOG_REASON_KEY)) != null && (HomeUtils.SYSTEM_DIALOG_REASON_HOME_KEY.equals(reason) || HomeUtils.SYSTEM_DIALOG_REASON_RECENT_APPS.equals(reason))) {
                this.callback.onClickHomeKey();
            }
        }
    }

    public static interface HomeCallback {
        public void onClickHomeKey();
    }
}

