/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui.utils;

import android.graphics.Point;
import android.hardware.Camera;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class CameraPreviewUtils {
    private static final String TAG = CameraPreviewUtils.class.getSimpleName();
    private static final int MIN_PREVIEW_PIXELS = 307200;
    private static final int MAX_PREVIEW_PIXELS = 2073600;

    public static Point getBestPreview(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            return new Point(640, 480);
        }
        ArrayList supportedPictureSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPictureSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        double screenAspectRatio = screenResolution.x > screenResolution.y ? (double)screenResolution.x / (double)screenResolution.y : (double)screenResolution.y / (double)screenResolution.x;
        Camera.Size selectedSize = null;
        double selectedMinus = -1.0;
        double selectedPreviewSize = 0.0;
        Iterator it = supportedPictureSizes.iterator();
        while (it.hasNext()) {
            Camera.Size supportedPreviewSize = (Camera.Size)it.next();
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            if (realWidth * realHeight < 307200) {
                it.remove();
                continue;
            }
            if (realWidth * realHeight > 2073600) {
                it.remove();
                continue;
            }
            if (realHeight > realWidth) {
                it.remove();
                continue;
            }
            if (realHeight % 2 != 0 || realWidth % 2 != 0) {
                it.remove();
                continue;
            }
            double aRatio = supportedPreviewSize.width > supportedPreviewSize.height ? (double)supportedPreviewSize.width / (double)supportedPreviewSize.height : (double)supportedPreviewSize.height / (double)supportedPreviewSize.width;
            double minus = Math.abs(aRatio - screenAspectRatio);
            boolean selectedFlag = false;
            if (selectedMinus == -1.0 && minus <= 0.25 || selectedMinus >= minus && minus <= 0.25) {
                selectedFlag = true;
            }
            if (!selectedFlag) continue;
            selectedMinus = minus;
            selectedSize = supportedPreviewSize;
            selectedPreviewSize = realWidth * realHeight;
        }
        if (selectedSize != null) {
            Camera.Size preview = selectedSize;
            return new Point(preview.width, preview.height);
        }
        return new Point(640, 480);
    }

    public static Point getBestVideoForSameSize(Camera.Parameters parameters) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        List videoSupportedSizes = parameters.getSupportedVideoSizes();
        ArrayList<Camera.Size> sameSizes = new ArrayList<Camera.Size>();
        if (videoSupportedSizes == null || rawSupportedSizes == null) {
            return new Point(640, 480);
        }
        videoSupportedSizes.addAll(rawSupportedSizes);
        HashMap<Camera.Size, Integer> mapList = new HashMap<Camera.Size, Integer>();
        for (Camera.Size size : videoSupportedSizes) {
            int count = 0;
            if (mapList.get(size) != null) {
                count = (Integer)mapList.get(size) + 1;
            }
            mapList.put(size, count);
        }
        for (Camera.Size key : mapList.keySet()) {
            if (mapList.get(key) == null || (Integer)mapList.get(key) <= 0) continue;
            sameSizes.add(key);
        }
        Collections.sort(sameSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return 1;
                }
                if (bPixels > aPixels) {
                    return -1;
                }
                return 0;
            }
        });
        Iterator it = sameSizes.iterator();
        while (it.hasNext()) {
            Camera.Size supportedPreviewSize = (Camera.Size)it.next();
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            if (realWidth * realHeight < 307200) {
                it.remove();
                continue;
            }
            if (realWidth * realHeight > 2073600) {
                it.remove();
                continue;
            }
            if (realHeight % 2 != 0 || realWidth % 2 != 0) {
                it.remove();
                continue;
            }
            return new Point(((Camera.Size)sameSizes.get((int)0)).width, ((Camera.Size)sameSizes.get((int)0)).height);
        }
        return new Point(640, 480);
    }

    public static Point getBestVideoPreview(Camera.Parameters parameters) {
        List rawSupportedSizes = parameters.getSupportedVideoSizes();
        if (rawSupportedSizes == null) {
            return new Point(640, 480);
        }
        ArrayList supportedPictureSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPictureSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < supportedPictureSizes.size(); ++i) {
            if (((Camera.Size)supportedPictureSizes.get((int)i)).width != 640 || ((Camera.Size)supportedPictureSizes.get((int)i)).height != 480) continue;
            return new Point(((Camera.Size)supportedPictureSizes.get((int)(supportedPictureSizes.size() - 4))).width, ((Camera.Size)supportedPictureSizes.get((int)(supportedPictureSizes.size() - 4))).height);
        }
        return new Point(640, 480);
    }
}

