/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AnimationDrawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.manager.TimeManager;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.BaseRecordActivity;
import com.baidu.idl.face.platform.ui.FaceSDKResSettings;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.BrightnessUtils;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.ui.utils.ViewUtils;
import com.baidu.idl.face.platform.ui.utils.VolumeUtils;
import com.baidu.idl.face.platform.ui.widget.FaceAuraColorView;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.entity.LivenessValueModel;
import com.baidu.liantian.ac.FaceProcessConfig;
import com.baidu.liantian.ac.LH;
import com.baidu.liantian.ac.RequestInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaceColorLivenessVideoActivity
extends BaseRecordActivity
implements VolumeUtils.VolumeCallback {
    public static final String TAG = FaceColorLivenessVideoActivity.class.getSimpleName();
    protected View mRootView;
    protected FrameLayout mFrameLayout;
    private TextureView mTextureView;
    protected ImageView mCloseView;
    protected ImageView mSoundView;
    protected ImageView mSuccessView;
    protected TextView mTipsTopView;
    protected FaceDetectRoundView mFaceDetectRoundView;
    protected LinearLayout mImageLayout;
    protected LinearLayout mImageLayout2;
    private RelativeLayout mRelativeAddImageView;
    private RelativeLayout mRelativeAddImageView2;
    private ImageView mImageAnim;
    private ImageView mImageFrame;
    protected FaceAuraColorView mFaceAuraColorView;
    protected int mDisplayWidth = 0;
    protected int mDisplayHeight = 0;
    protected FaceConfig mFaceConfig;
    protected volatile boolean mIsEnableSound = true;
    protected boolean mIsCompletion = false;
    protected BroadcastReceiver mVolumeReceiver;
    private Context mContext;
    private AnimationDrawable mAnimationDrawable;
    private LivenessTypeEnum mLivenessType = null;
    private boolean mInitSuccess;
    private List<LivenessTypeEnum> mActionLists;
    private int mRandromCount;
    private float mLiveScoreThreshold;
    private float mLiveScore;
    private HashMap<String, ImageInfo> mBase64ImageCropMap;
    private HashMap<String, ImageInfo> mBase64ImageSrcMap;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewUtils.changeTheme(this);
        this.setScreenBright();
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_face_color_v3100);
        this.mContext = this;
        IntentUtils.addDestroyActivity((Activity)this.mContext, "FaceColorLivenessVideoActivity");
        this.getIntentData();
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        FaceSDKResSettings.initializeResId();
        this.mFaceConfig = FaceSDKManager.getInstance().getFaceConfig();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        int vol = am.getStreamVolume(3);
        this.mIsEnableSound = vol > 0 ? FaceLiveManager.getInstance().getFaceConfig().isSound() : false;
        this.mRootView = this.findViewById(R.id.liveness_root_layout);
        this.mFaceDetectRoundView = (FaceDetectRoundView)this.mRootView.findViewById(R.id.liveness_face_round);
        this.mFaceDetectRoundView.setIsActiveLive(false);
        this.mFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.liveness_surface_layout);
        this.mTextureView = new TextureView((Context)this);
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                int w = FaceColorLivenessVideoActivity.this.mDisplayWidth;
                int h = FaceColorLivenessVideoActivity.this.mDisplayHeight;
                int textureViewWidth = (int)((float)w * 0.75f * 0.9f);
                int textureViewHeight = (int)((float)w * 0.75f * 0.9f * 640.0f / 480.0f);
                FrameLayout.LayoutParams cameraFL = new FrameLayout.LayoutParams(textureViewWidth, textureViewHeight, 49);
                cameraFL.setMargins(0, (int)(FaceColorLivenessVideoActivity.this.mFaceDetectRoundView.getCircleCenterY() - (float)(textureViewHeight / 2)), 0, 0);
                FaceColorLivenessVideoActivity.this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)cameraFL);
                FaceColorLivenessVideoActivity.this.mFrameLayout.addView((View)FaceColorLivenessVideoActivity.this.mTextureView);
            }
        });
        this.mRootView.findViewById(R.id.liveness_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceColorLivenessVideoActivity.this.onBackPressed();
            }
        });
        this.mFaceAuraColorView = (FaceAuraColorView)this.mRootView.findViewById(R.id.detect_aura);
        this.mCloseView = (ImageView)this.mRootView.findViewById(R.id.liveness_close);
        this.mSoundView = (ImageView)this.mRootView.findViewById(R.id.liveness_sound);
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
        this.mSoundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceColorLivenessVideoActivity.this.mIsEnableSound = !FaceColorLivenessVideoActivity.this.mIsEnableSound;
                FaceColorLivenessVideoActivity.this.mSoundView.setImageResource(FaceColorLivenessVideoActivity.this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)FaceColorLivenessVideoActivity.this.mIsEnableSound);
            }
        });
        this.mTipsTopView = (TextView)this.mRootView.findViewById(R.id.liveness_top_tips);
        this.mSuccessView = (ImageView)this.mRootView.findViewById(R.id.liveness_success_image);
        this.mImageLayout = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout);
        this.mImageLayout2 = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout2);
        this.mRelativeAddImageView = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view);
        this.mRelativeAddImageView2 = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view2);
        this.addImageView();
        this.mViewBg = this.findViewById(R.id.view_live_bg);
        this.initData();
    }

    private void getIntentData() {
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mInitSuccess = intent.getBooleanExtra("initSuccess", false);
        }
        LivenessValueModel livenessValueModel = FaceLiveManager.getInstance().getFaceConfig().getLivenessValueModel();
        this.mActionLists = livenessValueModel.actionList;
        this.mRandromCount = livenessValueModel.actionRandomNumber;
        this.mLiveScoreThreshold = livenessValueModel.livenessScore;
        FaceProcessConfig.setActionLists(this.mActionLists);
        FaceProcessConfig.setRandomCount((int)this.mRandromCount);
        FaceProcessConfig.setFrameExtraction((boolean)false);
    }

    private void initData() {
    }

    private void setScreenBright() {
        BrightnessUtils.setBrightness(this, 255);
    }

    private void addImageView() {
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                FaceColorLivenessVideoActivity.this.mImageAnim = new ImageView((Context)FaceColorLivenessVideoActivity.this);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.height = DensityUtils.dip2px((Context)FaceColorLivenessVideoActivity.this.mContext, (float)110.0f);
                layoutParams.width = DensityUtils.dip2px((Context)FaceColorLivenessVideoActivity.this.mContext, (float)87.0f);
                float halfHeight = FaceColorLivenessVideoActivity.this.mFaceDetectRoundView.getHeight() / 2;
                layoutParams.setMargins(0, (int)(halfHeight - halfHeight * 0.1f) - layoutParams.height / 2, 0, 0);
                layoutParams.addRule(14);
                FaceColorLivenessVideoActivity.this.mImageAnim.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FaceColorLivenessVideoActivity.this.mImageAnim.setScaleType(ImageView.ScaleType.FIT_XY);
                FaceColorLivenessVideoActivity.this.mRelativeAddImageView.addView((View)FaceColorLivenessVideoActivity.this.mImageAnim);
                FaceColorLivenessVideoActivity.this.mImageFrame = new ImageView(FaceColorLivenessVideoActivity.this.mContext);
                ViewUtils.addFrame(FaceColorLivenessVideoActivity.this.mRelativeAddImageView2, FaceColorLivenessVideoActivity.this.mImageFrame, FaceColorLivenessVideoActivity.this.mFaceDetectRoundView);
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mHasShownTimeoutDialog) {
            return;
        }
        if (!this.mInitSuccess && this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessVerifyFailedText));
            return;
        }
        this.deleteVideo();
        this.setVolumeControlStream(3);
        this.mVolumeReceiver = VolumeUtils.registerVolumeReceiver((Context)this, this);
        if (this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMovetoFrameText));
        }
        this.mTextureView.post(new Runnable(){

            @Override
            public void run() {
                FaceColorLivenessVideoActivity.this.startPreview(FaceColorLivenessVideoActivity.this.mTextureView, true);
            }
        });
    }

    protected void onRestart() {
        super.onRestart();
        if (this.mFaceAuraColorView.getVisibility() == 0) {
            this.mFaceAuraColorView.setVisibility(8);
        }
        this.updateOriIcon();
    }

    @Override
    public void onPause() {
        super.onPause();
        VolumeUtils.unRegisterVolumeReceiver((Context)this, this.mVolumeReceiver);
        this.mVolumeReceiver = null;
        this.mFaceDetectRoundView.setProcessCount(0, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
        this.mIsCompletion = false;
        this.stopPreview();
    }

    public void onStop() {
        super.onStop();
        this.mFaceAuraColorView.release();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        IntentUtils.removeDestroyActivity("FaceColorLivenessVideoActivity");
    }

    @Override
    public void volumeChanged() {
        try {
            AudioManager am = (AudioManager)this.getSystemService("audio");
            if (am != null) {
                int cv = am.getStreamVolume(3);
                this.mIsEnableSound = cv > 0;
                this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)this.mIsEnableSound);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onCollectCompletion(final FaceStatusNewEnum status, final String message, final HashMap<String, ImageInfo> base64ImageCropMap, final HashMap<String, ImageInfo> base64ImageSrcMap, final int currentLivenessCount) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaceColorLivenessVideoActivity.this.mIsCompletion) {
                    return;
                }
                LH.setSoundEnable((boolean)FaceColorLivenessVideoActivity.this.mIsEnableSound);
                FaceColorLivenessVideoActivity.this.onRefreshView(status, message, currentLivenessCount);
                if (status == FaceStatusNewEnum.OK) {
                    FaceColorLivenessVideoActivity.this.mIsCompletion = true;
                    FaceColorLivenessVideoActivity.this.mBase64ImageCropMap = base64ImageCropMap;
                    FaceColorLivenessVideoActivity.this.mBase64ImageSrcMap = base64ImageSrcMap;
                } else if (status == FaceStatusNewEnum.AuraColorError) {
                    FaceColorLivenessVideoActivity.this.mIsCompletion = true;
                }
            }
        });
    }

    @Override
    public void onEnd(final int status, final RequestInfo info, final String safeErrMsg) {
        super.onEnd(status, info, safeErrMsg);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LivenessResult livenessResult;
                if (status == 1) {
                    LivenessResult livenessResult2 = FaceColorLivenessVideoActivity.this.setLivenessResult(status, info, FaceColorLivenessVideoActivity.this.mBase64ImageCropMap, FaceColorLivenessVideoActivity.this.mBase64ImageSrcMap, safeErrMsg);
                    if (livenessResult2 != null) {
                        FaceColorLivenessVideoActivity.this.startSuccessActivity(FaceColorLivenessVideoActivity.this.mContext, FaceColorLivenessVideoActivity.this.mLiveScore, livenessResult2);
                    }
                } else if (status == -401) {
                    if (!FaceLiveManager.getInstance().getFaceConfig().isShowTimeoutDialog()) {
                        FaceColorLivenessVideoActivity.this.setDialogLivenessResult(status, info, safeErrMsg);
                        return;
                    }
                    if (FaceColorLivenessVideoActivity.this.mViewBg != null) {
                        FaceColorLivenessVideoActivity.this.mViewBg.setVisibility(0);
                    }
                    FaceColorLivenessVideoActivity.this.showMessageDialog();
                } else if (status == -402) {
                    LivenessResult livenessResult3 = FaceColorLivenessVideoActivity.this.setLivenessResult(status, info, null, null, safeErrMsg);
                    if (livenessResult3 != null) {
                        FaceColorLivenessVideoActivity.this.startFailureActivity(FaceColorLivenessVideoActivity.this.mContext, 0.0f, true, livenessResult3);
                    }
                } else if (status == -403 && (livenessResult = FaceColorLivenessVideoActivity.this.setLivenessResult(status, info, null, null, safeErrMsg)) != null) {
                    FaceColorLivenessVideoActivity.this.startFailureActivity(FaceColorLivenessVideoActivity.this.mContext, FaceColorLivenessVideoActivity.this.mLiveScore, false, livenessResult);
                }
            }
        });
    }

    private void onRefreshView(FaceStatusNewEnum status, String message, int currentLivenessCount) {
        switch (status) {
            case OK: 
            case FaceLivenessActionComplete: 
            case DetectRemindCodeTooClose: 
            case DetectRemindCodeTooFar: 
            case DetectRemindCodeBeyondPreviewFrame: 
            case DetectRemindCodeNoFaceDetected: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                if (this.mFaceAuraColorView.getVisibility() == 0) {
                    this.mFaceAuraColorView.setTipTopText(message);
                    this.mFaceAuraColorView.setTipSecondText("");
                }
                this.stopAnim();
                break;
            }
            case FaceLivenessActionTypeLiveEye: 
            case FaceLivenessActionTypeLiveMouth: 
            case FaceLivenessActionTypeLivePitchUp: 
            case FaceLivenessActionTypeLivePitchDown: 
            case FaceLivenessActionTypeLiveYawLeft: 
            case FaceLivenessActionTypeLiveYawRight: 
            case FaceLivenessActionTypeLiveYaw: 
            case FaceLivenessActionTypeLivePitch: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                break;
            }
            case DetectRemindCodePitchOutofUpRange: 
            case DetectRemindCodePitchOutofDownRange: 
            case DetectRemindCodeYawOutofLeftRange: 
            case DetectRemindCodeYawOutofRightRange: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                if (this.mFaceAuraColorView.getVisibility() != 0) break;
                this.mFaceAuraColorView.setTipTopText(this.getResources().getString(R.string.faceLivenessFacialFaceCorrectionText));
                this.mFaceAuraColorView.setTipSecondText(message);
                break;
            }
            case DetectRemindCodeFaceMoreThanOne: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMoreThanOneText));
                this.mFaceDetectRoundView.setTipSecondText("");
                break;
            }
            case FaceLivenessActionCodeTimeout: {
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                this.mFaceDetectRoundView.setIsShowShade(true);
                if (this.mRelativeAddImageView.getVisibility() == 4) {
                    this.mRelativeAddImageView.setVisibility(0);
                }
                this.loadAnimSource();
                int duration = 0;
                for (int i = 0; i < this.mAnimationDrawable.getNumberOfFrames(); ++i) {
                    duration += this.mAnimationDrawable.getDuration(i);
                }
                TimeManager.getInstance().setActiveAnimTime(duration);
                break;
            }
            case AuraStart: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                break;
            }
            case AuraColorChange: {
                this.mFaceDetectRoundView.setTipTopText(" ");
                if (this.mFaceAuraColorView.getVisibility() != 0) break;
                this.mFaceAuraColorView.setTipTopText(message);
                this.mFaceAuraColorView.setTipSecondText("");
                break;
            }
            case AuraColorError: {
                break;
            }
            default: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                if (this.mFaceAuraColorView.getVisibility() != 0) break;
                this.mFaceAuraColorView.setTipTopText(this.getResources().getString(R.string.faceLivenessFacialFaceCorrectionText));
                this.mFaceAuraColorView.setTipSecondText(message);
            }
        }
    }

    private void loadAnimSource() {
        if (this.mLivenessType != null) {
            switch (this.mLivenessType) {
                case Eye: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_eye);
                    break;
                }
                case HeadLeft: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_left);
                    break;
                }
                case HeadRight: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_right);
                    break;
                }
                case HeadDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_down);
                    break;
                }
                case HeadUp: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up);
                    break;
                }
                case Mouth: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_mouth);
                    break;
                }
                case HeadUpDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up_down);
                    break;
                }
                case HeadShake: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_shake);
                    break;
                }
            }
            this.mAnimationDrawable = (AnimationDrawable)this.mImageAnim.getBackground();
            this.mAnimationDrawable.start();
        }
    }

    private static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64Utils.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    @Override
    public void setCurrentLiveType(LivenessTypeEnum liveType) {
        this.mLivenessType = liveType;
    }

    @Override
    public void viewReset() {
        this.mFaceDetectRoundView.setProcessCount(0, 1);
    }

    @Override
    public void animStop() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FaceColorLivenessVideoActivity.this.stopAnim();
            }
        });
    }

    @Override
    public void setFaceInfo(FaceExtInfo faceInfo) {
    }

    @Override
    public void setLiveScore(float liveScore) {
        this.mLiveScore = liveScore;
    }

    @Override
    public void setBackgroundColor(final int currentColor, final int preColor) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaceColorLivenessVideoActivity.this.mFaceAuraColorView == null) {
                    return;
                }
                int preBag = -1;
                if (preColor == 0) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_red);
                } else if (preColor == 1) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_green);
                } else if (preColor == 2) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_blue);
                } else if (preColor == 3) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_yellow);
                } else if (preColor == 4) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_cyan);
                } else if (preColor == 5) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_purple);
                } else if (preColor == 6) {
                    preBag = FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_default);
                }
                switch (currentColor) {
                    case -1: {
                        FaceColorLivenessVideoActivity.this.updateOriIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(8);
                        break;
                    }
                    case 0: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_red));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 1: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_green));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 2: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_blue));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 3: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_yellow));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 4: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_cyan));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 5: {
                        FaceColorLivenessVideoActivity.this.updateAuraIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_purple));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 6: {
                        FaceColorLivenessVideoActivity.this.updateOriIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(true, FaceColorLivenessVideoActivity.this.getResources().getColor(R.color.aura_default));
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    case 7: {
                        FaceColorLivenessVideoActivity.this.updateOriIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.start(false, 0);
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setColorBg(preBag);
                        break;
                    }
                    default: {
                        FaceColorLivenessVideoActivity.this.updateOriIcon();
                        FaceColorLivenessVideoActivity.this.mFaceAuraColorView.setVisibility(8);
                    }
                }
            }
        });
    }

    private void updateAuraIcon() {
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2_white : R.mipmap.icon_titlebar_voice_close_white);
        this.mCloseView.setImageResource(R.mipmap.icon_titlebar_close_white);
        this.mFaceAuraColorView.updateTextColor(true);
    }

    private void updateOriIcon() {
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
        this.mCloseView.setImageResource(R.mipmap.icon_titlebar_close);
        this.mFaceAuraColorView.updateTextColor(false);
    }

    private void stopAnim() {
        this.mFaceDetectRoundView.setIsShowShade(false);
        if (this.mAnimationDrawable != null) {
            this.mAnimationDrawable.stop();
            this.mAnimationDrawable = null;
        }
        if (this.mRelativeAddImageView.getVisibility() == 0) {
            this.mRelativeAddImageView.setVisibility(4);
        }
    }

    private void saveAllImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.setImageView1(list1);
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.setImageView2(list2);
        }
    }

    private void setImageView1(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceColorLivenessVideoActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }

    private void setImageView2(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout2.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceColorLivenessVideoActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout2.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }
}

