/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.AnimationDrawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.manager.TimeManager;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.BaseRecordActivity;
import com.baidu.idl.face.platform.ui.FaceSDKResSettings;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.BrightnessUtils;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.ui.utils.ViewUtils;
import com.baidu.idl.face.platform.ui.utils.VolumeUtils;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.entity.LivenessValueModel;
import com.baidu.liantian.ac.FaceProcessConfig;
import com.baidu.liantian.ac.LH;
import com.baidu.liantian.ac.RequestInfo;
import java.util.HashMap;
import java.util.List;

public class FaceActionLivenessVideoActivity
extends BaseRecordActivity
implements VolumeUtils.VolumeCallback {
    private static final String TAG = FaceActionLivenessVideoActivity.class.getName();
    protected View mRootView;
    protected FrameLayout mFrameLayout;
    private TextureView mTextureView;
    protected ImageView mCloseView;
    protected ImageView mSoundView;
    protected ImageView mSuccessView;
    protected TextView mTipsTopView;
    protected FaceDetectRoundView mFaceDetectRoundView;
    protected LinearLayout mImageLayout;
    protected LinearLayout mImageLayout2;
    private RelativeLayout mRelativeAddImageView;
    private RelativeLayout mRelativeAddImageView2;
    private ImageView mImageAnim;
    private ImageView mImageFrame;
    protected FaceConfig mFaceConfig;
    protected int mDisplayWidth = 0;
    protected int mDisplayHeight = 0;
    protected volatile boolean mIsEnableSound = true;
    protected boolean mIsCompletion = false;
    protected BroadcastReceiver mVolumeReceiver;
    private Context mContext;
    private AnimationDrawable mAnimationDrawable;
    private LivenessTypeEnum mLivenessType = null;
    private List<LivenessTypeEnum> mActionLists;
    private boolean mInitSuccess;
    private int mRandromCount;
    private float mLiveScoreThreshold;
    private float mLiveScore;
    private HashMap<String, ImageInfo> mBase64ImageCropMap;
    private HashMap<String, ImageInfo> mBase64ImageSrcMap;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewUtils.changeTheme(this);
        this.setScreenBright();
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_face_action_v3100);
        this.mContext = this;
        IntentUtils.addDestroyActivity((Activity)this.mContext, "FaceActionLivenessVideoActivity");
        this.getIntentData();
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        FaceSDKResSettings.initializeResId();
        this.mFaceConfig = FaceSDKManager.getInstance().getFaceConfig();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        int vol = am.getStreamVolume(3);
        this.mIsEnableSound = vol > 0 ? FaceLiveManager.getInstance().getFaceConfig().isSound() : false;
        this.mRootView = this.findViewById(R.id.liveness_root_layout);
        this.mFaceDetectRoundView = (FaceDetectRoundView)this.mRootView.findViewById(R.id.liveness_face_round);
        this.mFaceDetectRoundView.setIsActiveLive(true);
        this.mFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.liveness_surface_layout);
        this.mTextureView = new TextureView((Context)this);
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                int w = FaceActionLivenessVideoActivity.this.mDisplayWidth;
                int h = FaceActionLivenessVideoActivity.this.mDisplayHeight;
                int textureViewWidth = (int)((float)w * 0.75f * 0.9f);
                int textureViewHeight = (int)((float)w * 0.75f * 0.9f * 640.0f / 480.0f);
                FrameLayout.LayoutParams cameraFL = new FrameLayout.LayoutParams(textureViewWidth, textureViewHeight, 49);
                cameraFL.setMargins(0, (int)(FaceActionLivenessVideoActivity.this.mFaceDetectRoundView.getCircleCenterY() - (float)(textureViewHeight / 2)), 0, 0);
                FaceActionLivenessVideoActivity.this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)cameraFL);
                FaceActionLivenessVideoActivity.this.mFrameLayout.addView((View)FaceActionLivenessVideoActivity.this.mTextureView);
            }
        });
        this.mRootView.findViewById(R.id.liveness_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceActionLivenessVideoActivity.this.onBackPressed();
            }
        });
        this.mCloseView = (ImageView)this.mRootView.findViewById(R.id.liveness_close);
        this.mSoundView = (ImageView)this.mRootView.findViewById(R.id.liveness_sound);
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
        this.mSoundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceActionLivenessVideoActivity.this.mIsEnableSound = !FaceActionLivenessVideoActivity.this.mIsEnableSound;
                FaceActionLivenessVideoActivity.this.mSoundView.setImageResource(FaceActionLivenessVideoActivity.this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)FaceActionLivenessVideoActivity.this.mIsEnableSound);
            }
        });
        this.mTipsTopView = (TextView)this.mRootView.findViewById(R.id.liveness_top_tips);
        this.mSuccessView = (ImageView)this.mRootView.findViewById(R.id.liveness_success_image);
        this.mImageLayout = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout);
        this.mImageLayout2 = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout2);
        this.mRelativeAddImageView = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view);
        this.mRelativeAddImageView2 = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view2);
        this.addImageView();
        this.mViewBg = this.findViewById(R.id.view_live_bg);
        this.initData();
    }

    private void getIntentData() {
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mInitSuccess = intent.getBooleanExtra("initSuccess", false);
        }
        LivenessValueModel livenessValueModel = FaceLiveManager.getInstance().getFaceConfig().getLivenessValueModel();
        this.mActionLists = livenessValueModel.actionList;
        this.mRandromCount = livenessValueModel.actionRandomNumber;
        this.mLiveScoreThreshold = livenessValueModel.livenessScore;
        FaceProcessConfig.setActionLists(this.mActionLists);
        FaceProcessConfig.setRandomCount((int)this.mRandromCount);
        FaceProcessConfig.setFrameExtraction((boolean)false);
    }

    private void initData() {
    }

    private void setScreenBright() {
        BrightnessUtils.setBrightness(this, 255);
    }

    private void addImageView() {
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                FaceActionLivenessVideoActivity.this.mImageAnim = new ImageView(FaceActionLivenessVideoActivity.this.mContext);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.height = DensityUtils.dip2px((Context)FaceActionLivenessVideoActivity.this.mContext, (float)110.0f);
                layoutParams.width = DensityUtils.dip2px((Context)FaceActionLivenessVideoActivity.this.mContext, (float)87.0f);
                float halfHeight = FaceActionLivenessVideoActivity.this.mFaceDetectRoundView.getHeight() / 2;
                layoutParams.setMargins(0, (int)(halfHeight - halfHeight * 0.1f) - layoutParams.height / 2, 0, 0);
                layoutParams.addRule(14);
                FaceActionLivenessVideoActivity.this.mImageAnim.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FaceActionLivenessVideoActivity.this.mImageAnim.setScaleType(ImageView.ScaleType.FIT_XY);
                FaceActionLivenessVideoActivity.this.mRelativeAddImageView.addView((View)FaceActionLivenessVideoActivity.this.mImageAnim);
                FaceActionLivenessVideoActivity.this.mImageFrame = new ImageView(FaceActionLivenessVideoActivity.this.mContext);
                ViewUtils.addFrame(FaceActionLivenessVideoActivity.this.mRelativeAddImageView2, FaceActionLivenessVideoActivity.this.mImageFrame, FaceActionLivenessVideoActivity.this.mFaceDetectRoundView);
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mHasShownTimeoutDialog) {
            return;
        }
        if (!this.mInitSuccess && this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessVerifyFailedText));
            return;
        }
        this.deleteVideo();
        this.setVolumeControlStream(3);
        this.mVolumeReceiver = VolumeUtils.registerVolumeReceiver((Context)this, this);
        if (this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMovetoFrameText));
        }
        this.mTextureView.post(new Runnable(){

            @Override
            public void run() {
                FaceActionLivenessVideoActivity.this.startPreview(FaceActionLivenessVideoActivity.this.mTextureView, true);
            }
        });
    }

    protected void onRestart() {
        super.onRestart();
    }

    @Override
    public void onPause() {
        super.onPause();
        VolumeUtils.unRegisterVolumeReceiver((Context)this, this.mVolumeReceiver);
        this.mVolumeReceiver = null;
        this.mFaceDetectRoundView.setProcessCount(0, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
        this.mIsCompletion = false;
        this.stopPreview();
    }

    public void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        IntentUtils.removeDestroyActivity("FaceActionLivenessVideoActivity");
    }

    @Override
    public void volumeChanged() {
        try {
            AudioManager am = (AudioManager)this.getSystemService("audio");
            if (am != null) {
                int cv = am.getStreamVolume(3);
                this.mIsEnableSound = cv > 0;
                this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)this.mIsEnableSound);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onCollectCompletion(final FaceStatusNewEnum status, final String message, final HashMap<String, ImageInfo> base64ImageCropMap, final HashMap<String, ImageInfo> base64ImageSrcMap, final int currentLivenessCount) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaceActionLivenessVideoActivity.this.mIsCompletion) {
                    return;
                }
                LH.setSoundEnable((boolean)FaceActionLivenessVideoActivity.this.mIsEnableSound);
                FaceActionLivenessVideoActivity.this.onRefreshView(status, message, currentLivenessCount);
                if (status == FaceStatusNewEnum.OK) {
                    FaceActionLivenessVideoActivity.this.mIsCompletion = true;
                    FaceActionLivenessVideoActivity.this.mBase64ImageCropMap = base64ImageCropMap;
                    FaceActionLivenessVideoActivity.this.mBase64ImageSrcMap = base64ImageSrcMap;
                }
            }
        });
    }

    @Override
    public void onEnd(final int status, final RequestInfo info, final String safeErrMsg) {
        super.onEnd(status, info, safeErrMsg);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LivenessResult livenessResult;
                if (status == 1) {
                    LivenessResult livenessResult2 = FaceActionLivenessVideoActivity.this.setLivenessResult(status, info, FaceActionLivenessVideoActivity.this.mBase64ImageCropMap, FaceActionLivenessVideoActivity.this.mBase64ImageSrcMap, safeErrMsg);
                    if (livenessResult2 != null) {
                        FaceActionLivenessVideoActivity.this.startSuccessActivity(FaceActionLivenessVideoActivity.this.mContext, FaceActionLivenessVideoActivity.this.mLiveScore, livenessResult2);
                    }
                } else if (status == -401) {
                    if (!FaceLiveManager.getInstance().getFaceConfig().isShowTimeoutDialog()) {
                        FaceActionLivenessVideoActivity.this.setDialogLivenessResult(status, info, safeErrMsg);
                        return;
                    }
                    if (FaceActionLivenessVideoActivity.this.mViewBg != null) {
                        FaceActionLivenessVideoActivity.this.mViewBg.setVisibility(0);
                    }
                    FaceActionLivenessVideoActivity.this.showMessageDialog();
                } else if (status == -404 && (livenessResult = FaceActionLivenessVideoActivity.this.setLivenessResult(status, info, FaceActionLivenessVideoActivity.this.mBase64ImageCropMap, FaceActionLivenessVideoActivity.this.mBase64ImageSrcMap, safeErrMsg)) != null) {
                    FaceActionLivenessVideoActivity.this.startFailureActivity(FaceActionLivenessVideoActivity.this.mContext, FaceActionLivenessVideoActivity.this.mLiveScore, false, livenessResult);
                }
            }
        });
    }

    private void onRefreshView(FaceStatusNewEnum status, String message, int currentLivenessCount) {
        switch (status) {
            case OK: 
            case FaceLivenessActionComplete: 
            case DetectRemindCodeTooClose: 
            case DetectRemindCodeTooFar: 
            case DetectRemindCodeBeyondPreviewFrame: 
            case DetectRemindCodeNoFaceDetected: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                this.stopAnim();
                break;
            }
            case FaceLivenessActionTypeLiveEye: 
            case FaceLivenessActionTypeLiveMouth: 
            case FaceLivenessActionTypeLivePitchUp: 
            case FaceLivenessActionTypeLivePitchDown: 
            case FaceLivenessActionTypeLiveYawLeft: 
            case FaceLivenessActionTypeLiveYawRight: 
            case FaceLivenessActionTypeLiveYaw: 
            case FaceLivenessActionTypeLivePitch: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                break;
            }
            case DetectRemindCodePitchOutofUpRange: 
            case DetectRemindCodePitchOutofDownRange: 
            case DetectRemindCodeYawOutofLeftRange: 
            case DetectRemindCodeYawOutofRightRange: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                break;
            }
            case DetectRemindCodeFaceMoreThanOne: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMoreThanOneText));
                this.mFaceDetectRoundView.setTipSecondText("");
                break;
            }
            case FaceLivenessActionCodeTimeout: {
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                this.mFaceDetectRoundView.setIsShowShade(true);
                if (this.mRelativeAddImageView.getVisibility() == 4) {
                    this.mRelativeAddImageView.setVisibility(0);
                }
                this.loadAnimSource();
                int duration = 0;
                for (int i = 0; i < this.mAnimationDrawable.getNumberOfFrames(); ++i) {
                    duration += this.mAnimationDrawable.getDuration(i);
                }
                TimeManager.getInstance().setActiveAnimTime(duration);
                break;
            }
            default: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
            }
        }
    }

    private void loadAnimSource() {
        if (this.mLivenessType != null) {
            switch (this.mLivenessType) {
                case Eye: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_eye);
                    break;
                }
                case HeadLeft: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_left);
                    break;
                }
                case HeadRight: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_right);
                    break;
                }
                case HeadDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_down);
                    break;
                }
                case HeadUp: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up);
                    break;
                }
                case Mouth: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_mouth);
                    break;
                }
                case HeadUpDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up_down);
                    break;
                }
                case HeadShake: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_shake);
                    break;
                }
            }
            this.mAnimationDrawable = (AnimationDrawable)this.mImageAnim.getBackground();
            this.mAnimationDrawable.start();
        }
    }

    @Override
    public void setCurrentLiveType(LivenessTypeEnum liveType) {
        this.mLivenessType = liveType;
    }

    @Override
    public void viewReset() {
        this.mFaceDetectRoundView.setProcessCount(0, 1);
    }

    @Override
    public void animStop() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FaceActionLivenessVideoActivity.this.stopAnim();
            }
        });
    }

    @Override
    public void setFaceInfo(FaceExtInfo faceInfo) {
    }

    @Override
    public void setLiveScore(float liveScore) {
        this.mLiveScore = liveScore;
    }

    @Override
    public void setBackgroundColor(int currentColor, int preColor) {
    }

    private void stopAnim() {
        this.mFaceDetectRoundView.setIsShowShade(false);
        if (this.mAnimationDrawable != null) {
            this.mAnimationDrawable.stop();
            this.mAnimationDrawable = null;
        }
        if (this.mRelativeAddImageView.getVisibility() == 0) {
            this.mRelativeAddImageView.setVisibility(4);
        }
    }
}

