/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AnimationDrawable;
import android.media.AudioManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.baidu.idl.face.platform.FaceConfig;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.manager.TimeManager;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.BaseCameraActivity;
import com.baidu.idl.face.platform.ui.FaceSDKResSettings;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.BrightnessUtils;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.ui.utils.ViewUtils;
import com.baidu.idl.face.platform.ui.utils.VolumeUtils;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.entity.LivenessValueModel;
import com.baidu.liantian.ac.FaceProcessConfig;
import com.baidu.liantian.ac.LH;
import com.baidu.liantian.ac.RequestInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FaceActionLivenessActivity
extends BaseCameraActivity
implements VolumeUtils.VolumeCallback {
    public static final String TAG = FaceActionLivenessActivity.class.getSimpleName();
    protected View mRootView;
    protected FrameLayout mFrameLayout;
    protected SurfaceHolder mSurfaceHolder;
    protected ImageView mCloseView;
    protected ImageView mSoundView;
    protected ImageView mSuccessView;
    protected TextView mTipsTopView;
    protected FaceDetectRoundView mFaceDetectRoundView;
    protected LinearLayout mImageLayout;
    protected LinearLayout mImageLayout2;
    private RelativeLayout mRelativeAddImageView;
    private RelativeLayout mRelativeAddImageView2;
    private ImageView mImageAnim;
    private ImageView mImageFrame;
    protected FaceConfig mFaceConfig;
    protected int mDisplayWidth = 0;
    protected int mDisplayHeight = 0;
    protected volatile boolean mIsEnableSound = true;
    protected boolean mIsCompletion = false;
    protected BroadcastReceiver mVolumeReceiver;
    private Context mContext;
    private AnimationDrawable mAnimationDrawable;
    private LivenessTypeEnum mLivenessType = null;
    private boolean mFrameExtraction;
    private boolean mInitSuccess;
    private List<LivenessTypeEnum> mActionLists;
    private int mRandromCount;
    private float mLiveScoreThreshold;
    private float mLiveScore;
    private HashMap<String, ImageInfo> mBase64ImageCropMap;
    private HashMap<String, ImageInfo> mBase64ImageSrcMap;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewUtils.changeTheme(this);
        this.setScreenBright();
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_face_action_v3100);
        this.mContext = this;
        IntentUtils.addDestroyActivity((Activity)this.mContext, "FaceActionLivenessActivity");
        this.getIntentData();
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        this.mDisplayWidth = dm.widthPixels;
        this.mDisplayHeight = dm.heightPixels;
        FaceSDKResSettings.initializeResId();
        this.mFaceConfig = FaceSDKManager.getInstance().getFaceConfig();
        AudioManager am = (AudioManager)this.getSystemService("audio");
        int vol = am.getStreamVolume(3);
        this.mIsEnableSound = vol > 0 ? FaceLiveManager.getInstance().getFaceConfig().isSound() : false;
        this.mRootView = this.findViewById(R.id.liveness_root_layout);
        this.mFaceDetectRoundView = (FaceDetectRoundView)this.mRootView.findViewById(R.id.liveness_face_round);
        this.mFaceDetectRoundView.setIsActiveLive(true);
        this.mFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.liveness_surface_layout);
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.setSizeFromLayout();
        this.mSurfaceHolder.setType(3);
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                int w = FaceActionLivenessActivity.this.mDisplayWidth;
                int h = FaceActionLivenessActivity.this.mDisplayHeight;
                int surfaceViewWidth = (int)((float)w * 0.75f * 0.9f);
                int surfaceViewHeight = (int)((float)w * 0.75f * 0.9f * 640.0f / 480.0f);
                FrameLayout.LayoutParams cameraFL = new FrameLayout.LayoutParams(surfaceViewWidth, surfaceViewHeight, 49);
                cameraFL.setMargins(0, (int)(FaceActionLivenessActivity.this.mFaceDetectRoundView.getCircleCenterY() - (float)(surfaceViewHeight / 2)), 0, 0);
                FaceActionLivenessActivity.this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)cameraFL);
                FaceActionLivenessActivity.this.mFrameLayout.addView((View)FaceActionLivenessActivity.this.mSurfaceView);
            }
        });
        this.mRootView.findViewById(R.id.liveness_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceActionLivenessActivity.this.onBackPressed();
            }
        });
        this.mCloseView = (ImageView)this.mRootView.findViewById(R.id.liveness_close);
        this.mSoundView = (ImageView)this.mRootView.findViewById(R.id.liveness_sound);
        this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
        this.mSoundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceActionLivenessActivity.this.mIsEnableSound = !FaceActionLivenessActivity.this.mIsEnableSound;
                FaceActionLivenessActivity.this.mSoundView.setImageResource(FaceActionLivenessActivity.this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)FaceActionLivenessActivity.this.mIsEnableSound);
            }
        });
        this.mTipsTopView = (TextView)this.mRootView.findViewById(R.id.liveness_top_tips);
        this.mSuccessView = (ImageView)this.mRootView.findViewById(R.id.liveness_success_image);
        this.mImageLayout = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout);
        this.mImageLayout2 = (LinearLayout)this.mRootView.findViewById(R.id.liveness_result_image_layout2);
        this.mRelativeAddImageView = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view);
        this.mRelativeAddImageView2 = (RelativeLayout)this.mRootView.findViewById(R.id.relative_add_image_view2);
        this.addImageView();
        this.mViewBg = this.findViewById(R.id.view_live_bg);
    }

    private void getIntentData() {
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mFrameExtraction = intent.getBooleanExtra("frameExtraction", false);
            this.mInitSuccess = intent.getBooleanExtra("initSuccess", false);
        }
        LivenessValueModel livenessValueModel = FaceLiveManager.getInstance().getFaceConfig().getLivenessValueModel();
        this.mActionLists = livenessValueModel.actionList;
        this.mRandromCount = livenessValueModel.actionRandomNumber;
        this.mLiveScoreThreshold = livenessValueModel.livenessScore;
        FaceProcessConfig.setActionLists(this.mActionLists);
        FaceProcessConfig.setRandomCount((int)this.mRandromCount);
        FaceProcessConfig.setFrameExtraction((boolean)this.mFrameExtraction);
    }

    private void setScreenBright() {
        int currentBright = BrightnessUtils.getScreenBrightness(this);
        BrightnessUtils.setBrightness(this, currentBright + 100);
    }

    private void addImageView() {
        this.mFaceDetectRoundView.post(new Runnable(){

            @Override
            public void run() {
                FaceActionLivenessActivity.this.mImageAnim = new ImageView(FaceActionLivenessActivity.this.mContext);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.height = DensityUtils.dip2px((Context)FaceActionLivenessActivity.this.mContext, (float)110.0f);
                layoutParams.width = DensityUtils.dip2px((Context)FaceActionLivenessActivity.this.mContext, (float)87.0f);
                float halfHeight = FaceActionLivenessActivity.this.mFaceDetectRoundView.getHeight() / 2;
                layoutParams.setMargins(0, (int)(halfHeight - halfHeight * 0.1f) - layoutParams.height / 2, 0, 0);
                layoutParams.addRule(14);
                FaceActionLivenessActivity.this.mImageAnim.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FaceActionLivenessActivity.this.mImageAnim.setScaleType(ImageView.ScaleType.FIT_XY);
                FaceActionLivenessActivity.this.mRelativeAddImageView.addView((View)FaceActionLivenessActivity.this.mImageAnim);
                FaceActionLivenessActivity.this.mImageFrame = new ImageView(FaceActionLivenessActivity.this.mContext);
                ViewUtils.addFrame(FaceActionLivenessActivity.this.mRelativeAddImageView2, FaceActionLivenessActivity.this.mImageFrame, FaceActionLivenessActivity.this.mFaceDetectRoundView);
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mHasShownTimeoutDialog) {
            return;
        }
        if (!this.mInitSuccess && this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessVerifyFailedText));
            return;
        }
        this.setVolumeControlStream(3);
        this.mVolumeReceiver = VolumeUtils.registerVolumeReceiver((Context)this, this);
        if (this.mFaceDetectRoundView != null) {
            this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMovetoFrameText));
        }
        this.startPreview(this.mSurfaceHolder);
    }

    @Override
    public void onPause() {
        VolumeUtils.unRegisterVolumeReceiver((Context)this, this.mVolumeReceiver);
        this.mVolumeReceiver = null;
        this.mFaceDetectRoundView.setProcessCount(0, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
        super.onPause();
        this.stopPreview();
        this.mIsCompletion = false;
    }

    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        IntentUtils.removeDestroyActivity("FaceActionLivenessActivity");
    }

    @Override
    public void volumeChanged() {
        try {
            AudioManager am = (AudioManager)this.getSystemService("audio");
            if (am != null) {
                int cv = am.getStreamVolume(3);
                this.mIsEnableSound = cv > 0;
                this.mSoundView.setImageResource(this.mIsEnableSound ? R.mipmap.icon_titlebar_voice2 : R.mipmap.icon_titlebar_voice_close);
                LH.setSoundEnable((boolean)this.mIsEnableSound);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onCollectCompletion(FaceStatusNewEnum status, String message, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap, int currentLivenessCount) {
        if (this.mIsCompletion) {
            return;
        }
        LH.setSoundEnable((boolean)this.mIsEnableSound);
        this.onRefreshView(status, message, currentLivenessCount);
        if (status == FaceStatusNewEnum.OK) {
            this.mIsCompletion = true;
            this.mBase64ImageCropMap = base64ImageCropMap;
            this.mBase64ImageSrcMap = base64ImageSrcMap;
        }
    }

    @Override
    public void onEnd(int status, RequestInfo info, String safeErrMsg) {
        LivenessResult livenessResult;
        super.onEnd(status, info, safeErrMsg);
        if (status == 1) {
            LivenessResult livenessResult2 = this.setLivenessResult(status, info, this.mBase64ImageCropMap, this.mBase64ImageSrcMap, safeErrMsg);
            if (livenessResult2 != null) {
                this.startSuccessActivity(this.mContext, this.mLiveScore, livenessResult2);
            }
        } else if (status == -401) {
            if (!FaceLiveManager.getInstance().getFaceConfig().isShowTimeoutDialog()) {
                this.setDialogLivenessResult(status, info, safeErrMsg);
                return;
            }
            if (this.mViewBg != null) {
                this.mViewBg.setVisibility(0);
            }
            this.showMessageDialog();
        } else if (status == -404 && (livenessResult = this.setLivenessResult(status, info, this.mBase64ImageCropMap, this.mBase64ImageSrcMap, safeErrMsg)) != null) {
            this.startFailureActivity(this.mContext, this.mLiveScore, false, livenessResult);
        }
    }

    private void onRefreshView(FaceStatusNewEnum status, String message, int currentLivenessCount) {
        switch (status) {
            case OK: 
            case FaceLivenessActionComplete: 
            case DetectRemindCodeTooClose: 
            case DetectRemindCodeTooFar: 
            case DetectRemindCodeBeyondPreviewFrame: 
            case DetectRemindCodeNoFaceDetected: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                this.stopAnim();
                break;
            }
            case FaceLivenessActionTypeLiveEye: 
            case FaceLivenessActionTypeLiveMouth: 
            case FaceLivenessActionTypeLivePitchUp: 
            case FaceLivenessActionTypeLivePitchDown: 
            case FaceLivenessActionTypeLiveYawLeft: 
            case FaceLivenessActionTypeLiveYawRight: 
            case FaceLivenessActionTypeLiveYaw: 
            case FaceLivenessActionTypeLivePitch: {
                this.mFaceDetectRoundView.setTipTopText(message);
                this.mFaceDetectRoundView.setTipSecondText("");
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                break;
            }
            case DetectRemindCodePitchOutofUpRange: 
            case DetectRemindCodePitchOutofDownRange: 
            case DetectRemindCodeYawOutofLeftRange: 
            case DetectRemindCodeYawOutofRightRange: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                break;
            }
            case DetectRemindCodeFaceMoreThanOne: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessMoreThanOneText));
                this.mFaceDetectRoundView.setTipSecondText("");
                break;
            }
            case FaceLivenessActionCodeTimeout: {
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
                this.mFaceDetectRoundView.setIsShowShade(true);
                if (this.mRelativeAddImageView.getVisibility() == 4) {
                    this.mRelativeAddImageView.setVisibility(0);
                }
                this.loadAnimSource();
                int duration = 0;
                for (int i = 0; i < this.mAnimationDrawable.getNumberOfFrames(); ++i) {
                    duration += this.mAnimationDrawable.getDuration(i);
                }
                TimeManager.getInstance().setActiveAnimTime(duration);
                break;
            }
            default: {
                this.mFaceDetectRoundView.setTipTopText(this.getResources().getString(R.string.faceLivenessKeepFacePositiveText));
                this.mFaceDetectRoundView.setTipSecondText(message);
                this.mFaceDetectRoundView.setProcessCount(currentLivenessCount, this.mFaceConfig.getLivenessTypeList(this.mActionLists, this.mRandromCount).size());
            }
        }
    }

    private void loadAnimSource() {
        if (this.mLivenessType != null) {
            switch (this.mLivenessType) {
                case Eye: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_eye);
                    break;
                }
                case HeadLeft: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_left);
                    break;
                }
                case HeadRight: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_right);
                    break;
                }
                case HeadDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_down);
                    break;
                }
                case HeadUp: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up);
                    break;
                }
                case Mouth: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_mouth);
                    break;
                }
                case HeadUpDown: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_up_down);
                    break;
                }
                case HeadShake: {
                    this.mImageAnim.setBackgroundResource(R.drawable.anim_shake);
                    break;
                }
            }
            this.mAnimationDrawable = (AnimationDrawable)this.mImageAnim.getBackground();
            this.mAnimationDrawable.start();
        }
    }

    private static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64Utils.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    @Override
    public void setCurrentLiveType(LivenessTypeEnum liveType) {
        this.mLivenessType = liveType;
    }

    @Override
    public void viewReset() {
        this.mFaceDetectRoundView.setProcessCount(0, 1);
    }

    @Override
    public void animStop() {
        this.stopAnim();
    }

    @Override
    public void setFaceInfo(FaceExtInfo faceInfo) {
    }

    @Override
    public void setLiveScore(float liveScore) {
        this.mLiveScore = liveScore;
    }

    @Override
    public void setBackgroundColor(int currentColor, int preColor) {
    }

    private void stopAnim() {
        this.mFaceDetectRoundView.setIsShowShade(false);
        if (this.mAnimationDrawable != null) {
            this.mAnimationDrawable.stop();
            this.mAnimationDrawable = null;
        }
        if (this.mRelativeAddImageView.getVisibility() == 0) {
            this.mRelativeAddImageView.setVisibility(4);
        }
    }

    private void saveAllImage(HashMap<String, ImageInfo> imageCropMap, HashMap<String, ImageInfo> imageSrcMap) {
        if (imageCropMap != null && imageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list1 = new ArrayList<Map.Entry<String, ImageInfo>>(imageCropMap.entrySet());
            Collections.sort(list1, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.setImageView1(list1);
        }
        if (imageSrcMap != null && imageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> list2 = new ArrayList<Map.Entry<String, ImageInfo>>(imageSrcMap.entrySet());
            Collections.sort(list2, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
            this.setImageView2(list2);
        }
    }

    private void setImageView1(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceActionLivenessActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }

    private void setImageView2(List<Map.Entry<String, ImageInfo>> list) {
        Bitmap bmp = null;
        this.mImageLayout2.removeAllViews();
        for (Map.Entry<String, ImageInfo> entry : list) {
            bmp = FaceActionLivenessActivity.base64ToBitmap(entry.getValue().getBase64());
            ImageView iv = new ImageView((Context)this);
            iv.setImageBitmap(bmp);
            this.mImageLayout2.addView((View)iv, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(300, 300));
        }
    }
}

