/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.baidu.idl.face.platform.ui.BaseUIActivity;
import com.baidu.idl.face.platform.ui.R;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.ui.utils.ViewUtils;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.manager.FaceCallbackManager;

public class CollectFailureActivity
extends BaseUIActivity {
    private static final String TAG = CollectFailureActivity.class.getSimpleName();
    private TextView mTextErrMessage;
    private TextView mTextErrTips;
    private TextView mTextScore;
    private LivenessResult mLivenessResult;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewUtils.changeTheme(this);
        this.setContentView(R.layout.activity_collect_failure);
        this.initView();
        this.initData();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mLivenessResult != null) {
            this.mLivenessResult = null;
        }
    }

    private void initView() {
        this.mTextErrMessage = (TextView)this.findViewById(R.id.text_err_message);
        this.mTextErrTips = (TextView)this.findViewById(R.id.text_err_tips);
        this.mTextScore = (TextView)this.findViewById(R.id.text_score);
    }

    private void initData() {
        Intent intent = this.getIntent();
        if (intent != null) {
            float livenessScore = intent.getFloatExtra("livenessScore", 0.0f);
            boolean isColorError = intent.getBooleanExtra("isColorError", false);
            this.mLivenessResult = IntentUtils.getInstance().getLivenessResult();
            this.judgeError(livenessScore, isColorError);
        }
    }

    private void judgeError(float livenessScore, boolean isColorError) {
        if (isColorError) {
            this.mTextErrMessage.setText(R.string.collect_failure);
            this.mTextErrTips.setText(R.string.collect_tips_1);
        } else {
            this.mTextErrMessage.setText(R.string.collect_failure);
            this.mTextErrTips.setText((CharSequence)"\u8bf7\u786e\u4fdd\u662f\u672c\u4eba\u64cd\u4f5c\u4e14\u6b63\u8138\u91c7\u96c6");
        }
    }

    public void onReturnHomeFailure(View v) {
        IntentUtils.destroyActivity();
        this.finish();
        FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(this.mLivenessResult);
        FaceCallbackManager.getInstance().mLivenessCallback = null;
    }

    public void onRecollectFailure(View v) {
        this.finish();
    }

    public void onBack(View v) {
        this.finish();
    }
}

