/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.LivenessTypeEnum;
import com.baidu.idl.face.platform.model.FaceExtInfo;
import com.baidu.idl.face.platform.model.ImageInfo;
import com.baidu.idl.face.platform.ui.BaseUIActivity;
import com.baidu.idl.face.platform.ui.CollectFailureActivity;
import com.baidu.idl.face.platform.ui.CollectionSuccessActivity;
import com.baidu.idl.face.platform.ui.utils.CameraPreviewUtils;
import com.baidu.idl.face.platform.ui.utils.HomeUtils;
import com.baidu.idl.face.platform.ui.utils.IntentUtils;
import com.baidu.idl.face.platform.ui.widget.FaceDetectRoundView;
import com.baidu.idl.face.platform.ui.widget.TimeoutDialog;
import com.baidu.idl.face.platform.utils.EventTrackUtils;
import com.baidu.idl.facelive.api.FaceLiveManager;
import com.baidu.idl.facelive.api.entity.LivenessResult;
import com.baidu.idl.facelive.api.manager.FaceCallbackManager;
import com.baidu.liantian.ac.FaceProcessCallback;
import com.baidu.liantian.ac.LH;
import com.baidu.liantian.ac.RequestInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class BaseCameraActivity
extends BaseUIActivity
implements FaceProcessCallback,
TimeoutDialog.OnTimeoutDialogClickListener,
HomeUtils.HomeCallback {
    private static final String TAG = BaseCameraActivity.class.getName();
    protected SurfaceView mSurfaceView;
    private TimeoutDialog mTimeoutDialog;
    protected View mViewBg;
    protected Camera.Parameters mCameraParam;
    protected int mPreviewWidth;
    protected int mPreviewHight;
    private int mStatus;
    private RequestInfo mRequestInfo;
    private String mSafeErrMsg;
    protected BroadcastReceiver mHomeReceiver;
    protected boolean mIsClickHomeKey;
    protected boolean mHasShownTimeoutDialog;

    protected void onResume() {
        super.onResume();
        this.mHomeReceiver = HomeUtils.registerHomeReceiver((Context)this, this);
    }

    protected void onPause() {
        super.onPause();
        if (this.mHomeReceiver != null) {
            HomeUtils.unRegisterHomeReceiver((Context)this, this.mHomeReceiver);
            this.mHomeReceiver = null;
        }
    }

    public void startPreview(SurfaceHolder holder) {
        LH.startFaceProcessSurface((Activity)this, (SurfaceHolder)holder, (FaceProcessCallback)this, (int)FaceSDKManager.getInstance().getFaceConfig().getCacheImageNum());
    }

    protected void stopPreview() {
        LH.cancelFaceProcess();
    }

    public LivenessResult setLivenessResult(int status, RequestInfo requestInfo, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap, String safeErrMsg) {
        LivenessResult livenessResult = new LivenessResult();
        livenessResult.setSafetyCode(status);
        livenessResult.setRequestInfo(requestInfo);
        livenessResult.setSafeErrorMessage(safeErrMsg);
        if (base64ImageCropMap != null && base64ImageCropMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> base64ImageCropList = new ArrayList<Map.Entry<String, ImageInfo>>(base64ImageCropMap.entrySet());
            Collections.sort(base64ImageCropList, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
        }
        if (base64ImageSrcMap != null && base64ImageSrcMap.size() > 0) {
            ArrayList<Map.Entry<String, ImageInfo>> base64ImageSrcList = new ArrayList<Map.Entry<String, ImageInfo>>(base64ImageSrcMap.entrySet());
            Collections.sort(base64ImageSrcList, new Comparator<Map.Entry<String, ImageInfo>>(){

                @Override
                public int compare(Map.Entry<String, ImageInfo> o1, Map.Entry<String, ImageInfo> o2) {
                    String[] key1 = o1.getKey().split("_");
                    String score1 = key1[2];
                    String[] key2 = o2.getKey().split("_");
                    String score2 = key2[2];
                    return Float.valueOf(score2).compareTo(Float.valueOf(score1));
                }
            });
        }
        IntentUtils.getInstance().setLivenessResult(livenessResult);
        return livenessResult;
    }

    public void startSuccessActivity(Context thisContext, float liveScore, LivenessResult livenessResult) {
        if (!FaceLiveManager.getInstance().getFaceConfig().isShowResultView()) {
            this.finish();
            if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
                FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
                FaceCallbackManager.getInstance().mLivenessCallback = null;
            }
            return;
        }
        Intent intent = new Intent(thisContext, CollectionSuccessActivity.class);
        intent.putExtra("livenessScore", liveScore);
        this.startActivity(intent);
    }

    public void startFailureActivity(Context thisContext, float livenessScore, boolean isColorError, LivenessResult livenessResult) {
        if (!FaceLiveManager.getInstance().getFaceConfig().isShowResultView()) {
            this.finish();
            if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
                FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
                FaceCallbackManager.getInstance().mLivenessCallback = null;
            }
            return;
        }
        Intent intent = new Intent(thisContext, CollectFailureActivity.class);
        intent.putExtra("livenessScore", livenessScore);
        intent.putExtra("isColorError", isColorError);
        this.startActivity(intent);
    }

    public void showMessageDialog() {
        this.mTimeoutDialog = new TimeoutDialog((Context)this);
        this.mTimeoutDialog.setDialogListener(this);
        this.mTimeoutDialog.setCanceledOnTouchOutside(false);
        this.mTimeoutDialog.setCancelable(false);
        this.mTimeoutDialog.show();
        this.mHasShownTimeoutDialog = true;
        this.onPause();
    }

    public void setDialogLivenessResult(int status, RequestInfo requestInfo, String safeErrMsg) {
        LivenessResult livenessResult = this.setLivenessResult(status, requestInfo, null, null, safeErrMsg);
        if (livenessResult != null) {
            this.finish();
            if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
                FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
                FaceCallbackManager.getInstance().mLivenessCallback = null;
            }
        }
    }

    @Override
    public void onRecollect() {
        if (this.mTimeoutDialog != null) {
            this.mTimeoutDialog.dismiss();
        }
        this.mHasShownTimeoutDialog = false;
        if (this.mViewBg != null) {
            this.mViewBg.setVisibility(8);
        }
        this.onResume();
    }

    @Override
    public void onReturn() {
        LivenessResult livenessResult = new LivenessResult();
        livenessResult.setSafetyCode(this.mStatus);
        livenessResult.setRequestInfo(this.mRequestInfo);
        livenessResult.setSafeErrorMessage(this.mSafeErrMsg);
        if (this.mTimeoutDialog != null) {
            this.mTimeoutDialog.dismiss();
        }
        this.mHasShownTimeoutDialog = false;
        this.finish();
        if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
            FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
            FaceCallbackManager.getInstance().mLivenessCallback = null;
        }
    }

    public void onBegin() {
        Log.d((String)TAG, (String)"onBegin");
    }

    public void onBeginCollectFaceInfo() {
    }

    public void onConfigCamera(Camera camera, Rect previewRect, Rect detectRect) {
        if (camera == null) {
            return;
        }
        if (this.mCameraParam == null) {
            this.mCameraParam = camera.getParameters();
        }
        Point point = CameraPreviewUtils.getBestPreview(this.mCameraParam, new Point(640, 480));
        this.mPreviewWidth = point.x;
        this.mPreviewHight = point.y;
        previewRect.set(0, 0, this.mPreviewHight, this.mPreviewWidth);
        this.mCameraParam.setPreviewSize(this.mPreviewWidth, this.mPreviewHight);
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getWindowManager().getDefaultDisplay();
        display.getMetrics(dm);
        detectRect.set(FaceDetectRoundView.getPreviewDetectRect(dm.widthPixels, this.mPreviewHight, this.mPreviewWidth));
        camera.setParameters(this.mCameraParam);
    }

    public void onCollectCompletion(FaceStatusNewEnum status, String message, HashMap<String, ImageInfo> base64ImageCropMap, HashMap<String, ImageInfo> base64ImageSrcMap, int currentLivenessCount) {
    }

    public void onBeginBuildData() {
    }

    public void onEnd(final int status, final RequestInfo info, final String safeErrMsg) {
        Log.e((String)TAG, (String)("error status = " + status));
        this.mStatus = status;
        this.mRequestInfo = info;
        this.mSafeErrMsg = safeErrMsg;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (status != 1 && status != -401 && status != -402 && status != -403 && status != -404) {
                    if (BaseCameraActivity.this.mIsClickHomeKey) {
                        LivenessResult livenessResult = new LivenessResult();
                        livenessResult.setSafetyCode(status);
                        livenessResult.setRequestInfo(info);
                        livenessResult.setSafeErrorMessage(safeErrMsg);
                        if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
                            FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
                        }
                        return;
                    }
                    if (!BaseCameraActivity.this.isFinishing()) {
                        BaseCameraActivity.this.finish();
                    }
                    LivenessResult livenessResult = new LivenessResult();
                    livenessResult.setSafetyCode(status);
                    livenessResult.setRequestInfo(info);
                    livenessResult.setSafeErrorMessage(safeErrMsg);
                    if (FaceCallbackManager.getInstance().mLivenessCallback != null) {
                        FaceCallbackManager.getInstance().mLivenessCallback.onLivenessResult(livenessResult);
                        FaceCallbackManager.getInstance().mLivenessCallback = null;
                    }
                }
            }
        });
    }

    public void setCurrentLiveType(LivenessTypeEnum liveType) {
    }

    public void viewReset() {
    }

    public void animStop() {
    }

    public void setFaceInfo(FaceExtInfo faceInfo) {
    }

    public void setBackgroundColor(int currentColor, int preColor) {
    }

    public void setLiveScore(float liveScore) {
    }

    protected void onDestroy() {
        super.onDestroy();
        EventTrackUtils.saveStringToFile((String)"\u9000\u51fa\u91c7\u96c6\u9875\u9762");
    }

    @Override
    public void onClickHomeKey() {
        this.mIsClickHomeKey = true;
    }
}

