/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.tencent.cloud.huiyansdkface.wecamera.WeCamera;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.ScaleType;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.CameraV1;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import com.tencent.cloud.huiyansdkface.wecamera.preview.PreviewParameter;
import com.tencent.cloud.huiyansdkface.wecamera.utils.MathUtils;
import com.tencent.cloud.huiyansdkface.wecamera.view.CameraPreview;
import com.tencent.cloud.huiyansdkface.wecamera.view.CameraView;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WeCameraView
extends FrameLayout
implements CameraView {
    private static final String TAG = "CameraSurfaceView";
    private CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private SurfaceView mSurfaceView;
    private volatile SurfaceHolder mSurfaceHolder;
    CameraPreview iCameraPreview;
    private boolean holderCreated = false;
    private ScaleType mScaleType;
    private PreviewParameter mPreviewParameter;
    private Rect mPreviewRect;
    private WeCamera weCamera;
    private boolean hasStartPreview = false;
    View previewView;

    public WeCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public WeCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public WeCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @SuppressLint(value={"NewApi"})
    public WeCameraView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    protected SurfaceView getSurfaceView(Context ctx) {
        return new SurfaceView(ctx);
    }

    public void init(CameraPreview iPreview) {
        if (iPreview != null) {
            this.iCameraPreview = iPreview;
            this.previewView = this.iCameraPreview.getPreviewView(this.getContext());
            this.iCameraPreview.setPreviewCallback(new CameraPreview.Callback(){

                @Override
                public void onPreviewCreated() {
                    WeCameraLogger.d(WeCameraView.TAG, "onPreviewCreated", new Object[0]);
                    WeCameraView.this.holderCreated = true;
                    WeCameraView.this.mCountDownLatch.countDown();
                }

                @Override
                public void onPreviewDestroy() {
                    WeCameraLogger.d(WeCameraView.TAG, "onPreviewDestroy", new Object[0]);
                    WeCameraView.this.mScaleType = null;
                    WeCamera weCamera = WeCameraView.this.weCamera;
                    if (weCamera != null) {
                        weCamera.stop();
                    }
                }
            });
            this.addView(this.previewView, new ViewGroup.LayoutParams(-1, -1));
            return;
        }
        this.mSurfaceView = this.getSurfaceView(this.getContext());
        if (this.mSurfaceHolder != null) {
            WeCameraLogger.w(TAG, "surfaceHolder already created", new Object[0]);
            return;
        }
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                WeCameraLogger.d(WeCameraView.TAG, "surfaceCreated:" + (holder != null) + ":" + Thread.currentThread().getName(), new Object[0]);
                if (WeCameraView.this.hasStartPreview) {
                    WeCameraView.this.setPreviewAfterHolderCreated(WeCameraView.this.weCamera, WeCameraView.this.mSurfaceView);
                } else {
                    WeCameraView.this.mSurfaceHolder = holder;
                    WeCameraView.this.mCountDownLatch.countDown();
                }
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                WeCameraLogger.d(WeCameraView.TAG, "surfaceChanged:" + (holder != null) + ":" + format + ",width=" + width + ",height=" + height, new Object[0]);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                WeCameraLogger.d(WeCameraView.TAG, "surfaceDestroyed:" + holder, new Object[0]);
                WeCameraView.this.mScaleType = null;
                WeCamera weCamera = WeCameraView.this.weCamera;
                if (weCamera != null) {
                    weCamera.stop();
                }
            }
        });
        this.addView((View)this.mSurfaceView, new ViewGroup.LayoutParams(-1, -1));
    }

    private void initView(Context context) {
    }

    private void setPreviewAfterHolderCreated(WeCamera weCamera, Object surfaceView) {
        if (weCamera != null) {
            weCamera.setDisplayViewAndStartPreview(surfaceView);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mCountDownLatch.getCount() > 0L) {
            this.mCountDownLatch.countDown();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        WeCameraLogger.d(TAG, "onLayout:changed=" + changed, new Object[0]);
        super.onLayout(changed, left, top, right, bottom);
        if (this.mPreviewParameter != null && this.mScaleType != null && changed) {
            this.updateCameraView();
        }
    }

    private void calcPreviewRect() {
        int w = this.getWidth();
        int h = this.getHeight();
        Size fs = new Size(w, h);
        Size ps = this.mPreviewParameter.previewSize();
        if (this.exchangePreviewSize()) {
            ps = new Size(ps.height, ps.width);
        }
        Size prs = this.mScaleType.name().startsWith("FIT") ? MathUtils.fit(ps, fs) : MathUtils.crop(ps, fs);
        WeCameraLogger.d(TAG, "container layout size:width=" + w + ",height=" + h, new Object[0]);
        WeCameraLogger.d(TAG, "preview size scale result:" + prs, new Object[0]);
        int paddingLeft = (prs.width - w) / 2;
        int paddingTop = (prs.height - h) / 2;
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        switch (this.mScaleType) {
            case CROP_CENTER: {
                left = -paddingLeft;
                top = -paddingTop;
                right = w + paddingLeft;
                bottom = h + paddingTop;
                break;
            }
            case CROP_START: {
                left = -paddingLeft;
                top = 0;
                right = w + paddingLeft;
                bottom = h + 2 * paddingTop;
                break;
            }
            case CROP_END: {
                left = -paddingLeft;
                top = -2 * paddingTop;
                right = w + paddingLeft;
                bottom = h;
                break;
            }
            case FIT_START: {
                left = -paddingLeft;
                top = 0;
                right = w + paddingLeft;
                bottom = h + 2 * paddingTop;
                break;
            }
            case FIT_END: {
                left = -paddingLeft;
                top = -2 * paddingTop;
                right = w + paddingLeft;
                bottom = h;
                break;
            }
            case FIT_CENTER: {
                left = -paddingLeft;
                top = -paddingTop;
                right = w + paddingLeft;
                bottom = h + paddingTop;
            }
        }
        this.mPreviewRect = new Rect(left, top, right, bottom);
        WeCameraLogger.d(TAG, "we camera view child rect size:" + this.mPreviewRect.toShortString(), new Object[0]);
    }

    protected boolean exchangePreviewSize() {
        return (this.mPreviewParameter.screenOrientation() - this.mPreviewParameter.cameraOrientation()) % 180 != 0;
    }

    private void layoutChildren() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(this.mPreviewRect.left, this.mPreviewRect.top, this.mPreviewRect.right, this.mPreviewRect.bottom);
        }
    }

    public Rect previewRect() {
        return this.mPreviewRect;
    }

    public PreviewParameter getPreviewParameter() {
        return this.mPreviewParameter;
    }

    @Override
    public void setPreviewConfig(ScaleType scaleType, PreviewParameter previewParameter) {
        this.mScaleType = scaleType;
        this.mPreviewParameter = previewParameter;
        WeCameraLogger.d(TAG, "setPreviewConfig", new Object[0]);
        this.updateCameraView();
    }

    public void updateCameraView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (WeCameraView.this.mScaleType == null) {
                    return;
                }
                WeCameraView.this.calcPreviewRect();
                Rect previewRect = WeCameraView.this.mPreviewRect;
                View child = WeCameraView.this.getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)child.getLayoutParams();
                layoutParams.width = previewRect.width();
                layoutParams.height = previewRect.height();
                layoutParams.topMargin = previewRect.top;
                layoutParams.leftMargin = previewRect.left;
                child.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
    }

    private void reLayout() {
        this.post(new Runnable(){

            @Override
            public void run() {
                WeCameraView.this.requestLayout();
            }
        });
    }

    @Override
    public void attachWeCamera(WeCamera weCamera) {
        this.weCamera = weCamera;
    }

    @Override
    public boolean afterCameraConfigured(WeCamera weCamera, CameraV1 cameraV) {
        if (this.iCameraPreview != null) {
            if (this.iCameraPreview.waitPreviewCreate() && !this.holderCreated && this.waitHolderCreate()) {
                return false;
            }
            this.setPreviewAfterHolderCreated(weCamera, this.iCameraPreview);
            return true;
        }
        if (this.mSurfaceHolder == null && this.waitHolderCreate()) {
            return false;
        }
        this.setPreviewAfterHolderCreated(weCamera, this.mSurfaceView);
        return true;
    }

    private boolean waitHolderCreate() {
        if (this.mCountDownLatch.getCount() == 0L && this.mSurfaceHolder == null) {
            WeCameraLogger.w(TAG, "surfaceHolder==null and countDownLatch==0", new Object[0]);
            return true;
        }
        try {
            WeCameraLogger.d(TAG, "attachCameraView:wait for surface create", new Object[0]);
            this.mCountDownLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    @Override
    public void onAfterStartPreview() {
        this.hasStartPreview = true;
        WeCameraLogger.d(TAG, "startPreview now and request layout", new Object[0]);
    }

    public Rect mapPreview(Rect rect) {
        Rect previewRect = this.mPreviewRect;
        if (previewRect == null) {
            WeCameraLogger.w(TAG, "previewRect=null", new Object[0]);
            return null;
        }
        Size previewSize = this.mPreviewParameter.previewSize();
        float scale = this.mPreviewParameter.displayOrientation() % 90 == 0 ? (float)previewSize.width / (float)previewRect.height() : (float)previewSize.width / (float)previewRect.width();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        matrix.postRotate((float)(-this.mPreviewParameter.displayOrientation()));
        if (rect == null) {
            rect = new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        RectF result = new RectF((float)(rect.left - previewRect.left), (float)(rect.top - previewRect.top), (float)(rect.right - previewRect.left), (float)(rect.bottom - previewRect.top));
        result.set(result.left * scale, result.top * scale, result.right * scale, result.bottom * scale);
        if (this.mPreviewParameter.displayOrientation() % 90 == 0) {
            result.set(result.top, result.left, result.bottom, result.right);
        }
        Rect out = new Rect();
        result.round(out);
        int left = out.left < 0 ? 0 : out.left;
        int top = out.top < 0 ? 0 : out.top;
        int right = out.right > previewSize.width ? previewSize.width : out.right;
        int bottom = out.bottom > previewSize.height ? previewSize.height : out.bottom;
        out.set(left, top, right, bottom);
        return out;
    }
}

