/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CameraUtils {
    private static final String TAG = "CameraUtils";
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final double MAX_ASPECT_DISTORTION = 0.16;

    public static Point findBestPictureSize(List<Size> originSupportPictureSizes, Size targetResolution, int screenOrientation, int cameraOrientation) {
        int targetArea;
        if (originSupportPictureSizes == null) {
            return null;
        }
        ArrayList<Size> supportedPreviewResolutions = new ArrayList<Size>(originSupportPictureSizes);
        boolean isCandidatePortrait = screenOrientation % 180 != cameraOrientation % 180;
        double screenAspectRatio = (double)targetResolution.width / (double)targetResolution.height;
        Iterator<Object> it = supportedPreviewResolutions.iterator();
        while (it.hasNext()) {
            int maybeFlippedHeight;
            int height;
            Size supportedPreviewResolution = (Size)it.next();
            int width = supportedPreviewResolution.getWidth();
            if (width * (height = supportedPreviewResolution.getHeight()) < 153600) {
                it.remove();
                continue;
            }
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            double aspectRatio = (double)maybeFlippedWidth / (double)(maybeFlippedHeight = isCandidatePortrait ? width : height);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (distortion > 0.16) {
                it.remove();
                continue;
            }
            if (maybeFlippedWidth != targetResolution.width || maybeFlippedHeight != targetResolution.height) continue;
            Point exactPoint = new Point(width, height);
            Log.d((String)TAG, (String)("found preview resolution exactly matching screen resolutions: " + exactPoint));
            return exactPoint;
        }
        Size target = null;
        int minDiff = targetArea = targetResolution.getArea();
        if (!supportedPreviewResolutions.isEmpty()) {
            for (Size size : supportedPreviewResolutions) {
                int diff = Math.abs(size.getArea() - targetArea);
                if (diff >= minDiff) continue;
                target = size;
                minDiff = diff;
            }
            if (target != null) {
                Point largestSize = new Point(target.width, target.height);
                Log.d((String)TAG, (String)("using minimum diff picture resolution: " + largestSize));
                return largestSize;
            }
        }
        if (supportedPreviewResolutions.isEmpty()) {
            for (Size next : originSupportPictureSizes) {
                if (next.width != 640 || next.height != 480) continue;
                return new Point(next.width, next.height);
            }
        }
        return null;
    }

    public static Point findBestPreviewResolution(List<Size> originSupportPreviewSizes, Size screenResolution, int screenOrientation, int cameraOrientation) {
        if (originSupportPreviewSizes == null) {
            return null;
        }
        ArrayList<Size> supportedPreviewResolutions = new ArrayList<Size>(originSupportPreviewSizes);
        boolean isCandidatePortrait = screenOrientation % 180 != cameraOrientation % 180;
        double screenAspectRatio = (double)screenResolution.width / (double)screenResolution.height;
        Iterator<Object> it = supportedPreviewResolutions.iterator();
        while (it.hasNext()) {
            int maybeFlippedHeight;
            int height;
            Size supportedPreviewResolution = (Size)it.next();
            int width = supportedPreviewResolution.getWidth();
            if (width * (height = supportedPreviewResolution.getHeight()) < 153600) {
                it.remove();
                continue;
            }
            int maybeFlippedWidth = isCandidatePortrait ? height : width;
            double aspectRatio = (double)maybeFlippedWidth / (double)(maybeFlippedHeight = isCandidatePortrait ? width : height);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (distortion > 0.16) {
                it.remove();
                continue;
            }
            if (maybeFlippedWidth != screenResolution.width || maybeFlippedHeight != screenResolution.height) continue;
            Point exactPoint = new Point(width, height);
            Log.d((String)TAG, (String)("found preview resolution exactly matching screen resolutions: " + exactPoint));
            return exactPoint;
        }
        if (!supportedPreviewResolutions.isEmpty()) {
            Size largestPreview = (Size)supportedPreviewResolutions.get(0);
            Point largestSize = new Point(largestPreview.width, largestPreview.height);
            Log.d((String)TAG, (String)("using largest suitable preview resolution: " + largestSize));
            return largestSize;
        }
        if (supportedPreviewResolutions.isEmpty()) {
            for (Size next : originSupportPreviewSizes) {
                if (next.width != 640 || next.height != 480) continue;
                return new Point(next.width, next.height);
            }
        }
        return null;
    }

    public static int getCorrectRotation(CameraFacing facing, int screenOrientation, int cameraOrientation) {
        int result;
        if (facing.isFront()) {
            result = (cameraOrientation + screenOrientation) % 360;
            result = (360 - result) % 360;
        } else {
            result = (cameraOrientation - screenOrientation + 360) % 360;
        }
        return result;
    }

    public static int getScreenRealOrientation(Context mContext) {
        Display display = CameraUtils.getDisplay(mContext);
        int screenOrientation = display.getOrientation();
        screenOrientation = CameraUtils.getScreenRealOrientation(screenOrientation);
        return screenOrientation;
    }

    public static int getScreenOrientation(Context ctx) {
        return CameraUtils.getDisplay(ctx).getOrientation();
    }

    public static int getScreenRealOrientation(int screenOrientation) {
        switch (screenOrientation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static Point getRealDisplaySize(Context context) {
        Point point = new Point();
        Display display = CameraUtils.getDisplay(context);
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(point);
        } else {
            point.set(display.getWidth(), display.getHeight());
        }
        Log.i((String)TAG, (String)String.format("real display size:%d,%d", point.x, point.y));
        return point;
    }

    private static Display getDisplay(Context mContext) {
        WindowManager windowManager = (WindowManager)mContext.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    public static Size getOptimalVideoSize(List<Size> supportedVideoSizes, List<Size> previewSizes, Size preferredSize4Video, Size target) {
        double ASPECT_TOLERANCE = 0.001;
        double targetRatio = (double)target.width / (double)target.height;
        List<Size> videoSizes = supportedVideoSizes != null ? supportedVideoSizes : previewSizes;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = target.height;
        Iterator<Size> iterator = videoSizes.iterator();
        while (iterator.hasNext()) {
            Size next = iterator.next();
            if (next.getArea() <= preferredSize4Video.getArea()) continue;
            iterator.remove();
        }
        for (Size size : videoSizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.001 || !((double)Math.abs(size.height - targetHeight) < minDiff) || !previewSizes.contains(size)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : videoSizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff) || !previewSizes.contains(size)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public static Rect getScreenRect() {
        DisplayMetrics displayMetric = new DisplayMetrics();
        displayMetric = Resources.getSystem().getDisplayMetrics();
        Rect rect = new Rect(0, 0, displayMetric.widthPixels, displayMetric.heightPixels);
        return rect;
    }

    public static Matrix getPictureMatrix(CameraFacing facing, int displayRotation) {
        Matrix m = new Matrix();
        if (facing.isFront()) {
            m.setScale(-1.0f, 1.0f);
        }
        m.postRotate((float)displayRotation);
        return m;
    }
}

