/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.hardware.v1;

import android.hardware.Camera;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrors;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraException;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.ZoomOperator;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;

public class V1ZoomOperator
implements ZoomOperator {
    private static final String TAG = "V1ZoomOperator";
    private Camera mCamera;

    public V1ZoomOperator(Camera camera) {
        this.mCamera = camera;
    }

    @Override
    public void takeZoom(float scale) {
        WeCameraLogger.d(TAG, "take scale:" + scale, new Object[0]);
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (!parameters.isZoomSupported()) {
                WeCameraLogger.d(TAG, "zoom unsupported", new Object[0]);
                return;
            }
            int maxZoom = parameters.getMaxZoom();
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            if (scale < 0.0f) {
                scale = 0.0f;
            }
            int zoom = (int)((float)maxZoom * scale);
            parameters.setZoom(zoom);
            this.mCamera.setParameters(parameters);
            WeCameraLogger.d(TAG, "take scale success.", new Object[0]);
        }
        catch (Exception e) {
            CameraErrors.throwError(CameraException.ofDevice(63, "set zoom failed", e));
        }
    }
}

