/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.hardware.v1;

import android.hardware.Camera;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrors;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraException;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.CameraV1;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1ParameterOperator;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import java.util.ArrayList;
import java.util.List;

public class V1ParametersOperator {
    private static final String TAG = "V1ParasOperator";
    private List<V1ParameterOperator> mParameterOperators = new ArrayList<V1ParameterOperator>();

    public void addParameterOperator(V1ParameterOperator operator) {
        if (operator != null && !this.mParameterOperators.contains(operator)) {
            this.mParameterOperators.add(operator);
        }
    }

    public void removeParameterOperator(V1ParameterOperator operator) {
        if (operator != null && this.mParameterOperators.contains(operator)) {
            this.mParameterOperators.remove(operator);
        }
    }

    public void operate(CameraV1 cameraV1) {
        Camera camera = cameraV1.camera();
        long start = System.currentTimeMillis();
        Exception exception = null;
        int errorIndex = -1;
        for (int i = 0; i < this.mParameterOperators.size(); ++i) {
            Camera.Parameters parameters = camera.getParameters();
            try {
                this.mParameterOperators.get(i).operate(parameters, cameraV1);
                camera.setParameters(parameters);
                continue;
            }
            catch (Exception e) {
                exception = e;
                errorIndex = i;
            }
        }
        if (exception != null) {
            CameraErrors.throwError(new CameraException(22, "set some parameter failed:" + errorIndex, exception, "type_normal"));
        }
        WeCameraLogger.d(TAG, "set config success. use time:" + (System.currentTimeMillis() - start), new Object[0]);
    }
}

