/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.hardware.v1;

import android.hardware.Camera;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrors;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraException;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraConnector;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraV;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.CameraV1;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V1Connector
implements CameraConnector<CameraV1> {
    private static final String TAG = "V1Connector";
    private Camera mCamera;
    private int mCameraId;
    private Camera.CameraInfo mCameraInfo;
    private CameraFacing mCameraFacing;
    private List<CameraV> cameraList = new ArrayList<CameraV>();

    @Override
    public CameraV1 open(CameraFacing type) {
        this.mCameraFacing = type;
        WeCameraLogger.d(TAG, "\u9700\u8981\u7684\u6444\u50cf\u5934:" + type.toString(), new Object[0]);
        int numberOfCameras = Camera.getNumberOfCameras();
        WeCameraLogger.d(TAG, "open camera:number of cameras=%d", numberOfCameras);
        if (numberOfCameras <= 0) {
            CameraErrors.throwError(CameraException.ofFatal(11, "no camera can use:numberOfCameras is 0", null));
            return null;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (numberOfCameras == 1) {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            this.mCameraFacing.setFront(this.getFacingType(cameraInfo.facing));
            CameraV1 cameraV = this.openCamera(cameraInfo, 0);
            this.cameraList.add(cameraV);
            return cameraV;
        }
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            WeCameraLogger.d(TAG, "camera:" + i + ":face=" + cameraInfo.facing, new Object[0]);
            if (V1Connector.isTargetV1Type(type, cameraInfo.facing, i)) {
                WeCameraLogger.i(TAG, "camera open:find dest camera:face=%s,camera id=%d", type.toString(), i);
                CameraV1 cameraV1 = this.openCamera(cameraInfo, i);
                this.cameraList.add(cameraV1);
                this.mCameraFacing.setFront(this.getFacingType(cameraInfo.facing));
                return cameraV1;
            }
            this.cameraList.add(new CameraV1().cameraFacing(this.getFacing(cameraInfo.facing)).cameraId(i).cameraInfo(cameraInfo).orientation(cameraInfo.orientation));
        }
        CameraErrors.throwError(CameraException.ofFatal(11, "no camera can use:numberOfCameras is " + this.cameraList.size() + ":" + this.cameraList, null));
        return null;
    }

    private CameraFacing getFacing(int facing) {
        if (facing == 0) {
            return CameraFacing.BACK;
        }
        if (facing == 1) {
            return CameraFacing.FRONT;
        }
        return CameraFacing.FRONT;
    }

    private boolean getFacingType(int facing) {
        return facing == 1;
    }

    private CameraV1 openCamera(Camera.CameraInfo cameraInfo, int i) {
        this.mCamera = Camera.open((int)i);
        this.mCameraInfo = cameraInfo;
        this.mCameraId = i;
        return this.cameraV();
    }

    public static boolean isTargetV1Type(CameraFacing type, int facing, int cameraId) {
        if (facing == 0 && type == CameraFacing.BACK) {
            return true;
        }
        if (facing == 1 && type == CameraFacing.FRONT) {
            return true;
        }
        return type.getValue() == cameraId;
    }

    @Override
    public synchronized void close() {
        if (this.mCamera != null) {
            WeCameraLogger.d(TAG, "close camera:" + this.mCamera, new Object[0]);
            this.mCamera.release();
            this.mCameraInfo = null;
            this.mCamera = null;
        }
    }

    public int cameraId() {
        return this.mCameraId;
    }

    @Override
    public List<CameraV> getCameraList() {
        return Collections.unmodifiableList(this.cameraList);
    }

    public Camera.CameraInfo cameraInfo() {
        return this.mCameraInfo;
    }

    public CameraV1 cameraV() {
        return new CameraV1().camera(this.mCamera).orientation(this.mCameraInfo.orientation).cameraInfo(this.mCameraInfo).cameraFacing(this.mCameraFacing).cameraId(this.mCameraId);
    }
}

