/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.hardware.v1;

import android.hardware.Camera;
import android.view.SurfaceView;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfig;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfigSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraSupportFeatures;
import com.tencent.cloud.huiyansdkface.wecamera.config.DisplayOrientationOperator;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrors;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraException;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraDevice;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraV;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.CameraV1;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1ConfigOperator;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1Connector;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1FeatureCollector;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1PreviewProcessor;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.V1ZoomOperator;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import com.tencent.cloud.huiyansdkface.wecamera.preview.PreviewParameter;
import com.tencent.cloud.huiyansdkface.wecamera.preview.PreviewProcessor;
import com.tencent.cloud.huiyansdkface.wecamera.utils.CameraUtils;
import com.tencent.cloud.huiyansdkface.wecamera.view.CameraPreview;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CameraV1Device
implements CameraDevice<CameraV1> {
    private static final String TAG = "CameraV1Device";
    private V1Connector mV1Connector = new V1Connector();
    private CameraV1 mCamera;
    private int screenRealOrientation;
    private volatile boolean stopped = false;
    private PreviewParameter previewParameter;

    @Override
    public CameraV1 open(CameraFacing type) {
        try {
            this.mV1Connector.open(type);
            this.mCamera = this.mV1Connector.cameraV();
            this.mCamera.cameraSupportFeatures(this.getCameraFeatures());
            return this.mCamera;
        }
        catch (Exception e) {
            CameraErrors.throwError(CameraException.ofFatal(1, "open camera exception", e));
            return null;
        }
    }

    @Override
    public List<CameraV> getCameraList() {
        return this.mV1Connector.getCameraList();
    }

    @Override
    public void close() {
        this.mV1Connector.close();
        this.mCamera = null;
    }

    @Override
    public void startPreview() {
        this.stopped = false;
        WeCameraLogger.d(TAG, "startPreview", new Object[0]);
        try {
            this.mCamera.camera().startPreview();
        }
        catch (Throwable t) {
            CameraErrors.throwError(CameraException.ofDevice(3, "start preview failed", t));
        }
    }

    @Override
    public synchronized void stopPreview() {
        if (this.mCamera != null) {
            WeCameraLogger.d(TAG, "stopPreview", new Object[0]);
            try {
                this.mCamera.camera().stopPreview();
            }
            catch (Throwable t) {
                CameraErrors.throwError(CameraException.ofDevice(8, "stop preview failed", t));
            }
            this.stopped = true;
        } else if (!this.stopped) {
            CameraErrors.throwError(CameraException.ofStatus(81, "you must start preview first"));
        }
    }

    @Override
    public void setDisplayView(Object displayView) {
        if (displayView instanceof CameraPreview) {
            ((CameraPreview)displayView).setPreviewView(this.mCamera);
            return;
        }
        if (displayView == null) {
            try {
                this.mCamera.camera().setPreviewDisplay(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            WeCameraLogger.d(TAG, "set display view :" + displayView, new Object[0]);
            this.mCamera.camera().setPreviewDisplay(((SurfaceView)displayView).getHolder());
        }
        catch (Exception e) {
            CameraErrors.throwError(CameraException.ofFatal(3, "set preview display failed", e));
        }
    }

    @Override
    public void takeZoom(float scale) {
        if (scale == -1.0f) {
            return;
        }
        V1ZoomOperator mZoomOperator = new V1ZoomOperator(this.mCamera.camera());
        mZoomOperator.takeZoom(scale);
    }

    @Override
    public CameraConfig updateConfig(CameraConfigSelectors cameraConfigs) {
        return new V1ConfigOperator(this, this.mCamera).updateConfig(cameraConfigs);
    }

    @Override
    public void setDisplayOrientation(DisplayOrientationOperator orientationOperator, int screenRealOrientation) {
        this.screenRealOrientation = screenRealOrientation;
        if (this.mCamera != null) {
            int correctRotation = -1;
            if (orientationOperator != null) {
                correctRotation = orientationOperator.getOrientation(this.mCamera, screenRealOrientation);
            }
            if (correctRotation < 0) {
                correctRotation = CameraUtils.getCorrectRotation(this.mCamera.cameraFacing(), screenRealOrientation, this.mCamera.orientation());
            }
            WeCameraLogger.d(TAG, "camera set display orientation:screenOrientation=" + screenRealOrientation + ",camera orientation=" + this.mCamera.orientation() + ",\ncalc display orientation result:" + correctRotation, new Object[0]);
            this.mCamera.camera().setDisplayOrientation(correctRotation);
        }
    }

    @Override
    public PreviewParameter getDisplayFeature() {
        if (this.previewParameter != null) {
            return this.previewParameter;
        }
        PreviewParameter parameter = new PreviewParameter();
        Camera.Parameters parameters = this.mCamera.camera().getParameters();
        Camera.Size previewSize = parameters.getPreviewSize();
        int previewFormat = parameters.getPreviewFormat();
        this.previewParameter = parameter.previewSize(new Size(previewSize.width, previewSize.height)).cameraFacing(this.mCamera.cameraFacing()).cameraOrientation(this.mCamera.orientation()).screenOrientation(this.screenRealOrientation).displayOrientation(CameraUtils.getCorrectRotation(this.mCamera.cameraFacing(), this.screenRealOrientation, this.mCamera.orientation())).imageFormat(previewFormat);
        return this.previewParameter;
    }

    @Override
    public boolean autoFocus() {
        if (this.mCamera == null) {
            CameraErrors.throwError(CameraException.ofStatus(621, "camera is null,cannot autoFocus"));
            return false;
        }
        final boolean[] result = new boolean[]{false};
        final CountDownLatch latch = new CountDownLatch(1);
        WeCameraLogger.d(TAG, "start auto focus.", new Object[0]);
        this.mCamera.camera().autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean success, Camera camera) {
                WeCameraLogger.d(CameraV1Device.TAG, "auto focus finish:result=" + success, new Object[0]);
                result[0] = success;
                latch.countDown();
            }
        });
        try {
            boolean await = latch.await(2L, TimeUnit.SECONDS);
            if (!await) {
                this.mCamera.camera().cancelAutoFocus();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WeCameraLogger.d(TAG, "get focus result:" + result[0], new Object[0]);
        return result[0];
    }

    @Override
    public PreviewProcessor getPreviewProcessor() {
        return new V1PreviewProcessor(this, this.mCamera.camera());
    }

    @Override
    public CameraSupportFeatures getCameraFeatures() {
        if (this.mCamera == null) {
            return null;
        }
        V1FeatureCollector v1FeatureOperator = new V1FeatureCollector(this.mCamera);
        return v1FeatureOperator.getCameraFeatures();
    }
}

