/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.config.utils;

import android.hardware.Camera;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Fps;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class V1CameraConvector {
    public static List<Fps> convertAndSortFps(List<int[]> fpsList) {
        if (fpsList == null) {
            return Collections.emptyList();
        }
        ArrayList<Fps> result = new ArrayList<Fps>();
        for (int[] ints : fpsList) {
            if (ints == null || ints.length < 2) continue;
            result.add(new Fps(ints[0], ints[1]));
        }
        return result;
    }

    public static List<Size> convertAndSortSize(List<Camera.Size> sizeList) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (sizeList != null && sizeList.size() > 0) {
            for (Camera.Size supportedPreviewSize : sizeList) {
                if (supportedPreviewSize == null) continue;
                sizes.add(V1CameraConvector.convert(supportedPreviewSize));
            }
        }
        Collections.sort(sizes, new Comparator<Size>(){

            @Override
            public int compare(Size o1, Size o2) {
                return o2.getArea() - o1.getArea();
            }
        });
        return sizes;
    }

    public static Size convert(Camera.Size size) {
        if (size == null) {
            return null;
        }
        return new Size(size.width, size.height);
    }
}

