/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.config.selector;

import android.content.Context;
import com.tencent.cloud.huiyansdkface.wecamera.config.FeatureSelector;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraV;
import com.tencent.cloud.huiyansdkface.wecamera.utils.CameraUtils;
import java.util.List;

public class BestPreviewSize4VideoSelector
implements FeatureSelector<Size> {
    public static final int NON_WIDTH = 640;
    public static final int NON_HEIGHT = 480;
    private Context mContext;
    private Size mTargetViewSize;

    public BestPreviewSize4VideoSelector(Context context) {
        this.mContext = context;
    }

    public BestPreviewSize4VideoSelector size(Size size) {
        this.mTargetViewSize = size;
        return this;
    }

    @Override
    public Size select(List<Size> candidates, CameraV cameraV) {
        Size optimalVideoSize;
        int screenOrientation;
        List<Size> videoSizes = cameraV.cameraSupportFeatures().supportVideoSizes();
        int cameraOrientation = cameraV.orientation();
        if (cameraOrientation % 180 != (screenOrientation = CameraUtils.getScreenRealOrientation(this.mContext)) % 180) {
            this.mTargetViewSize = new Size(this.mTargetViewSize.height, this.mTargetViewSize.width);
        }
        if ((optimalVideoSize = CameraUtils.getOptimalVideoSize(videoSizes, candidates, cameraV.cameraSupportFeatures().preferredPreviewSize4Video(), this.mTargetViewSize)) == null) {
            optimalVideoSize = new Size(640, 480);
        }
        return optimalVideoSize;
    }
}

