/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera.config;

import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfigSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.ConfigOperate;
import com.tencent.cloud.huiyansdkface.wecamera.config.FeatureSelector;
import java.util.ArrayList;
import java.util.List;

public class UpdateRequest {
    private FeatureSelector<String> flashModeSelector;
    private FeatureSelector<String> focusModeSelector;
    private List<ConfigOperate> mConfigOperateList;

    public UpdateRequest(FeatureSelector<String> flashModeSelector, FeatureSelector<String> focusModeSelector, List<ConfigOperate> configOperateList) {
        this.flashModeSelector = flashModeSelector;
        this.focusModeSelector = focusModeSelector;
        this.mConfigOperateList = configOperateList;
    }

    public FeatureSelector<String> flashMode() {
        return this.flashModeSelector;
    }

    public FeatureSelector<String> focusMode() {
        return this.focusModeSelector;
    }

    public CameraConfigSelectors selectors() {
        return new CameraConfigSelectors().flashMode(this.flashModeSelector).focusMode(this.focusModeSelector).configOperates(this.mConfigOperateList);
    }

    public static class Builder {
        private List<ConfigOperate> mConfigOperateList = new ArrayList<ConfigOperate>();
        private FeatureSelector<String> flashModeSelector;
        private FeatureSelector<String> focusModeSelector;

        public Builder addConfig(ConfigOperate configOperate) {
            if (configOperate != null && !this.mConfigOperateList.contains(configOperate)) {
                this.mConfigOperateList.add(configOperate);
            }
            return this;
        }

        public Builder flashMode(FeatureSelector<String> flashModeSelector) {
            this.flashModeSelector = flashModeSelector;
            return this;
        }

        public Builder focusMode(FeatureSelector<String> focusModeSelector) {
            this.focusModeSelector = focusModeSelector;
            return this;
        }

        public UpdateRequest create() {
            return new UpdateRequest(this.flashModeSelector, this.focusModeSelector, this.mConfigOperateList);
        }
    }
}

