/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera;

import android.os.Handler;
import android.os.Looper;
import com.tencent.cloud.huiyansdkface.wecamera.CameraAdapter;
import com.tencent.cloud.huiyansdkface.wecamera.WeCamera;
import com.tencent.cloud.huiyansdkface.wecamera.WeCameraListener;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraDevice;

public class WeCameraSwitcher {
    private CameraFacing mCameraFacing;
    private WeCamera mWeCamera;
    private Handler handler = new Handler(Looper.getMainLooper());

    public WeCameraSwitcher(CameraFacing facing, WeCamera weCamera) {
        this.mCameraFacing = facing;
        this.mWeCamera = weCamera;
    }

    public void switchCamera(final WeCamera weCamera, final SwitchCallback callback) {
        if (weCamera != null) {
            WeCamera oldCamera = this.mWeCamera;
            weCamera.registerCameraListener(new WeCameraListener(){

                @Override
                public void previewAfterStart(CameraDevice cameraDevice) {
                    super.previewAfterStart(cameraDevice);
                    weCamera.unregisterCameraListener(this);
                    WeCameraSwitcher.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFinish();
                        }
                    });
                }
            });
            if (oldCamera != null) {
                oldCamera.registerCameraListener(new CameraAdapter(){

                    @Override
                    public void cameraClosed() {
                        WeCameraSwitcher.this.mWeCamera = weCamera;
                        WeCameraSwitcher.this.mWeCamera.unregisterCameraListener(this);
                        weCamera.start();
                    }
                });
                oldCamera.stop();
            }
        }
    }

    public CameraFacing nextCamera() {
        CameraFacing cameraFacing;
        this.mCameraFacing = cameraFacing = this.mCameraFacing.isFront() ? CameraFacing.BACK : CameraFacing.FRONT;
        return cameraFacing;
    }

    public static interface SwitchCallback {
        public void onFinish();
    }
}

