/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera;

import android.content.Context;
import com.tencent.cloud.huiyansdkface.wecamera.CameraListener;
import com.tencent.cloud.huiyansdkface.wecamera.WeCamera;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfigSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.ConfigOperate;
import com.tencent.cloud.huiyansdkface.wecamera.config.DisplayOrientationOperator;
import com.tencent.cloud.huiyansdkface.wecamera.config.FeatureSelector;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Fps;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.ScaleType;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.Size;
import com.tencent.cloud.huiyansdkface.wecamera.config.selector.FlashModeSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.selector.FocusModeSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.selector.SizeSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrorCallback;
import com.tencent.cloud.huiyansdkface.wecamera.error.CameraErrors;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraProvider;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraProviders;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import com.tencent.cloud.huiyansdkface.wecamera.preview.WePreviewCallback;
import com.tencent.cloud.huiyansdkface.wecamera.view.CameraView;
import java.util.ArrayList;
import java.util.List;

public class WeCameraBuilder {
    private Context mContext;
    private CameraProvider mCameraProvider = CameraProviders.v1();
    private boolean useMainThread = false;
    private ScaleType mScaleType = ScaleType.CROP_CENTER;
    private CameraFacing mCameraFacing = CameraFacing.BACK;
    private CameraView mCameraView;
    private WePreviewCallback mWePreviewCallback = null;
    private FeatureSelector<String> mFlashModeSelector = FlashModeSelectors.firstAvailable(FlashModeSelectors.redEye(), FlashModeSelectors.autoFlash(), FlashModeSelectors.torch(), FlashModeSelectors.off());
    private FeatureSelector<String> mFocusModeSelector = FlashModeSelectors.firstAvailable(FocusModeSelectors.continuousPicture(), FocusModeSelectors.autoFocus(), FocusModeSelectors.fixed());
    private FeatureSelector<Size> mPreviewSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Size> mPictureSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Size> mVideoSizeSelector = SizeSelectors.maxArea();
    private FeatureSelector<Fps> mFpsFeatureSelector;
    private float mZoom = -1.0f;
    private CameraListener mCameraListener;
    private List<ConfigOperate> mConfigOperateList = new ArrayList<ConfigOperate>();
    private DisplayOrientationOperator mDisplayOrientationOperator;

    public WeCameraBuilder(Context context) {
        this.mContext = context;
    }

    public static WeCameraBuilder with(Context ctx) {
        return new WeCameraBuilder(ctx);
    }

    public WeCamera build() {
        WeCameraLogger.d("WeCamera", "wecamera version:v1.0.49", new Object[0]);
        CameraConfigSelectors cameraConfigSelectors = new CameraConfigSelectors().previewSize(this.mPreviewSizeSelector).pictureSize(this.mPictureSizeSelector).videoSize(this.mVideoSizeSelector).flashMode(this.mFlashModeSelector).focusMode(this.mFocusModeSelector).fps(this.mFpsFeatureSelector).configOperates(this.mConfigOperateList).displayOrientationOperator(this.mDisplayOrientationOperator);
        if (this.mZoom >= 0.0f && this.mZoom <= 1.0f) {
            cameraConfigSelectors.zoom(this.mZoom);
        }
        return new WeCamera(this.mContext, this.mCameraProvider, this.mCameraView, this.mCameraFacing, cameraConfigSelectors, this.mScaleType, this.mCameraListener, this.mWePreviewCallback, this.useMainThread);
    }

    public WeCameraBuilder useMainThread(boolean useMainThread) {
        this.useMainThread = useMainThread;
        return this;
    }

    public WeCameraBuilder addConfig(ConfigOperate configOperate) {
        if (configOperate != null && !this.mConfigOperateList.contains(configOperate)) {
            this.mConfigOperateList.add(configOperate);
        }
        return this;
    }

    public WeCameraBuilder previewFrameProcessor(WePreviewCallback wePreviewCallback) {
        this.mWePreviewCallback = wePreviewCallback;
        return this;
    }

    public WeCameraBuilder displayOrientationOperator(DisplayOrientationOperator displayOrientationOperator) {
        this.mDisplayOrientationOperator = displayOrientationOperator;
        return this;
    }

    public WeCameraBuilder into(CameraView cameraView) {
        if (cameraView != null) {
            this.mCameraView = cameraView;
        }
        return this;
    }

    public WeCameraBuilder cameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
        return this;
    }

    public WeCameraBuilder previewScale(ScaleType scaleType) {
        if (scaleType != null) {
            this.mScaleType = scaleType;
        }
        return this;
    }

    public WeCameraBuilder zoom(float zoom) {
        if (zoom > 1.0f || zoom < 0.0f) {
            zoom = 0.0f;
        }
        this.mZoom = zoom;
        return this;
    }

    public WeCameraBuilder flashMode(FeatureSelector<String> flashMode) {
        if (flashMode != null) {
            this.mFlashModeSelector = flashMode;
        }
        return this;
    }

    public WeCameraBuilder focusMode(FeatureSelector<String> focusMode) {
        if (focusMode != null) {
            this.mFocusModeSelector = focusMode;
        }
        return this;
    }

    public WeCameraBuilder previewSize(FeatureSelector<Size> previewSize) {
        if (previewSize != null) {
            this.mPreviewSizeSelector = previewSize;
        }
        return this;
    }

    public WeCameraBuilder pictureSize(FeatureSelector<Size> pictureSize) {
        if (pictureSize != null) {
            this.mPictureSizeSelector = pictureSize;
        }
        return this;
    }

    public WeCameraBuilder fps(FeatureSelector<Fps> fps) {
        if (fps != null) {
            this.mFpsFeatureSelector = fps;
        }
        return this;
    }

    public WeCameraBuilder facing(CameraFacing facing) {
        if (facing == null) {
            facing = CameraFacing.FRONT;
        }
        this.mCameraFacing = facing;
        return this;
    }

    public WeCameraBuilder provider(CameraProvider cameraProvider) {
        if (cameraProvider != null) {
            this.mCameraProvider = cameraProvider;
        }
        return this;
    }

    public WeCameraBuilder logger(WeCameraLogger.ILog log) {
        if (log != null) {
            WeCameraLogger.setLogger(log);
        }
        return this;
    }

    public WeCameraBuilder errorCallback(CameraErrorCallback errorCallback) {
        if (errorCallback != null) {
            CameraErrors.setErrorCallback(errorCallback);
        }
        return this;
    }
}

