/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.wecamera;

import android.content.Context;
import com.tencent.cloud.huiyansdkface.wecamera.CameraAdapter;
import com.tencent.cloud.huiyansdkface.wecamera.CameraListener;
import com.tencent.cloud.huiyansdkface.wecamera.WeCameraBuilder;
import com.tencent.cloud.huiyansdkface.wecamera.WeCameraListener;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfig;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraConfigSelectors;
import com.tencent.cloud.huiyansdkface.wecamera.config.CameraSupportFeatures;
import com.tencent.cloud.huiyansdkface.wecamera.config.UpdateRequest;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.CameraFacing;
import com.tencent.cloud.huiyansdkface.wecamera.config.feature.ScaleType;
import com.tencent.cloud.huiyansdkface.wecamera.focus.FocusCallback;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraDevice;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraProvider;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.CameraV;
import com.tencent.cloud.huiyansdkface.wecamera.hardware.v1.CameraV1;
import com.tencent.cloud.huiyansdkface.wecamera.log.WeCameraLogger;
import com.tencent.cloud.huiyansdkface.wecamera.preview.PreviewParameter;
import com.tencent.cloud.huiyansdkface.wecamera.preview.PreviewProcessor;
import com.tencent.cloud.huiyansdkface.wecamera.preview.WePreviewCallback;
import com.tencent.cloud.huiyansdkface.wecamera.utils.CameraUtils;
import com.tencent.cloud.huiyansdkface.wecamera.utils.WeUI;
import com.tencent.cloud.huiyansdkface.wecamera.view.CameraView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class WeCamera {
    private static final String TAG = "WeCamera";
    private volatile boolean mCameraOpened;
    private boolean previewCallbackStart = false;
    private boolean useMainThread;
    private static ExecutorService mCameraExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "WeCameraThread");
        }
    });
    private WeCameraListener mCameraListeners;
    private Context mContext;
    private CameraDevice mCameraDevice;
    private CameraView mCameraView;
    private CameraFacing mCameraFacing;
    private CameraConfigSelectors mCameraConfigSelectors;
    private ScaleType mScaleType;
    private CountDownLatch featureFetchLatch = new CountDownLatch(1);
    private CameraSupportFeatures mCameraSupportFeatures;
    private PreviewProcessor mPreviewProcessor;
    private List<WePreviewCallback> mWePreviewCallbacks;
    private PreviewParameter displayFeature;
    private CameraConfig cameraConfig;
    private CameraV mCameraV;
    private long startCameraTime;

    public static WeCamera create(Context ctx, CameraFacing facing, CameraView cameraView) {
        return new WeCameraBuilder(ctx).facing(facing).into(cameraView).build();
    }

    WeCamera(Context ctx, CameraProvider cameraProvider, CameraView cameraView, CameraFacing facing, CameraConfigSelectors cameraConfigSelectors, ScaleType scaleType, CameraListener cameraListener, WePreviewCallback wePreviewCallback, boolean useMainThread) {
        this.mContext = ctx;
        this.useMainThread = useMainThread;
        this.mCameraDevice = cameraProvider.get();
        this.mCameraView = cameraView;
        this.mCameraFacing = facing;
        this.mCameraConfigSelectors = cameraConfigSelectors;
        this.mScaleType = scaleType;
        this.mCameraListeners = new WeCameraListener();
        this.mCameraListeners.register(cameraListener);
        this.mWePreviewCallbacks = new ArrayList<WePreviewCallback>();
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.add(wePreviewCallback);
        }
        this.registerCameraListener(new CameraAdapter(){

            @Override
            public void cameraOpened(CameraDevice cameraDevice, CameraV cameraV, CameraConfig cameraConfigResult) {
                WeCamera.this.mCameraSupportFeatures = cameraV.cameraSupportFeatures();
                WeCamera.this.featureFetchLatch.countDown();
            }
        });
        this.mCameraView.attachWeCamera(this);
    }

    public WeCamera registerCameraListener(CameraListener listener) {
        this.mCameraListeners.register(listener);
        return this;
    }

    public WeCamera unregisterCameraListener(CameraListener listener) {
        this.mCameraListeners.unregister(listener);
        return this;
    }

    public boolean canUse() {
        return this.mCameraOpened;
    }

    public CameraSupportFeatures getSupportFeatures() {
        try {
            this.featureFetchLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.mCameraSupportFeatures;
    }

    public void autoFocus(final FocusCallback callback) {
        this.checkExecutor();
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.innerAutoFocus(callback);
            }
        });
    }

    private void checkExecutor() {
        if (mCameraExecutor == null) {
            Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName("WeCameraThread");
                    return thread;
                }
            });
        }
    }

    private void innerAutoFocus(final FocusCallback callback) {
        WeCameraLogger.d(TAG, "execute auto focus task.", new Object[0]);
        final boolean result = this.mCameraDevice.autoFocus();
        WeUI.post(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.i(WeCamera.TAG, "autoFocus result:" + result, new Object[0]);
                if (result) {
                    callback.onFocusOk(WeCamera.this);
                } else {
                    callback.onFocusFailed();
                }
            }
        });
    }

    public void takeZoom(final float zoom) {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.innerTakeZoom(zoom);
            }
        });
    }

    private void innerTakeZoom(float zoom) {
        WeCameraLogger.d(TAG, "execute zoom task.", new Object[0]);
        this.mCameraDevice.takeZoom(zoom);
        this.mCameraListeners.cameraConfigChanged(this.mCameraDevice.getDisplayFeature(), this.mCameraV, this.mCameraDevice.updateConfig(null));
    }

    public void start() {
        if (this.useMainThread) {
            this.startCameraInner();
            return;
        }
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.startCameraInner();
            }
        });
    }

    private void startCameraInner() {
        boolean b;
        if (this.mCameraOpened) {
            WeCameraLogger.d(TAG, "weCamera has started", new Object[0]);
            return;
        }
        WeCameraLogger.d(TAG, "execute start camera task.", new Object[0]);
        this.startCameraTime = System.currentTimeMillis();
        Object cameraV = this.mCameraDevice.open(this.mCameraFacing);
        if (cameraV == null) {
            return;
        }
        this.mCameraV = cameraV;
        this.mCameraOpened = true;
        this.cameraConfig = this.mCameraDevice.updateConfig(this.mCameraConfigSelectors);
        this.mCameraDevice.setDisplayOrientation(this.mCameraConfigSelectors.displayOrientationOperator(), CameraUtils.getScreenRealOrientation(this.mContext));
        this.displayFeature = this.mCameraDevice.getDisplayFeature();
        this.cameraConfig.setPreviewParameter(this.displayFeature);
        this.mCameraListeners.cameraOpened(this.mCameraDevice, (CameraV)cameraV, this.cameraConfig);
        if (this.mCameraView != null) {
            this.mCameraView.setPreviewConfig(this.mScaleType, this.getDisplayFeature());
        }
        this.mPreviewProcessor = this.mCameraDevice.getPreviewProcessor();
        if (this.mWePreviewCallbacks.size() > 0) {
            for (int i = 0; i < this.mWePreviewCallbacks.size(); ++i) {
                this.mPreviewProcessor.addPreviewFrameCallback(this.mWePreviewCallbacks.get(i));
            }
            this.mPreviewProcessor.start();
            this.previewCallbackStart = true;
        }
        if (!this.useMainThread && this.mCameraView != null && !(b = this.mCameraView.afterCameraConfigured(this, (CameraV1)cameraV))) {
            WeCameraLogger.i(TAG, "attachCameraView result=false", new Object[0]);
            return;
        }
    }

    public void setDisplayViewAndStartPreview(Object displayView) {
        this.mCameraDevice.setDisplayView(displayView);
        this.startPreviewInner();
        this.mCameraView.onAfterStartPreview();
        WeCameraLogger.d(TAG, "start useTime:" + (System.currentTimeMillis() - this.startCameraTime), new Object[0]);
    }

    public void startPreviewInner() {
        this.mCameraListeners.previewBeforeStart(this.mCameraView, this.cameraConfig, this.displayFeature, this.mCameraV);
        this.mCameraDevice.startPreview();
        this.mCameraListeners.previewAfterStart(this.mCameraDevice);
    }

    public void stop() {
        this.stopPreviewCallback();
        if (this.useMainThread) {
            this.stopCameraInner();
            return;
        }
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.stopCameraInner();
            }
        });
    }

    public void stopCameraInner() {
        if (!this.mCameraOpened) {
            WeCameraLogger.d(TAG, "weCamera has stopped", new Object[0]);
            return;
        }
        WeCameraLogger.d(TAG, "execute stop camera task.", new Object[0]);
        this.mCameraListeners.previewBeforeStop(this.mCameraDevice);
        this.mCameraDevice.stopPreview();
        this.mCameraOpened = false;
        this.mCameraDevice.close();
        this.mCameraListeners.cameraClosed();
    }

    public void updateConfig(final UpdateRequest updateRequest) {
        if (this.useMainThread) {
            this.updateConfigInner(updateRequest);
            return;
        }
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.updateConfigInner(updateRequest);
            }
        });
    }

    private void updateConfigInner(UpdateRequest updateRequest) {
        WeCameraLogger.d(TAG, "execute update parameter task.", new Object[0]);
        CameraConfig cameraConfig = this.mCameraDevice.updateConfig(updateRequest.selectors());
        this.mCameraListeners.cameraConfigChanged(this.mCameraDevice.getDisplayFeature(), this.mCameraV, cameraConfig);
    }

    public WeCamera previewCallback(WePreviewCallback wePreviewCallback) {
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.add(wePreviewCallback);
            if (this.mPreviewProcessor != null) {
                this.mPreviewProcessor.addPreviewFrameCallback(wePreviewCallback);
            }
        }
        return this;
    }

    public WeCamera removePreviewCallback(WePreviewCallback wePreviewCallback) {
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.remove(wePreviewCallback);
            if (this.mPreviewProcessor != null) {
                this.mPreviewProcessor.removePreviewFrameCallback(wePreviewCallback);
            }
        }
        return this;
    }

    public void startPreviewCallback() {
        if (this.useMainThread) {
            this.startPreviewCallbackInner();
            return;
        }
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.startPreviewCallbackInner();
            }
        });
    }

    private void startPreviewCallbackInner() {
        WeCameraLogger.d(TAG, "execute start preview callback task.", new Object[0]);
        if (this.canUse() && !this.previewCallbackStart && this.mPreviewProcessor != null) {
            WeCameraLogger.i(TAG, "start Preview Callback", new Object[0]);
            this.previewCallbackStart = true;
            this.mPreviewProcessor.start();
        }
    }

    public WeCamera runInCameraThread(Runnable runnable) {
        if (runnable != null) {
            mCameraExecutor.submit(runnable);
        }
        return this;
    }

    public void stopPreviewCallback() {
        if (this.useMainThread) {
            this.stopPreviewCallbackInner();
            return;
        }
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCamera.this.stopPreviewCallbackInner();
            }
        });
    }

    private void stopPreviewCallbackInner() {
        WeCameraLogger.d(TAG, "execute stop preview callback task.", new Object[0]);
        if (this.canUse() && this.previewCallbackStart && this.mPreviewProcessor != null) {
            WeCameraLogger.i(TAG, "stop Preview Callback", new Object[0]);
            this.previewCallbackStart = false;
            this.mPreviewProcessor.stop();
        }
    }

    public PreviewParameter getDisplayFeature() {
        return this.mCameraDevice.getDisplayFeature();
    }
}

