/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.api.utils;

import android.util.Log;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class JsonHelper {
    private static final String TAG = "JSONHelper";

    public static String toJSON(Object obj) {
        JSONStringer js = new JSONStringer();
        JsonHelper.serialize(js, obj);
        return js.toString();
    }

    private static void serialize(JSONStringer js, Object o) {
        if (JsonHelper.isNull(o)) {
            try {
                js.value(null);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return;
        }
        Class<?> clazz = o.getClass();
        if (JsonHelper.isObject(clazz)) {
            JsonHelper.serializeObject(js, o);
        } else if (JsonHelper.isArray(clazz)) {
            JsonHelper.serializeArray(js, o);
        } else if (JsonHelper.isCollection(clazz)) {
            Collection collection = (Collection)o;
            JsonHelper.serializeCollect(js, collection);
        } else if (JsonHelper.isMap(clazz)) {
            HashMap collection = (HashMap)o;
            JsonHelper.serializeMap(js, collection);
        } else {
            try {
                js.value(o);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private static void serializeArray(JSONStringer js, Object array) {
        try {
            js.array();
            for (int i = 0; i < Array.getLength(array); ++i) {
                Object o = Array.get(array, i);
                JsonHelper.serialize(js, o);
            }
            js.endArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void serializeCollect(JSONStringer js, Collection<?> collection) {
        try {
            js.array();
            for (Object o : collection) {
                JsonHelper.serialize(js, o);
            }
            js.endArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void serializeMap(JSONStringer js, Map<?, ?> map) {
        try {
            js.object();
            Map<?, ?> valueMap = map;
            for (Map.Entry<?, ?> entry : valueMap.entrySet()) {
                js.key((String)entry.getKey());
                JsonHelper.serialize(js, entry.getValue());
            }
            js.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void serializeObject(JSONStringer js, Object obj) {
        try {
            Field[] fields;
            js.object();
            Class<?> objClazz = obj.getClass();
            Method[] methods = objClazz.getDeclaredMethods();
            for (Field field : fields = objClazz.getDeclaredFields()) {
                try {
                    String fieldType = field.getType().getSimpleName();
                    String fieldGetName = JsonHelper.parseMethodName(field.getName(), "get");
                    if (!JsonHelper.haveMethod(methods, fieldGetName)) continue;
                    Method fieldGetMet = objClazz.getMethod(fieldGetName, new Class[0]);
                    Object fieldVal = fieldGetMet.invoke(obj, new Object[0]);
                    String result = null;
                    if ("Date".equals(fieldType)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                        result = sdf.format((Date)fieldVal);
                    } else if (null != fieldVal) {
                        result = String.valueOf(fieldVal);
                    }
                    js.key(field.getName());
                    JsonHelper.serialize(js, result);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            js.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean haveMethod(Method[] methods, String fieldMethod) {
        for (Method met : methods) {
            if (!fieldMethod.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    public static String parseMethodName(String fieldName, String methodType) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        return methodType + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static void setFieldValue(Object obj, Map<String, String> valMap) {
        Field[] fields;
        Class<?> cls = obj.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                Constable temp;
                String setMetodName = JsonHelper.parseMethodName(field.getName(), "set");
                if (!JsonHelper.haveMethod(methods, setMetodName)) continue;
                Method fieldMethod = cls.getMethod(setMetodName, field.getType());
                String value = valMap.get(field.getName());
                if (null == value || "".equals(value)) continue;
                String fieldType = field.getType().getSimpleName();
                if ("String".equals(fieldType)) {
                    fieldMethod.invoke(obj, value);
                    continue;
                }
                if ("Date".equals(fieldType)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                    Date temp2 = sdf.parse(value);
                    fieldMethod.invoke(obj, temp2);
                    continue;
                }
                if ("Integer".equals(fieldType) || "int".equals(fieldType)) {
                    Integer intval = Integer.parseInt(value);
                    fieldMethod.invoke(obj, intval);
                    continue;
                }
                if ("Long".equalsIgnoreCase(fieldType)) {
                    temp = Long.parseLong(value);
                    fieldMethod.invoke(obj, temp);
                    continue;
                }
                if ("Double".equalsIgnoreCase(fieldType)) {
                    temp = Double.parseDouble(value);
                    fieldMethod.invoke(obj, temp);
                    continue;
                }
                if ("Boolean".equalsIgnoreCase(fieldType)) {
                    temp = Boolean.valueOf(Boolean.parseBoolean(value));
                    fieldMethod.invoke(obj, temp);
                    continue;
                }
                System.out.println("setFieldValue not supper type:" + fieldType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Map<String, String> beanToMap(Object obj) {
        Field[] fields;
        Class<?> cls = obj.getClass();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                String fieldType = field.getType().getSimpleName();
                String fieldGetName = JsonHelper.parseMethodName(field.getName(), "get");
                if (!JsonHelper.haveMethod(methods, fieldGetName)) continue;
                Method fieldGetMet = cls.getMethod(fieldGetName, new Class[0]);
                Object fieldVal = fieldGetMet.invoke(obj, new Object[0]);
                String result = null;
                if ("Date".equals(fieldType)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
                    result = sdf.format((Date)fieldVal);
                } else if (null != fieldVal) {
                    result = String.valueOf(fieldVal);
                }
                valueMap.put(field.getName(), result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return valueMap;
    }

    public static void setFiedlValue(Object obj, Method fieldSetMethod, String fieldType, Object value) {
        try {
            if (null != value && !"".equals(value)) {
                if ("String".equals(fieldType)) {
                    fieldSetMethod.invoke(obj, value.toString());
                } else if ("Date".equals(fieldType)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
                    Date temp = sdf.parse(value.toString());
                    fieldSetMethod.invoke(obj, temp);
                } else if ("Integer".equals(fieldType) || "int".equals(fieldType)) {
                    Integer intval = Integer.parseInt(value.toString());
                    fieldSetMethod.invoke(obj, intval);
                } else if ("Long".equalsIgnoreCase(fieldType)) {
                    Long temp = Long.parseLong(value.toString());
                    fieldSetMethod.invoke(obj, temp);
                } else if ("Double".equalsIgnoreCase(fieldType)) {
                    Double temp = Double.parseDouble(value.toString());
                    fieldSetMethod.invoke(obj, temp);
                } else if ("Boolean".equalsIgnoreCase(fieldType)) {
                    Boolean temp = Boolean.parseBoolean(value.toString());
                    fieldSetMethod.invoke(obj, temp);
                } else {
                    fieldSetMethod.invoke(obj, value);
                    Log.e((String)TAG, (String)("JSONHelper>>>>setFiedlValue -> not supper type" + fieldType));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T parseObject(JSONObject jo, Class<T> clazz) throws JSONException {
        if (clazz == null || JsonHelper.isNull(jo)) {
            return null;
        }
        T obj = JsonHelper.newInstance(clazz);
        if (obj == null) {
            return null;
        }
        if (JsonHelper.isMap(clazz)) {
            JsonHelper.setField(obj, jo);
        } else {
            Field[] fields;
            Method[] methods = clazz.getDeclaredMethods();
            for (Field f : fields = clazz.getDeclaredFields()) {
                String setMetodName = JsonHelper.parseMethodName(f.getName(), "set");
                if (!JsonHelper.haveMethod(methods, setMetodName)) continue;
                try {
                    Method fieldMethod = clazz.getMethod(setMetodName, f.getType());
                    JsonHelper.setField(obj, fieldMethod, f, jo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return obj;
    }

    public static <T> T parseObject(String jsonStr, Class<T> clazz) throws JSONException {
        if (clazz == null || jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        JSONObject jo = null;
        jo = new JSONObject(jsonStr);
        if (JsonHelper.isNull(jo)) {
            return null;
        }
        return JsonHelper.parseObject(jo, clazz);
    }

    public static <T> T[] parseArray(JSONArray ja, Class<T> clazz) {
        if (clazz == null || JsonHelper.isNull(ja)) {
            return null;
        }
        int len = ja.length();
        Object[] array = (Object[])Array.newInstance(clazz, len);
        for (int i = 0; i < len; ++i) {
            try {
                JSONObject jo = ja.getJSONObject(i);
                T o = JsonHelper.parseObject(jo, clazz);
                array[i] = o;
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    public static <T> T[] parseArray(String jsonStr, Class<T> clazz) {
        if (clazz == null || jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        JSONArray jo = null;
        try {
            jo = new JSONArray(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (JsonHelper.isNull(jo)) {
            return null;
        }
        return JsonHelper.parseArray(jo, clazz);
    }

    public static <T> Collection<T> parseCollection(JSONArray ja, Class<?> collectionClazz, Class<T> genericType) throws JSONException {
        if (collectionClazz == null || genericType == null || JsonHelper.isNull(ja)) {
            return null;
        }
        Collection collection = (Collection)JsonHelper.newInstance(collectionClazz);
        for (int i = 0; i < ja.length(); ++i) {
            try {
                JSONObject jo = ja.getJSONObject(i);
                T o = JsonHelper.parseObject(jo, genericType);
                collection.add(o);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return collection;
    }

    public static <T> Collection<T> parseCollection(String jsonStr, Class<?> collectionClazz, Class<T> genericType) throws JSONException {
        if (collectionClazz == null || genericType == null || jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        JSONArray jo = null;
        try {
            int index = jsonStr.indexOf("[");
            String arrayString = null;
            if (-1 != index) {
                arrayString = jsonStr.substring(index);
            }
            jo = null != arrayString ? new JSONArray(arrayString) : new JSONArray(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (JsonHelper.isNull(jo)) {
            return null;
        }
        return JsonHelper.parseCollection(jo, collectionClazz, genericType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T newInstance(Class<T> clazz) throws JSONException {
        void var1_6;
        if (clazz == null) {
            return null;
        }
        Object var1_1 = null;
        if (clazz.isInterface()) {
            if (clazz.equals(Map.class)) {
                HashMap hashMap = new HashMap();
                return var1_6;
            } else if (clazz.equals(List.class)) {
                ArrayList arrayList = new ArrayList();
                return var1_6;
            } else {
                if (!clazz.equals(Set.class)) throw new JSONException("unknown interface: " + clazz);
                HashSet hashSet = new HashSet();
            }
            return var1_6;
        }
        try {
            T t = clazz.newInstance();
            return var1_6;
        }
        catch (Exception e) {
            throw new JSONException("unknown class type: " + clazz);
        }
    }

    private static void setField(Object obj, JSONObject jo) {
        try {
            Iterator keyIter = jo.keys();
            Map valueMap = (Map)obj;
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Object value = jo.get(key);
                valueMap.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void setField(Object obj, Method fieldSetMethod, Field field, JSONObject jo) {
        block11: {
            String name = field.getName();
            Class<?> clazz = field.getType();
            try {
                if (JsonHelper.isArray(clazz)) {
                    Class<?> c = clazz.getComponentType();
                    JSONArray ja = jo.optJSONArray(name);
                    if (!JsonHelper.isNull(ja)) {
                        ?[] array = JsonHelper.parseArray(ja, c);
                        JsonHelper.setFiedlValue(obj, fieldSetMethod, clazz.getSimpleName(), array);
                    }
                    break block11;
                }
                if (JsonHelper.isCollection(clazz)) {
                    JSONArray ja;
                    ParameterizedType ptype;
                    Type[] targs;
                    Class c = null;
                    Type gType = field.getGenericType();
                    if (gType instanceof ParameterizedType && (targs = (ptype = (ParameterizedType)gType).getActualTypeArguments()) != null && targs.length > 0) {
                        Type t = targs[0];
                        c = (Class)t;
                    }
                    if (!JsonHelper.isNull(ja = jo.optJSONArray(name))) {
                        Collection o = JsonHelper.parseCollection(ja, clazz, c);
                        JsonHelper.setFiedlValue(obj, fieldSetMethod, clazz.getSimpleName(), o);
                    }
                    break block11;
                }
                if (JsonHelper.isSingle(clazz)) {
                    Object o = jo.opt(name);
                    if (o != null) {
                        JsonHelper.setFiedlValue(obj, fieldSetMethod, clazz.getSimpleName(), o);
                    }
                    break block11;
                }
                if (JsonHelper.isObject(clazz)) {
                    JSONObject j = jo.optJSONObject(name);
                    if (!JsonHelper.isNull(j)) {
                        Object o = JsonHelper.parseObject(j, clazz);
                        JsonHelper.setFiedlValue(obj, fieldSetMethod, clazz.getSimpleName(), o);
                    }
                    break block11;
                }
                throw new Exception("unknow type!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void setField(Object obj, Field field, JSONObject jo) {
        block13: {
            String name = field.getName();
            Class<?> clazz = field.getType();
            try {
                if (JsonHelper.isArray(clazz)) {
                    Class<?> c = clazz.getComponentType();
                    JSONArray ja = jo.optJSONArray(name);
                    if (!JsonHelper.isNull(ja)) {
                        ?[] array = JsonHelper.parseArray(ja, c);
                        field.set(obj, array);
                    }
                    break block13;
                }
                if (JsonHelper.isCollection(clazz)) {
                    JSONArray ja;
                    ParameterizedType ptype;
                    Type[] targs;
                    Class c = null;
                    Type gType = field.getGenericType();
                    if (gType instanceof ParameterizedType && (targs = (ptype = (ParameterizedType)gType).getActualTypeArguments()) != null && targs.length > 0) {
                        Type t = targs[0];
                        c = (Class)t;
                    }
                    if (!JsonHelper.isNull(ja = jo.optJSONArray(name))) {
                        Collection o = JsonHelper.parseCollection(ja, clazz, c);
                        field.set(obj, o);
                    }
                    break block13;
                }
                if (JsonHelper.isSingle(clazz)) {
                    Object o = jo.opt(name);
                    if (o != null) {
                        field.set(obj, o);
                    }
                    break block13;
                }
                if (JsonHelper.isObject(clazz)) {
                    JSONObject j = jo.optJSONObject(name);
                    if (!JsonHelper.isNull(j)) {
                        Object o = JsonHelper.parseObject(j, clazz);
                        field.set(obj, o);
                    }
                    break block13;
                }
                if (JsonHelper.isList(clazz)) {
                    JSONObject j = jo.optJSONObject(name);
                    if (!JsonHelper.isNull(j)) {
                        Object o = JsonHelper.parseObject(j, clazz);
                        field.set(obj, o);
                    }
                    break block13;
                }
                throw new Exception("unknow type!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isNull(Object obj) {
        if (obj instanceof JSONObject) {
            return JSONObject.NULL.equals(obj);
        }
        return obj == null;
    }

    private static boolean isSingle(Class<?> clazz) {
        return JsonHelper.isBoolean(clazz) || JsonHelper.isNumber(clazz) || JsonHelper.isString(clazz);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    public static boolean isNumber(Class<?> clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz));
    }

    public static boolean isString(Class<?> clazz) {
        return clazz != null && (String.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz));
    }

    private static boolean isObject(Class<?> clazz) {
        return clazz != null && !JsonHelper.isSingle(clazz) && !JsonHelper.isArray(clazz) && !JsonHelper.isCollection(clazz) && !JsonHelper.isMap(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public static boolean isList(Class<?> clazz) {
        return clazz != null && List.class.isAssignableFrom(clazz);
    }
}

