/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.api.utils;

import com.baidu.idl.face.api.utils.FileBase64Encoder;
import com.baidu.idl.face.api.utils.HttpUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpsClient {
    public Call newCall(RequestInfo requestInfo) {
        Call call = new Call(requestInfo);
        return call;
    }

    public static class Call
    implements Runnable {
        private RequestInfo requestInfo;
        private Thread thread;
        private Callback callback;

        public Call(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
        }

        public Call enqueue(Callback callback) {
            this.callback = callback;
            this.thread = new Thread(this);
            this.thread.start();
            return this;
        }

        private void setHeaders(HttpsURLConnection con, Map<String, String> headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RequestInfo requestInfo = this.requestInfo;
            HttpURLConnection con = null;
            Exception buildException = requestInfo.getBuildException();
            if (buildException != null) {
                this.callback.onFailure(buildException);
                return;
            }
            try {
                URL url = requestInfo.getURL();
                byte[] body = requestInfo.getBody();
                con = (HttpsURLConnection)url.openConnection();
                this.setHeaders((HttpsURLConnection)con, requestInfo.getHeaders());
                con.setRequestMethod("POST");
                con.setConnectTimeout(requestInfo.getConTimeout());
                con.setReadTimeout(requestInfo.getReadTimeout());
                con.setDoOutput(true);
                OutputStream out = con.getOutputStream();
                out.write(body);
                this.writeResp((HttpsURLConnection)con);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.callback.onFailure(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }

        public void writeResp(HttpsURLConnection con) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer sb = new StringBuffer();
                char[] cs = new char[512];
                int readedNumber = 0;
                while ((readedNumber = br.read(cs)) != -1) {
                    sb.append(new String(cs, 0, readedNumber));
                }
                this.callback.onResponse(sb.toString());
                br.close();
            }
            catch (IOException e) {
                this.callback.onFailure(e);
            }
        }
    }

    public static class RequestInfo {
        private String urlStr;
        private URL url;
        private Map<String, String> headers;
        private RequestBody body;
        private Exception ex;
        private int conTimeout;
        private int readTimeout;

        public Exception getBuildException() {
            return this.ex;
        }

        public int getConTimeout() {
            return this.conTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestInfo(String urlStr, RequestBody body) {
            this.urlStr = urlStr;
            this.body = body;
            this.headers = new HashMap<String, String>();
            this.ex = null;
            this.conTimeout = HttpUtil.getOptions().getConnectionTimeoutInMillis();
            this.readTimeout = HttpUtil.getOptions().getSocketTimeoutInMillis();
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeader(String key, String value) {
            this.headers.put(key, value);
        }

        public void build() {
            try {
                this.url = new URL(this.urlStr);
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        public URL getURL() {
            return this.url;
        }

        public byte[] getBody() {
            return this.body.getBytes();
        }
    }

    public static class RequestBody {
        private StringBuffer stringBuffer = new StringBuffer();
        private int paramNumber = 0;
        private static final String UTF8 = "UTF-8";
        private static FileBase64Encoder encoder = new FileBase64Encoder();

        public void setBody(String body) {
            this.stringBuffer.append(body);
        }

        public void setStrParams(Map<String, String> params) {
            if (params == null) {
                return;
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (this.paramNumber > 0) {
                    this.stringBuffer.append("&");
                }
                String key = entry.getKey();
                String value = entry.getValue();
                try {
                    key = URLEncoder.encode(key, UTF8);
                    value = URLEncoder.encode(value, UTF8);
                    this.stringBuffer.append(key + "=" + value);
                    ++this.paramNumber;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }

        public void setFileParams(Map<String, File> params) {
            StringBuffer sb = new StringBuffer();
            if (params == null) {
                return;
            }
            for (Map.Entry<String, File> entry : params.entrySet()) {
                if (this.paramNumber > 0) {
                    this.stringBuffer.append("&");
                }
                String key = entry.getKey();
                File file = entry.getValue();
                try {
                    byte[] encoded;
                    key = URLEncoder.encode(key, UTF8);
                    encoder.setInputFile(file);
                    this.stringBuffer.append(key + "=");
                    while ((encoded = encoder.encode()) != null) {
                        sb.append(new String(encoded));
                        this.stringBuffer.append(URLEncoder.encode(new String(encoded), UTF8));
                    }
                    ++this.paramNumber;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[]{};
            try {
                bytes = String.valueOf(this.stringBuffer).getBytes(UTF8);
                return bytes;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return bytes;
            }
        }
    }

    public static interface Callback {
        public void onFailure(Throwable var1);

        public void onResponse(String var1);
    }
}

