/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.api.utils;

import android.os.Handler;
import android.os.Looper;
import com.baidu.idl.face.api.OnResultListener;
import com.baidu.idl.face.api.exception.FaceException;
import com.baidu.idl.face.api.model.RequestParams;
import com.baidu.idl.face.api.utils.HttpsClient;
import com.baidu.idl.face.api.utils.JsonHelper;

public class HttpUtil {
    private static final String TAG = HttpUtil.class.getSimpleName();
    private static volatile HttpUtil instance;
    private Handler handler = new Handler(Looper.getMainLooper());
    private static Options options;

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> void post(String path, RequestParams params, final OnResultListener<String> listener) {
        HttpsClient cl = new HttpsClient();
        HttpsClient.RequestBody body = new HttpsClient.RequestBody();
        body.setBody(JsonHelper.toJSON(params.getStringParams()));
        HttpsClient.RequestInfo reqInfo = new HttpsClient.RequestInfo(path, body);
        reqInfo.setHeader("Content-Type", "application/json;charset=utf-8");
        reqInfo.build();
        cl.newCall(reqInfo).enqueue(new HttpsClient.Callback(){

            @Override
            public void onFailure(Throwable e) {
                HttpUtil.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpUtil.this.throwError(listener, -1001, "\u7f51\u7edc\u5f02\u5e38");
                    }
                });
            }

            @Override
            public void onResponse(final String resultStr) {
                HttpUtil.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResult(resultStr);
                    }
                });
            }
        });
    }

    private void throwError(final OnResultListener listener, int errorCode, String msg) {
        final FaceException error = new FaceException(errorCode, msg);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                listener.onError(error);
            }
        });
    }

    public static Options getOptions() {
        return options;
    }

    static {
        options = new Options();
    }

    public static class Options {
        private int connectionTimeoutInMillis = 10000;
        private int socketTimeoutInMillis = 10000;

        public int getConnectionTimeoutInMillis() {
            return this.connectionTimeoutInMillis;
        }

        public void setConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
            this.connectionTimeoutInMillis = connectionTimeoutInMillis;
        }

        public int getSocketTimeoutInMillis() {
            return this.socketTimeoutInMillis;
        }

        public void setSocketTimeoutInMillis(int socketTimeoutInMillis) {
            this.socketTimeoutInMillis = socketTimeoutInMillis;
        }
    }
}

